/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data.danmaku;

import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.data.danmaku.PositionGetter;
import cc.thonly.reverie_dreams.data.danmaku.spellcard.SpellCardFrameConfig;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellcardRenderer {
    public static final Codec<List<List<SpellCardFrameConfig>>> FRAMES_CODEC = Codec.list((Codec)Codec.list(SpellCardFrameConfig.CODEC));
    public static final Codec<SpellcardRenderer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FRAMES_CODEC.fieldOf("frames").forGetter(SpellcardRenderer::getFrames)).apply((Applicative)instance, SpellcardRenderer::new));
    private static final Set<SpellcardRenderer> TICKER = new LinkedHashSet<SpellcardRenderer>();
    private static final int MAX_SPAWN_PER_TICK = 64;
    @Nullable
    private class_1297 source;
    private class_243 position;
    @Nullable
    private PositionGetter positionGetter;
    private class_3218 world;
    private final List<List<SpellCardFrameConfig>> frames;
    private final Random random = new Random();
    private final Map<DanmakuType, Map<Integer, class_1799>> STACK_CACHED = new Object2ObjectOpenHashMap();
    private boolean canceled = false;
    private int tick = 0;
    private int maxTick = 100;

    public SpellcardRenderer(@Nullable class_1297 source, @NotNull class_3218 world, List<List<SpellCardFrameConfig>> frames, int tick, int maxTick) {
        this.source = source;
        this.position = source != null ? source.method_33571() : class_243.field_1353;
        this.world = world;
        this.frames = this.copyFramesConfig(frames);
        this.tick = tick;
        this.maxTick = maxTick;
    }

    public SpellcardRenderer(@NotNull class_243 position, @NotNull class_3218 world, List<List<SpellCardFrameConfig>> frames, int tick, int maxTick) {
        this.source = null;
        this.position = position;
        this.world = world;
        this.frames = this.copyFramesConfig(frames);
        this.tick = tick;
        this.maxTick = maxTick;
    }

    public SpellcardRenderer(List<List<SpellCardFrameConfig>> frames) {
        this.frames = this.copyFramesConfig(frames);
        this.maxTick = this.searchMaxTick(frames);
    }

    public static SpellcardRenderer addRenderer(SpellcardRenderer renderer) {
        TICKER.add(renderer);
        return renderer;
    }

    public static void tick(MinecraftServer server) {
        Iterator<SpellcardRenderer> iterator = TICKER.iterator();
        while (iterator.hasNext()) {
            SpellcardRenderer renderer = iterator.next();
            renderer.update();
            if (!renderer.canceled && renderer.tick <= renderer.maxTick) continue;
            iterator.remove();
            renderer.cleanup();
        }
    }

    private int searchMaxTick(List<List<SpellCardFrameConfig>> frames) {
        int maxTick = 0;
        for (List<SpellCardFrameConfig> frameList : frames) {
            for (SpellCardFrameConfig config : frameList) {
                int endTick = config.getTickDelay() + config.getTickDuration();
                if (endTick <= maxTick) continue;
                maxTick = endTick;
            }
        }
        return maxTick;
    }

    private List<List<SpellCardFrameConfig>> copyFramesConfig(List<List<SpellCardFrameConfig>> frames) {
        ArrayList<List<SpellCardFrameConfig>> copy = new ArrayList<List<SpellCardFrameConfig>>();
        for (List<SpellCardFrameConfig> frame : frames) {
            ArrayList<SpellCardFrameConfig> frameCopy = new ArrayList<SpellCardFrameConfig>();
            for (SpellCardFrameConfig config : frame) {
                frameCopy.add(config.copy());
            }
            copy.add(frameCopy);
        }
        return copy;
    }

    protected void update() {
        if (this.canceled) {
            return;
        }
        ++this.tick;
        if (this.tick > this.maxTick) {
            this.cancel();
            return;
        }
        if (this.source != null && this.source.method_31481()) {
            this.cancel();
            return;
        }
        int spawned = 0;
        for (List<SpellCardFrameConfig> frame : this.frames) {
            for (SpellCardFrameConfig config : frame) {
                int relativeTick = this.tick - config.getTickDelay();
                if (relativeTick < 0 || relativeTick > config.getTickDuration() || relativeTick % config.getTickInterval() != 0) continue;
                float pitchStart = config.getPitchRange().getStart();
                float pitchEnd = config.getPitchRange().getEnd();
                float yawStart = config.getYawRange().getStart();
                float yawEnd = config.getYawRange().getEnd();
                int count = Math.max(1, config.getDensity());
                float pitchStep = (pitchEnd - pitchStart) / (float)count;
                float yawStep = (yawEnd - yawStart) / (float)count;
                for (int i = 0; i < count && spawned < 64; ++spawned, ++i) {
                    float pitch = pitchStart + pitchStep * (float)i;
                    float yaw = yawStart + yawStep * (float)i;
                    if (config.isRandomColor()) {
                        this.spawnDanmaku(config.getType(), config.getSpeed(), pitch, yaw);
                        continue;
                    }
                    this.spawnDanmaku(config.getType(), (float)config.getColor(), pitch, yaw);
                }
                if (spawned < 64) continue;
                break;
            }
            if (spawned < 64) continue;
            break;
        }
    }

    private void spawnDanmaku(DanmakuType type, float speed, float pitch, float yaw) {
        int r = 128 + ThreadLocalRandom.current().nextInt(128);
        int g = 128 + ThreadLocalRandom.current().nextInt(128);
        int b = 128 + ThreadLocalRandom.current().nextInt(128);
        int color = r << 16 | g << 8 | b;
        class_1799 danmakuStack = this.getDanmakuStack(type, color);
        this.spawnDanmaku(danmakuStack, speed, pitch, yaw);
    }

    private void spawnDanmaku(DanmakuType type, float speed, int color, float pitch, float yaw) {
        class_1799 danmakuStack = this.getDanmakuStack(type, color);
        this.spawnDanmaku(danmakuStack, speed, pitch, yaw);
    }

    private void spawnDanmaku(class_1799 itemStack, float speed, float pitch, float yaw) {
        DanmakuProperties properties = (DanmakuProperties)itemStack.method_58694(RDDataComponentTypes.DANMAKU_PROPERTIES);
        if (properties == null) {
            return;
        }
        properties = properties.withSpeed(speed);
        if (this.source != null) {
            this.position = new class_243(this.source.method_23317(), this.source.method_23320(), this.source.method_23321());
        }
        if (this.position == null && this.positionGetter != null) {
            this.position = this.positionGetter.getPosition(this.tick);
        }
        if (this.position == null) {
            return;
        }
        DanmakuEntity danmakuEntity = new DanmakuEntity(this.source, this.world, this.position.field_1352, this.position.field_1351, this.position.field_1350, itemStack, properties, Float.valueOf(pitch), Float.valueOf(yaw), Float.valueOf(0.0f), Float.valueOf(0.0f), false);
        this.world.method_8649((class_1297)danmakuEntity);
    }

    private class_1799 getDanmakuStack(DanmakuType type, int color) {
        class_1799 itemStack;
        Map colorStackMap = this.STACK_CACHED.computeIfAbsent(type, t -> new Object2ObjectOpenHashMap());
        if (colorStackMap.size() > 64) {
            colorStackMap.clear();
        }
        if ((itemStack = (class_1799)colorStackMap.get(color)) != null) {
            return itemStack.method_7972();
        }
        class_1792 item = type.getItem();
        itemStack = item.method_7854();
        itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(color));
        colorStackMap.put(color, itemStack);
        return itemStack;
    }

    public void cancel() {
        this.canceled = true;
        this.cleanup();
    }

    private void cleanup() {
        this.frames.clear();
        this.STACK_CACHED.clear();
        this.source = null;
    }

    public SpellcardRenderer copy() {
        return new SpellcardRenderer(this.frames);
    }

    @Nullable
    @Generated
    public class_1297 getSource() {
        return this.source;
    }

    @Generated
    public class_243 getPosition() {
        return this.position;
    }

    @Nullable
    @Generated
    public PositionGetter getPositionGetter() {
        return this.positionGetter;
    }

    @Generated
    public class_3218 getWorld() {
        return this.world;
    }

    @Generated
    public List<List<SpellCardFrameConfig>> getFrames() {
        return this.frames;
    }

    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public Map<DanmakuType, Map<Integer, class_1799>> getSTACK_CACHED() {
        return this.STACK_CACHED;
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }

    @Generated
    public int getTick() {
        return this.tick;
    }

    @Generated
    public int getMaxTick() {
        return this.maxTick;
    }

    @Generated
    public void setSource(@Nullable class_1297 source) {
        this.source = source;
    }

    @Generated
    public void setPosition(class_243 position) {
        this.position = position;
    }

    @Generated
    public void setPositionGetter(@Nullable PositionGetter positionGetter) {
        this.positionGetter = positionGetter;
    }

    @Generated
    public void setWorld(class_3218 world) {
        this.world = world;
    }
}

