/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.debug;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugExportWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DebugExportWriter.class);
    private static final Map<String, DebugExportWriter> INSTANCES = new Object2ObjectOpenHashMap();
    public static final String RDDE = "reverie_dreams_debug_export.txt";
    public static final DebugExportWriter OUTPUT = DebugExportWriter.createInstance("reverie_dreams_debug_export.txt");
    private final String filename;
    private final LinkedList<String> lines = new LinkedList();

    private DebugExportWriter(String filename) {
        this.filename = filename;
    }

    protected static DebugExportWriter createInstance(String filename) {
        return INSTANCES.computeIfAbsent(filename, x -> new DebugExportWriter(filename));
    }

    public static DebugExportWriter getInstance(String filename) {
        return INSTANCES.get(filename);
    }

    public DebugExportWriter write(String format, Object ... args) {
        this.lines.add(String.format(format, args));
        return this;
    }

    public boolean export() {
        try {
            Path path = Path.of("./" + this.filename, new String[0]);
            Files.createDirectories(path.getParent() != null ? path.getParent() : Path.of(".", new String[0]), new FileAttribute[0]);
            Files.write(path.toAbsolutePath(), this.lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            log.info("Success to export debug write in {}", (Object)path.toAbsolutePath());
            return true;
        }
        catch (IOException e) {
            log.error("Can't export debug writer", (Throwable)e);
            return false;
        }
    }
}

