/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.entity.villager;

import cc.thonly.reverie_dreams.entity.villager.AbstractSellerEntity;
import cc.thonly.reverie_dreams.item.base.DrinkItem;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.registry.content.item.RDDrinkItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_3545;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3989;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.server.MinecraftServer;

public class TavernVillager
extends AbstractSellerEntity {
    private static final List<class_3545<class_1792, Integer>> ALWAYS_ITEMS = new ArrayList<class_3545>(List.of(new class_3545((Object)RDDrinkItems.GREEN_TEA, (Object)8), new class_3545((Object)RDDrinkItems.FRUITY_HIGH_BALL, (Object)8), new class_3545((Object)RDDrinkItems.FRUITY_SOUR, (Object)8), new class_3545((Object)RDDrinkItems.QI, (Object)8)));

    public TavernVillager(class_1299<? extends class_3989> entityType, class_1937 world) {
        super(entityType, world);
    }

    public TavernVillager(class_1937 world) {
        super(RDEntityTypes.TAVERN_VILLAGER, world);
    }

    public TavernVillager(class_3850 prev, class_1937 world) {
        super(RDEntityTypes.TAVERN_VILLAGER, world);
        this.prev = prev;
    }

    public TavernVillager(class_1646 prevEntity, class_1937 world) {
        super(RDEntityTypes.TAVERN_VILLAGER, world);
        this.prev = prevEntity.method_7231();
    }

    @Override
    public List<class_1914> getVillagerOffers() {
        long seed = this.getVillagerSeed();
        Random random = new Random(seed);
        ArrayList<class_1914> offers = new ArrayList<class_1914>();
        for (class_3545<class_1792, Integer> class_35452 : ALWAYS_ITEMS) {
            class_1792 class_17922 = (class_1792)class_35452.method_15442();
            int amount = (Integer)class_35452.method_15441();
            class_1799 sellItem = new class_1799((class_1935)class_17922, 6);
            ItemStackWrapper wrapper = ItemStackWrapper.of(sellItem);
            class_9306 first = new class_9306((class_1935)RDItems.COPPER_COIN, amount);
            class_9306 second = new class_9306((class_1935)class_1802.field_8469, 1);
            class_1914 offer = new class_1914(first, Optional.of(second), sellItem, Math.max(0, 2 - this.sellInfo.getSellArchive(seed, wrapper)), 1, 0.05f);
            offers.add(offer);
        }
        ArrayList<class_1792> allDrinks = new ArrayList<class_1792>(RDDrinkItems.DRINK_ITEMS);
        for (class_3545<class_1792, Integer> class_35453 : ALWAYS_ITEMS) {
            allDrinks.remove(class_35453.method_15442());
        }
        Collections.shuffle(allDrinks, random);
        int n = 4 + random.nextInt(5) + this.level;
        List list = allDrinks.subList(0, Math.min(n, allDrinks.size()));
        for (class_1792 item : list) {
            class_1799 sellItem = new class_1799((class_1935)item, 6);
            ItemStackWrapper wrapper = ItemStackWrapper.of(sellItem);
            int amount = DrinkItem.PRICE_CALCULATION_TABLE.getOrDefault(item, 8) + random.nextInt(2);
            class_9306 first = new class_9306((class_1935)RDItems.COPPER_COIN, amount);
            class_9306 second = new class_9306((class_1935)class_1802.field_8469, 1);
            class_1914 offer = new class_1914(first, Optional.of(second), sellItem, Math.max(0, 2 - this.sellInfo.getSellArchive(seed, wrapper)), 1, 0.05f);
            offers.add(offer);
        }
        return offers;
    }

    @Override
    public class_3850 getModifyVillagerData(MinecraftServer server) {
        class_5455.class_6890 registryManager = server.method_30611();
        class_2378 villagerTypeRegistry = registryManager.method_30530(class_7924.field_41235);
        class_2378 villagerProfessionRegistry = registryManager.method_30530(class_7924.field_41234);
        return new class_3850((class_6880)villagerTypeRegistry.method_46747(class_3854.field_17072), (class_6880)villagerProfessionRegistry.method_46747(class_3852.field_17054), 2);
    }

    @Override
    public boolean canReset() {
        return true;
    }
}

