package cc.thonly.mystias_izakaya.block.kitchenware;

import cc.thonly.mystias_izakaya.block.MIBlockEntities;
import cc.thonly.mystias_izakaya.block.entity.KitchenwareBlockEntity;
import cc.thonly.mystias_izakaya.gui.recipe.block.KitchenBlockGui;
import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import com.mojang.serialization.MapCodec;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.block.*;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2377;
import net.minecraft.class_2383;
import net.minecraft.class_2397;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2544;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;

@Setter
@Getter
@ToString
public class AbstractKitchenwareBlock extends class_2237 {
    public static final Set<AbstractKitchenwareBlock> KITCHENWARE_BLOCKS = new HashSet<>();
    public static final MapCodec<AbstractKitchenwareBlock> field_46280 = method_54094(AbstractKitchenwareBlock::new);

    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    private class_243 offset = new class_243(0, 0, 0);
    private Vector3f scale = new Vector3f(0, 0, 0);
    //    private final Boolean requiredEnergy;
    private final DoubleUnaryOperator bonusOperator;
    private final Double failureProbability;

    public AbstractKitchenwareBlock(class_2251 settings) {
        super(settings);
        this.bonusOperator = operand -> operand;
        this.failureProbability = 0.0;
//        this.requiredEnergy = true;
        KITCHENWARE_BLOCKS.add(this);
    }

    public AbstractKitchenwareBlock(DoubleUnaryOperator bonusOperator, Double failureProbability, Vector3f scale, class_243 offset, class_2251 settings) {
        super(settings.method_9634());
        this.offset = offset;
        this.scale = scale;
        this.bonusOperator = bonusOperator;
        this.failureProbability = failureProbability;
//        this.requiredEnergy = requiredEnergy;
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
        KITCHENWARE_BLOCKS.add(this);
    }

    @Override
    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = world.method_8320(belowPos);
        boolean pass = false;
        class_2680 downBlockState = world.method_8320(pos.method_10074());
        class_2248 upBlock = downBlockState.method_26204();
        if (upBlock instanceof class_2377|| upBlock instanceof class_2354 || upBlock instanceof class_2544 || upBlock instanceof class_2397) {
            pass = true;
        }
        return pass || belowState.method_26206(world, belowPos, class_2350.field_11036);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608() && world instanceof class_3218) {
            class_3222 serverPlayer = (class_3222) player;
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof KitchenwareBlockEntity kitchenwareBlockEntity) {
                if (kitchenwareBlockEntity.isWorking()) {
                    serverPlayer.method_7353(class_2561.method_43471("block.feedback.working"), false);
                    return class_1269.field_52422;
                }
                UUID uuid = kitchenwareBlockEntity.getUuid();
                Set<KitchenBlockGui<?>> kitchenBlockGuis = KitchenwareBlockEntity.SESSIONS.computeIfAbsent(uuid, (map) -> new HashSet<>());
                KitchenBlockGui<BaseRecipe> simpleGui = new KitchenBlockGui<>(this, kitchenwareBlockEntity, serverPlayer);
                kitchenBlockGuis.add(simpleGui);
                simpleGui.open();

                return class_1269.field_52422;
            }
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && world instanceof class_3218 serverWorld) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof KitchenwareBlockEntity kitchenwareBlockEntity) {
                class_1277 inventory = kitchenwareBlockEntity.getInventory();
                for (int i = 0; i < inventory.method_5439(); i++) {
                    class_1799 stack = inventory.method_5438(i);
                    if (stack.method_7960()) {
                        continue;
                    }
                    class_1542 itemEntity = new class_1542(serverWorld, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
                    serverWorld.method_8649(itemEntity);
                }
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    public boolean isWillBeFailure(class_1937 world) {
        class_5819 random = world.method_8409();
        double failureProbability = this.failureProbability;
        return random.method_43058() < failureProbability;
    }

    @Override
    protected MapCodec<? extends AbstractKitchenwareBlock> method_53969() {
        return field_46280;
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public @Nullable class_2680 method_9605(class_1750 ctx) {
        class_2350 direction = ctx.method_8042();
        return this.method_9564().method_11657(FACING, direction);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new KitchenwareBlockEntity(pos, state);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, MIBlockEntities.KITCHENWARE_BLOCK_ENTITY, KitchenwareBlockEntity::tick);
    }

}
