package cc.thonly.mystias_izakaya.component;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.registry.BuiltinObject;
import cc.thonly.reverie_dreams.registry.CodecStep;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.OwnerBinding;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Stream;

@ToString
public class CraftingConflict implements CodecStep<CraftingConflict>, OwnerBinding<CraftingConflict>, BuiltinObject {
    public static final Codec<CraftingConflict> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("item").forGetter((entry) -> class_7923.field_41178.method_10221(entry.item)),
            Codec.list(class_2960.field_25139).fieldOf("values").forGetter((entry) -> {
                List<class_2960> identifiers = new ArrayList<>();
                for (FoodProperty foodProperty : entry.foodProperties) {
                    class_2960 id = foodProperty.getId();
                    identifiers.add(id);
                }
                return identifiers;
            })
    ).apply(instance, CraftingConflict::new));
    @Setter
    @Getter
    private class_2960 id;
    @Getter
    private final class_1792 item;
    private final Set<FoodProperty> foodProperties = new ObjectOpenHashSet<>();
    @Setter
    @Getter
    private IntrinsicalRegister<CraftingConflict> owner;

    private CraftingConflict() {
        this.item = class_1802.field_8162;
    }

    public CraftingConflict(class_2960 item, List<class_2960> identifiers) {
        this(class_7923.field_41178.method_63535(item), identifiers);
    }

    public CraftingConflict(class_1792 item, List<class_2960> identifiers) {
        this.item = item;
        for (var identifier : identifiers) {
            FoodProperty property = MIRegistryManager.FOOD_PROPERTY.method_63535(identifier);
            if (property != null) {
                this.foodProperties.add(property);
            }
        }
    }

    public static CraftingConflict of(class_1792 item, List<FoodProperty> foodProperties) {
        List<class_2960> list = foodProperties.stream().map(FoodProperty::getId).toList();
        return new CraftingConflict(item, list);
    }

    public boolean test(class_1799 ingredient) {
        if (!ingredient.method_7909().equals(this.item)) {
            return false;
        }
        List<FoodProperty> properties = new ArrayList<>();
        properties.addAll(FoodProperty.getFromItemStack(ingredient));
        properties.addAll(FoodProperty.getFromItemStackComponent(ingredient));
        for (FoodProperty ingredientProperty : properties) {
//            System.out.println(ingredientProperty);
//            System.out.println(this.foodProperties);
            if (this.foodProperties.contains(ingredientProperty)) {
//                System.out.println(true);
                return true;
            }
        }
        return false;
    }


    public Stream<FoodProperty> stream() {
        return this.foodProperties.stream();
    }

    @Override
    public Codec<CraftingConflict> getCodec() {
        return CODEC;
    }

    public static void reload(class_3300 manager) {
        Map<class_2960, class_3298> resources = manager.method_14488("crafting_conflict", id ->
                id.method_12836().equals(MystiasIzakaya.MOD_ID) && id.method_12832().endsWith(".json")
        );
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 resId = entry.getKey();
            class_2960 id = class_2960.method_60655(resId.method_12836(), resId.method_12832().replace("crafting_conflict/", "").replace(".json", ""));
            class_3298 resource = entry.getValue();
            try (InputStream stream = resource.method_14482()) {
                JsonElement json = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                DataResult<CraftingConflict> result = CraftingConflict.CODEC.parse(JsonOps.INSTANCE, json);
                Optional<CraftingConflict> optional = result.result();
                if (optional.isPresent()) {
                    CraftingConflict conflict = optional.get();
                    conflict.setId(id);
                    MIRegistryManager.register(MIRegistryManager.CRAFTING_CONFLICT, id, conflict); // 注册
                } else {
                    MystiasIzakaya.LOGGER.error("Failed to parse crafting_conflict {}: {}", id, result.error().map(Object::toString).orElse("Unknown error"));
                }
            } catch (IOException e) {
                MystiasIzakaya.LOGGER.error("Failed to load food_property {}: {}", id, e.getMessage(), e);
            }
        }
    }

    public static void bootstrap(IntrinsicalRegister<CraftingConflict> registry) {

    }
}
