package cc.thonly.mystias_izakaya.component;

import cc.thonly.mystias_izakaya.api.FoodPropertyLoaderCallback;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.effect.ModStatusEffects;
import cc.thonly.reverie_dreams.registry.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import java.util.*;
import java.util.stream.Collectors;

@Setter
@Getter
@ToString
public class FoodProperty implements CodecStep<FoodProperty>, OwnerBinding<FoodProperty>, BuiltinObject, Translatable {
    public static final Codec<FoodProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("registry_key").forGetter(FoodProperty::getId),
            ITEMS_CODEC.fieldOf("properties").forGetter(FoodProperty::getItemList)
    ).apply(instance, FoodProperty::new));

    private class_2960 id;
    private final class_1293 effectInstance;
    private Set<class_1792> items = new ObjectOpenHashSet<>();

    private IntrinsicalRegister<FoodProperty> owner;

    public FoodProperty() {
        this.effectInstance = new class_1293(new class_1293(ModStatusEffects.EMPTY, 1));
    }

    public FoodProperty(class_1293 effectInstance) {
        this.effectInstance = effectInstance;
    }

    public FoodProperty(class_2960 id, List<class_1792> list) {
        this();
        this.id = id;
        this.items.addAll(list);
    }

    public final void use(class_3218 world, class_1309 user) {
        class_1293 effectInstance = new class_1293(this.effectInstance);
        user.method_6092(effectInstance);
        FoodPropertyLoaderCallback.EVENT.invoker().onUse(world, user, this);
        this.onUse(world, user);
    }

    public void onUse(class_3218 world, class_1309 user) {

    }

    public static String getDisplayPrefix(class_1799 itemStack, FoodProperty foodProperty) {
        List<FoodProperty> all = FoodProperty.getIngredientProperties(itemStack.method_7909());
        for (CraftingConflict conflict : MIRegistryManager.CRAFTING_CONFLICT.values()) {
            if (conflict.test(itemStack)) {
                return "§c-";
            }
        }
        return "§b+";
    }

    public Boolean is(FoodProperty property) {
        return this == property || this.getId().equals(property.getId()) || this.hashCode() == property.hashCode();
    }

    public class_2561 getTooltip() {
        return class_2561.method_43471(this.id.method_42093("food_property"));
    }

    @Override
    public String translateKey() {
        return this.id.method_42093("food_property");
    }

    public static List<FoodProperty> getAllProperties(class_1799 itemStack) {
        Set<FoodProperty> set = new HashSet<>();
        set.addAll(getIngredientProperties(itemStack.method_7909()));
        set.addAll(getFromItemStackComponent(itemStack));
        set.addAll(getFromItemStack(itemStack));
        return new ArrayList<>(set);
    }

    /**
     * 根据给定的 Item 查找所有包含该 Item 的 FoodProperty。
     * 遍历整个 FOOD_PROPERTY 注册表，检查每个 FoodProperty 是否包含该 Item。
     *
     * @param item 目标物品
     * @return 包含该 Item 的所有 FoodProperty 列表
     */
    public static List<FoodProperty> getIngredientProperties(class_1792 item) {
        Map<class_2960, FoodProperty> map = MIRegistryManager.FOOD_PROPERTY.method_29722().stream()
                .collect(Collectors.toMap(
                        entry -> entry.getKey().method_29177(),
                        Map.Entry::getValue
                ));
        List<FoodProperty> list = new ArrayList<>();
        Set<Map.Entry<class_2960, FoodProperty>> entries = map.entrySet();
        for (Map.Entry<class_2960, FoodProperty> entry : entries) {
            FoodProperty foodProperty = entry.getValue();
            Set<class_1792> tags = foodProperty.getItems();
            if (tags.contains(item)) {
                list.add(foodProperty);
            }
        }
        return list;
    }

    /**
     * 从 ItemStack 的自定义组件（MIDataComponentTypes.FOOD_PROPERTIES）中获取 FoodProperty 列表。
     * 该组件存储的是 FoodProperty 的 id 字符串列表，通过这些字符串再查询对应的 FoodProperty 对象。
     *
     * @param itemStack 目标物品栈
     * @return 对应的 FoodProperty 列表
     */
    public static List<FoodProperty> getFromItemStackComponent(class_1799 itemStack) {
        List<String> ids = itemStack.method_58695(MIDataComponentTypes.FOOD_PROPERTIES, new ArrayList<>());
        return getFromStrings(ids);
    }

    /**
     * 直接从 ItemStack 的物品（Item）获取其所有对应的 FoodProperty。
     * 实质上是调用 getIngredientProperties 来获取所有包含该物品的 FoodProperty。
     *
     * @param itemStack 目标物品栈
     * @return 包含该物品的所有 FoodProperty 列表
     */
    public static List<FoodProperty> getFromItemStack(class_1799 itemStack) {
        Map<class_2960, FoodProperty> map = MIRegistryManager.FOOD_PROPERTY.method_29722().stream()
                .collect(Collectors.toMap(
                        entry -> entry.getKey().method_29177(),
                        Map.Entry::getValue
                ));
        List<FoodProperty> list = new ArrayList<>();
        class_1792 item = itemStack.method_7909();
        Set<Map.Entry<class_2960, FoodProperty>> entries = map.entrySet();
        for (Map.Entry<class_2960, FoodProperty> entry : entries) {
            FoodProperty foodProperty = entry.getValue();
            Set<class_1792> tags = foodProperty.getItems();
            if (tags.contains(item)) {
                list.add(foodProperty);
            }
        }
        return list;
    }

    /**
     * 根据一组 FoodProperty 的 id 字符串列表，查询对应的 FoodProperty 对象列表。
     *
     * @param ids FoodProperty 的 id 字符串列表
     * @return 对应的 FoodProperty 对象列表，若 id 无对应 FoodProperty 则忽略
     */
    public static List<FoodProperty> getFromStrings(List<String> ids) {
        List<FoodProperty> list = new ArrayList<>();
        for (String id : ids) {
            class_2960 identifier = class_2960.method_60654(id);
            FoodProperty foodProperty = MIRegistryManager.FOOD_PROPERTY.method_63535(identifier);
            if (foodProperty != null) {
                list.add(foodProperty);
            }
        }
        return list;
    }

    public List<class_1792> getItemList() {
        return new ArrayList<>(this.items);
    }

    @Override
    public Codec<FoodProperty> getCodec() {
        return CODEC;
    }

}
