package cc.thonly.mystias_izakaya.datagen.generator;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.reverie_dreams.datagen.generator.DataGeneratorUtil;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.CompletableFuture;

@Slf4j
@SuppressWarnings("rawTypes")
public abstract class IngredientProvider implements class_2405 {
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, Factory> identifier2BuilderListMap = new Object2ObjectOpenHashMap<>();

    public IngredientProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
        this.configured();
    }

    public Factory createFactory(FoodProperty property) {
        class_2960 id = property.getId();
        if (this.identifier2BuilderListMap.containsKey(id)) {
            return this.identifier2BuilderListMap.get(id);
        }
        Factory factory = new Factory(id, property);
        this.identifier2BuilderListMap.put(id, factory);
        return factory;
    }

    public Factory createFactory(FoodProperty property, class_1792... items) {
        Factory factory = createFactory(property);
        factory.getList().addAll(Arrays.stream(items).toList());
        return factory;
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    protected abstract void configured();

    public void export(class_7403 writer) {
        Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR);
        try {
            for (var entry : this.identifier2BuilderListMap.entrySet()) {
                class_2960 identifier = entry.getKey();
                Factory factory = entry.getValue();
                factory.getProperty().setId(identifier);
                Path generatePath = DataGeneratorUtil.getData(path, MystiasIzakaya.MOD_ID, "food_property", null);

                DataResult<JsonElement> result = FoodProperty.CODEC.encodeStart(JsonOps.INSTANCE, factory.getProperty());
                Optional<JsonElement> optional = result.result();

                if (optional.isPresent()) {
                    JsonElement element = optional.get();
                    Path output = generatePath.resolve(identifier.method_12832() + ".json");
                    String jsonString = this.gson.toJson(element);
                    byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                    Files.createDirectories(output.getParent());

                    writer.method_43346(output, bytes, HashCode.fromBytes(bytes));
                }
            }
        } catch (Exception err) {
            log.error("Error: ", err);
        }
    }

    @Setter
    @Getter
    public static class Factory {
        private final class_2960 id;
        private final FoodProperty property;
        private final List<class_1792> list = new LinkedList<>();
        private boolean done = false;

        protected Factory(class_2960 id, FoodProperty property) {
            this.id = id;
            this.property = property;
        }

        public Factory add(class_1792 item) {
            this.list.add(item);
            return this;
        }

        public Factory add(class_1792... item) {
            this.list.addAll(Arrays.stream(item).toList());
            return this;
        }

        public void build() {
            this.property.getItems().addAll(this.list);
            this.done = true;
        }

    }


}
