package cc.thonly.mystias_izakaya.entity.villager;

import cc.thonly.mystias_izakaya.entity.MIEntities;
import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.mystias_izakaya.item.base.DrinkItem;
import cc.thonly.reverie_dreams.entity.villager.AbstractSellerEntity;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_3545;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3989;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.server.MinecraftServer;
import net.minecraft.village.*;
import java.util.*;

public class TavernVillager extends AbstractSellerEntity {

    public TavernVillager(class_1299<? extends class_3989> entityType, class_1937 world) {
        super(entityType, world);
    }

    public TavernVillager(class_1937 world) {
        super(MIEntities.TAVERN_VILLAGER, world);
    }

    public TavernVillager(class_3850 prev, class_1937 world) {
        super(MIEntities.TAVERN_VILLAGER, world);
        this.prev = prev;
    }

    public TavernVillager(class_1646 prevEntity, class_1937 world) {
        super(MIEntities.TAVERN_VILLAGER, world);
        this.prev = prevEntity.method_7231();
    }

    private static final List<class_3545<class_1792, Integer>> ALWAYS_ITEMS = new ArrayList<>(List.of(
            new class_3545<>(MIItems.GREEN_TEA, 8),
            new class_3545<>(MIItems.FRUITY_HIGH_BALL, 8),
            new class_3545<>(MIItems.FRUITY_SOUR, 8),
            new class_3545<>(MIItems.QI, 8)
    ));

    @Override
    public List<class_1914> getVillagerOffers() {
        long seed = this.getVillagerSeed();
        Random random = new Random(seed);

        List<class_1914> offers = new ArrayList<>();

        for (class_3545<class_1792, Integer> pair : ALWAYS_ITEMS) {
            class_1792 item = pair.method_15442();
            int amount = pair.method_15441();

            class_1799 sellItem = new class_1799(item, 6);
            ItemStackWrapper wrapper = ItemStackWrapper.of(sellItem);

            class_9306 first = new class_9306(ModItems.COPPER_COIN, amount);
            class_9306 second = new class_9306(class_1802.field_8469, 1);

            class_1914 offer = new class_1914(
                    first,
                    Optional.of(second),
                    sellItem,
                    Math.max(0, 2 - this.sellInfo.getSellArchive(seed, wrapper)),
                    1,
                    0.05f
            );
            offers.add(offer);
        }

        List<class_1792> allDrinks = new ArrayList<>(MIItems.DRINK_ITEMS);
        for (class_3545<class_1792, Integer> pair : ALWAYS_ITEMS) {
            allDrinks.remove(pair.method_15442());
        }

        Collections.shuffle(allDrinks, random);

        int count = 4 + random.nextInt(5) + this.level;
        List<class_1792> selectedDrinks = allDrinks.subList(0, Math.min(count, allDrinks.size()));

        for (class_1792 item : selectedDrinks) {
            class_1799 sellItem = new class_1799(item, 6);
            ItemStackWrapper wrapper = ItemStackWrapper.of(sellItem);

            int amount = DrinkItem.PRICE_CALCULATION_TABLE.getOrDefault(item,8) + random.nextInt(2);
            class_9306 first = new class_9306(ModItems.COPPER_COIN, amount);
            class_9306 second = new class_9306(class_1802.field_8469, 1);

            class_1914 offer = new class_1914(
                    first,
                    Optional.of(second),
                    sellItem,
                    Math.max(0, 2 - this.sellInfo.getSellArchive(seed, wrapper)),
                    1,
                    0.05f
            );
            offers.add(offer);
        }

        return offers;
    }


    @Override
    public class_3850 getModifyVillagerData(MinecraftServer server) {
        class_5455.class_6890 registryManager = server.method_30611();
        class_2378<class_3854> villagerTypeRegistry = registryManager.method_30530(class_7924.field_41235);
        class_2378<class_3852> villagerProfessionRegistry = registryManager.method_30530(class_7924.field_41234);

        return new class_3850(
                villagerTypeRegistry.method_46747(class_3854.field_17072),
                villagerProfessionRegistry.method_46747(class_3852.field_17054),
                2
        );
    }

    @Override
    public boolean canReset() {
        return true;
    }
}
