package cc.thonly.mystias_izakaya.gui.recipe.block;

import cc.thonly.mystias_izakaya.block.entity.KitchenwareBlockEntity;
import cc.thonly.mystias_izakaya.block.kitchenware.AbstractKitchenwareBlock;
import cc.thonly.mystias_izakaya.component.CraftingConflict;
import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.mystias_izakaya.component.MIDataComponentTypes;
import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.mystias_izakaya.recipe.MiRecipeManager;
import cc.thonly.mystias_izakaya.recipe.entry.KitchenRecipe;
import cc.thonly.mystias_izakaya.recipe.type.KitchenRecipeType;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.gui.GuiCommon;
import cc.thonly.reverie_dreams.interfaces.IGuiElementBuilderAccessor;
import cc.thonly.reverie_dreams.item.ModGuiItems;
import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.util.WeakHashSet;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_10131;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_9334;

public class KitchenBlockGui<R extends BaseRecipe> extends SimpleGui implements GuiCommon {
    public static final String[][] GRID = new String[][]{
            {"X", "Z", "Z", "Z", "Z", "Z", "Z", "Z", "X"},
            {"X", "Z", "Z", "Z", "Z", "Z", "Z", "Z", "X"},
            {"X", "Z", "Z", "Z", "Z", "Z", "Z", "Z", "X"},
            {"X", "P", "X", "X", "X", "X", "X", "N", "X"},
            {"X", "Q", "W", "E", "R", "T", "X", "O", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
    };
    public static final Map<String, Integer> CHAR2INDEX = Map.of(
            "Q", 0,
            "W", 1,
            "E", 2,
            "R", 3,
            "T", 4,
            "O", 5
    );

    private final class_2248 block;
    private final KitchenwareBlockEntity blockEntity;
    private final KitchenRecipeType.KitchenType recipeType;
    private final Map<Integer, GuiElementBuilder> displayed = new HashMap<>();
    private final List<Integer> displayIndexes = new ArrayList<>();
    private int page = 0;
    private int maxPage = 0;

    public KitchenBlockGui(class_2248 block, KitchenwareBlockEntity blockEntity, class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.block = block;
        this.blockEntity = blockEntity;
        this.recipeType = blockEntity.getRecipeType();
        this.init();
    }

    @Override
    public void init() {
        Set<KitchenBlockGui<?>> session = KitchenwareBlockEntity.SESSIONS.computeIfAbsent(this.blockEntity.getUuid(), (map) -> new WeakHashSet<>());
        session.add(this);
        this.setTitle(class_2561.method_43471(this.block.method_63499()));
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                String posChar = GRID[row][col];
                int index = row * 9 + col;

                switch (posChar) {
                    case "X" -> this.setSlot(index, new GuiElementBuilder(ModGuiItems.EMPTY_SLOT));
                    case "N" -> this.setSlot(index, new GuiElementBuilder(ModGuiItems.NEXT).setCallback((i, t, sat) -> {
                        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                        if (this.page < this.maxPage) {
                            this.page++;
                            this.onTick();
                        }
                    }));
                    case "P" -> this.setSlot(index, new GuiElementBuilder(ModGuiItems.PREV).setCallback((i, t, sat) -> {
                        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                        if (this.page > 0) {
                            this.page--;
                            this.onTick();
                        }
                    }));
                    case "Z" -> {
                        GuiElementBuilder guiElementBuilder = new GuiElementBuilder().setItem(class_1802.field_8162);
                        this.displayed.put(index, guiElementBuilder);
                        this.displayIndexes.add(index);
                        this.setSlot(index, guiElementBuilder);
                    }
                    default -> {
                        Integer invIndex = CHAR2INDEX.get(posChar);
                        if (invIndex != null) {
                            this.setSlotRedirect(index, new class_1735(this.blockEntity.getInventory(), invIndex, 0, 0));
                        }
                    }
                }
            }
        }
    }

    private ItemStackWrapper buildFoodTags(KitchenRecipe recipe, ItemStackWrapper output, List<ItemStackWrapper> inputs) {
        class_1799 base = output.getItemStack().copy();
        List<String> baseTags = base.method_58695(MIDataComponentTypes.FOOD_PROPERTIES, new ArrayList<>());

        HashSet<String> propertyIds = new HashSet<>(baseTags);
        List<ItemStackWrapper> ingredients = recipe.getIngredients();
        List<class_1792> ingredientItems = ingredients
                .stream()
                .filter(wrapper -> !wrapper.isEmpty())
                .map(ItemStackWrapper::getItem)
                .toList();
        for (ItemStackWrapper input : inputs) {
            class_1799 itemStack = input.getItemStack();
            class_1792 item = itemStack.method_7909();
            if (ingredientItems.contains(item)) {
                continue;
            }
            List<FoodProperty> ingredientProperties = FoodProperty.getIngredientProperties(item);
            ingredientProperties.forEach(property -> propertyIds.add(property.getId().toString()));
        }
        List<String> tagList = new ArrayList<>(propertyIds);
        base.method_57379(MIDataComponentTypes.FOOD_PROPERTIES, tagList);
        return new ItemStackWrapper(base.method_7972());
    }

    private ItemStackWrapper buildAllFoodTags(ItemStackWrapper output, List<ItemStackWrapper> inputs) {
        class_1799 itemStack = output.getItemStack().copy();
        List<String> outputTags = itemStack.method_58694(MIDataComponentTypes.FOOD_PROPERTIES);
        if (outputTags == null) {
            outputTags = new ArrayList<>();
        }
        HashSet<String> propertyIds = new HashSet<>(outputTags);
        for (ItemStackWrapper wrapper : inputs) {
            class_1799 wrapperItemStack = wrapper.getItemStack();
            if (wrapperItemStack.method_7960()) {
                continue;
            }
            List<FoodProperty> ingredientProperties = FoodProperty.getIngredientProperties(wrapperItemStack.method_7909());
            ingredientProperties.forEach(property -> propertyIds.add(property.getId().toString()));
        }
        List<String> tagList = new ArrayList<>(propertyIds);
        itemStack.method_57379(MIDataComponentTypes.FOOD_PROPERTIES, tagList);
        return new ItemStackWrapper(itemStack.method_7972());
    }

    private void handleCrafting(class_1799 output, List<ItemStackWrapper> inputs, KitchenRecipe recipe) {
        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        class_1277 inventory = this.blockEntity.getInventory();
        for (int i = 0; i < 5; i++) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_7960()) {
                class_10131 useRemainderComponent = stack.method_58694(class_9334.field_53965);
                if (useRemainderComponent != null) {
                    class_1799 itemStack = useRemainderComponent.comp_3093();
                    this.blockEntity.throwItem((class_3218) blockEntity.method_10997(), itemStack);
                }
                stack.method_7934(1);
            }
        }
        this.blockEntity.setOutput(new ItemStackWrapper(output.method_7972()), recipe.getCostTime() * 20.0 + 20 * 0.25 * inputs.size());
        Set<KitchenBlockGui<?>> session = KitchenwareBlockEntity.SESSIONS.computeIfAbsent(this.blockEntity.getUuid(), (map) -> new WeakHashSet<>());
        for (KitchenBlockGui<?> gui : session) {
            if (gui.isOpen()) {
                gui.close();
            }
        }
        session.clear();
        this.close();
    }

    @Override
    public void onTick() {
        super.onTick();

        if (this.blockEntity == null || this.blockEntity.method_10997() == null) {
            this.close();
            return;
        }

        for (Integer index : this.displayIndexes) {
            GuiElementBuilder guiElementBuilder = new GuiElementBuilder().setItem(class_1802.field_8162);
            this.displayed.put(index, guiElementBuilder);
            this.setSlot(index, guiElementBuilder);
        }

        class_2248 block = this.blockEntity.method_10997().method_8320(this.blockEntity.method_11016()).method_26204();
        if (!(block instanceof AbstractKitchenwareBlock)) {
            this.close();
            return;
        }

        KitchenRecipeType kitchenRecipeType = getRecipeTypeInstance();
        class_1277 inventory = this.blockEntity.getInventory();
        List<ItemStackWrapper> inputs = new ArrayList<>();
        for (int i = 0; i < 5; i++) {
            inputs.add(new ItemStackWrapper(inventory.method_5438(i).method_7972()));
        }

        List<KitchenRecipe> matches = kitchenRecipeType.getMatches(this.recipeType, inputs);
        int recipesPerPage = this.displayed.size();
        this.maxPage = (matches.size() - 1) / recipesPerPage;
        List<KitchenRecipe> pageRecipes = getRecipesForCurrentPage(matches, recipesPerPage);

        // 清空旧显示
        for (GuiElementBuilder builder : this.displayed.values()) {
            IGuiElementBuilderAccessor accessor = (IGuiElementBuilderAccessor) builder;
            accessor.setItemStack(ModGuiItems.EMPTY_SLOT.method_7854());
        }

        int i = 0;
        for (Map.Entry<Integer, GuiElementBuilder> entry : this.displayed.entrySet()) {
            if (i >= pageRecipes.size()) break;

            KitchenRecipe recipe = pageRecipes.get(i);
            class_1799 outputShow = this.buildFoodTags(recipe, new ItemStackWrapper(recipe.getOutput().getItemStack().copy()), inputs).getItemStack();
            AtomicReference<class_1799> output = new AtomicReference<>(outputShow);

            GuiElementBuilder builder = entry.getValue();
            IGuiElementBuilderAccessor accessor = (IGuiElementBuilderAccessor) builder;
            accessor.setItemStack(outputShow);

            builder.setCallback((slotIndex, clickType, actionType) -> {
                class_1799 itemStack = output.get();
                for (CraftingConflict conflict : MIRegistryManager.CRAFTING_CONFLICT.values()) {
                    if (conflict.test(itemStack)) {
                        output.set(MIItems.DARK_CUISINE.method_7854());
                    }
                }
                handleCrafting(output.get(), inputs, recipe);
            });

            this.setSlot(entry.getKey(), builder);
            i++;
        }
    }

    private List<KitchenRecipe> getRecipesForCurrentPage(List<KitchenRecipe> all, int pageSize) {
        int start = this.page * pageSize;
        return all.stream().skip(start).limit(pageSize).toList();
    }

    public KitchenRecipeType getRecipeTypeInstance() {
        BaseRecipeType<KitchenRecipe> recipeType = MiRecipeManager.KITCHEN_RECIPE;
        return (KitchenRecipeType) recipeType;
    }

    @Override
    public void onClose() {
        this.blockEntity.method_5431();
        super.onClose();
    }
}
