package cc.thonly.mystias_izakaya.registry;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.component.DrinkProperty;
import cc.thonly.mystias_izakaya.item.base.DrinkItem;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@SuppressWarnings("Convert2MethodRef")
@Slf4j
public class DrinkProperties {
    public static final DrinkProperty UNDEFINED = register("undefined", () -> new DrinkProperty());
    public static final DrinkProperty ALCOHOL_FREE = register("alcohol-free", () -> new DrinkProperty());
    public static final DrinkProperty LOW_ALCOHOL = register("low_alcohol", () -> new DrinkProperty());
    public static final DrinkProperty MID_ALCOHOL = register("mid_alcohol", () -> new DrinkProperty());
    public static final DrinkProperty HIGH_ALCOHOL = register("high_alcohol", () -> new DrinkProperty());
    public static final DrinkProperty CAN_ADD_ICE = register("can_add_ice", () -> new DrinkProperty());
    public static final DrinkProperty CAN_HEATED = register("can_heated", () -> new DrinkProperty());
    public static final DrinkProperty COCKTAIL = register("cocktail", () -> new DrinkProperty());
    public static final DrinkProperty WESTERN_WINE = register("western_wine", () -> new DrinkProperty());
    public static final DrinkProperty FRUIT = register("fruit", () -> new DrinkProperty());
    public static final DrinkProperty SWEET = register("sweet", () -> new DrinkProperty());
    public static final DrinkProperty BITTER = register("bitter", () -> new DrinkProperty());
    public static final DrinkProperty SOJU = register("soju", () -> new DrinkProperty());
    public static final DrinkProperty SAKE = register("sake", () -> new DrinkProperty());
    public static final DrinkProperty PUNGENT = register("pungent", () -> new DrinkProperty());
    public static final DrinkProperty BUBBLE = register("bubble", () -> new DrinkProperty());
    public static final DrinkProperty BEER = register("beer", () -> new DrinkProperty());
    public static final DrinkProperty DIRECT_DRINKING = register("direct_drinking", () -> new DrinkProperty());
    public static final DrinkProperty LIQUEUR = register("liqueur", () -> new DrinkProperty());
    public static final DrinkProperty REFRESHING = register("refreshing", () -> new DrinkProperty());
    public static final DrinkProperty CLASSICAL = register("classical", () -> new DrinkProperty());
    public static final DrinkProperty MODERN = register("modern", () -> new DrinkProperty());

    @SuppressWarnings("unchecked")
    private static <T extends DrinkProperty> T register(String name, Supplier<T> factory) {
        T property = factory.get();
        property.setId(MystiasIzakaya.id(name));
        return (T) RegistryManager.registerForBuiltin(MIRegistryManager.DRINK_PROPERTY, MystiasIzakaya.id(name), property);
    }

    public static void reload(class_3300 manager) {
        Map<class_2960, DrinkProperty> map = MIRegistryManager.DRINK_PROPERTY.method_29722().stream()
                .collect(Collectors.toMap(
                        entry -> entry.getKey().method_29177(),
                        Map.Entry::getValue
                ));
        Set<Map.Entry<class_2960, DrinkProperty>> entries = map.entrySet();
        entries.forEach((es) -> es.getValue().getItems().clear());

        Map<class_2960, class_3298> resources = manager.method_14488("drink_property", id ->
                id.method_12836().equals(MystiasIzakaya.MOD_ID) && id.method_12832().endsWith(".json")
        );

        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 resourceId = entry.getKey();
            class_2960 key = class_2960.method_60655(resourceId.method_12836(), resourceId.method_12832().replace("drink_property/", "").replace(".json", ""));
            class_3298 resource = entry.getValue();
            DrinkProperty property = MIRegistryManager.DRINK_PROPERTY.method_63535(key);

            if (property == null) {
                MystiasIzakaya.LOGGER.warn("Unknown DrinkProperty id: {}", resourceId);
                continue;
            }

            try (InputStream stream = resource.method_14482()) {
                JsonElement json = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, json);

                DataResult<DrinkProperty> result = DrinkProperty.CODEC.parse(input);

                result.resultOrPartial(error -> MystiasIzakaya.LOGGER.warn("Failed to parse tags for {}: {}", resourceId, error))
                        .ifPresent(data -> {
                            property.getItems().addAll(data.getItems());
                        });

            } catch (IOException e) {
                MystiasIzakaya.LOGGER.error("Failed to load drink_property {}: {}", resourceId, e.getMessage(), e);
            }
        }

        Map<class_1792, Set<DrinkProperty>> itemDrinkPropertyCached = DrinkItem.ITEM_DRINK_CACHED;
        itemDrinkPropertyCached.clear();
        for (Map.Entry<class_2960, DrinkProperty> entry : entries) {
            DrinkProperty property = entry.getValue();
            Set<class_1792> tags = property.getItems();
            for (class_1792 item : tags) {
                itemDrinkPropertyCached.computeIfAbsent(item, k -> new HashSet<>())
                        .add(property);
            }
        }
        log.info("Ingredients TAG loading completed");

        Map<class_1792, Integer> priceCalculationTable = DrinkItem.PRICE_CALCULATION_TABLE;
        priceCalculationTable.clear();
        for (Map.Entry<class_1792, Set<DrinkProperty>> entry : itemDrinkPropertyCached.entrySet()) {
            int cost = 8;
            class_1792 item = entry.getKey();
            Set<DrinkProperty> drinkProperties = entry.getValue();
            cost += drinkProperties.size() * 2;
            priceCalculationTable.put(item, cost);
        }
    }

    public static void bootstrap(IntrinsicalRegister<DrinkProperty> registry) {

    }
}
