package cc.thonly.mystias_izakaya.registry;

import cc.thonly.mystias_izakaya.MystiasIzakaya;
import cc.thonly.mystias_izakaya.api.DrinkPropertyLoaderCallback;
import cc.thonly.mystias_izakaya.api.FoodPropertyLoaderCallback;
import cc.thonly.mystias_izakaya.component.CraftingConflict;
import cc.thonly.mystias_izakaya.component.DrinkProperty;
import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_1293;
import net.minecraft.class_1294;

@Slf4j
@SuppressWarnings("unchecked")
public class MIRegistryManager extends RegistryManager {
    public static final IntrinsicalRegister<FoodProperty> FOOD_PROPERTY = MIRegistryManager.<FoodProperty>ofEntry(MystiasIzakaya.id("food_property"))
            .codec(FoodProperty.CODEC)
            .reloadBuilder(FoodProperties::reload)
            .builder(FoodProperties::bootstrap);
    public static final IntrinsicalRegister<DrinkProperty> DRINK_PROPERTY = MIRegistryManager.<DrinkProperty>ofEntry(MystiasIzakaya.id("drink_property"))
            .codec(DrinkProperty.CODEC)
            .reloadBuilder(DrinkProperties::reload)
            .builder(DrinkProperties::bootstrap);
    public static final IntrinsicalRegister<CraftingConflict> CRAFTING_CONFLICT = MIRegistryManager.<CraftingConflict>ofEntry(MystiasIzakaya.id("crafting_conflict"))
            .codec(CraftingConflict.CODEC)
            .reloadBuilder(CraftingConflict::reload)
            .builder(CraftingConflict::bootstrap);

    public static void bootstrap() {
        for (var entry : ROOT.entrySet()) {
            IntrinsicalRegister<?> registry = entry.getValue();
            registry.build();
        }

        FoodPropertyLoaderCallback.EVENT.register((world, user, property) -> {
            if (world.field_9236) {
                return;
            }
            if (property.is(FoodProperties.COOL)) {
                user.method_33572(false);
                user.method_20803(0);
            }
            if (property.is(FoodProperties.SPICY)) {
                user.method_33572(true);
                user.method_20803(2 * 20);
            }
            if (property.is(FoodProperties.BIZARRE)) {
                user.method_6092(new class_1293(class_1294.field_5916, 2 * 20, 1));
            }
            if (property.is(FoodProperties.GOURMET)) {
                user.method_6092(new class_1293(class_1294.field_5917, 25 * 20, 1));
            }
            if (property.is(FoodProperties.MOUNTAIN_DELICACY)) {
                user.method_6092(new class_1293(class_1294.field_5926, 90 * 20, 1));
            }
            if (property.is(FoodProperties.PHOTOGENIC)) {
                user.method_6092(new class_1293(class_1294.field_5925, 60 * 20, 1));
            }
            if (property.is(FoodProperties.CURSE)) {
                user.method_6092(new class_1293(class_1294.field_16595, 120 * 20, 1));
            }
            if (property.is(FoodProperties.TOXIC)) {
                user.method_6092(new class_1293(class_1294.field_5898, 60 * 20, 1));
            }
            if (property.is(FoodProperties.LARGE_PARTITION)) {
                user.method_6092(new class_1293(class_1294.field_5922, 1, 1));
            }
            if (property.is(FoodProperties.SWEET)) {
                user.method_6092(new class_1293(class_1294.field_5904, 35 * 20));
            }
            if (property.is(FoodProperties.UNBELIEVABLE)) {
                user.method_6092(new class_1293(class_1294.field_5924, 35 * 20));
            }
            if (property.is(FoodProperties.LEGENDARY)) {
                user.method_6092(new class_1293(class_1294.field_5898, 35 * 20));
            }
            if (property.is(FoodProperties.FILLING)) {
                user.method_6092(new class_1293(class_1294.field_5922, 1, 1));
            }
            if (property.is(FoodProperties.POWER_SURGE)) {
                user.method_6092(new class_1293(class_1294.field_5910, 45 * 20));
            }
            if (property.is(FoodProperties.OCEAN_FLAVOR)) {
                user.method_6092(new class_1293(class_1294.field_5923, 30 * 20));
            }
            if (property.is(FoodProperties.DARK_CUISINE)) {
                user.method_6092(new class_1293(class_1294.field_5916, 15 * 20));
                user.method_6092(new class_1293(class_1294.field_5899, 10 * 20));
            }
        });
        DrinkPropertyLoaderCallback.EVENT.register((world, user, property) -> {
            if (world.field_9236) {
                return;
            }
            if (property.is(DrinkProperties.LOW_ALCOHOL)) {
                user.method_6092(new class_1293(class_1294.field_5916, 3 * 20));
            }
            if (property.is(DrinkProperties.MID_ALCOHOL)) {
                user.method_6092(new class_1293(class_1294.field_5916, 9 * 20));
            }
            if (property.is(DrinkProperties.HIGH_ALCOHOL)) {
                user.method_6092(new class_1293(class_1294.field_5916, 27 * 20));
            }
            if (property.is(DrinkProperties.CAN_ADD_ICE)) {
                user.method_33572(false);
                user.method_32317(20);
            }
            if (property.is(DrinkProperties.SWEET)) {
                user.method_6092(new class_1293(class_1294.field_5904, 10 * 20));
            }
            if (property.is(DrinkProperties.REFRESHING)) {
                user.method_6092(new class_1293(class_1294.field_5917, 20 * 20));
                user.method_6092(new class_1293(class_1294.field_5904, 20 * 20));
            }
            if (property.is(DrinkProperties.BITTER)) {
                user.method_6092(new class_1293(class_1294.field_5901, 20));
            }
        });
    }
}
