package cc.thonly.polymer;

import cc.thonly.mystias_izakaya.block.ItemStackDisplay;
import cc.thonly.mystias_izakaya.block.kitchenware.AbstractKitchenwareBlock;
import cc.thonly.polymer.block.*;
import cc.thonly.reverie_dreams.LateLoaderInit;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.block.BaseFumoBlock;
import cc.thonly.reverie_dreams.block.CashBoxBlock;
import cc.thonly.reverie_dreams.block.GensokyoAltarBlock;
import cc.thonly.reverie_dreams.block.ModelBlock;
import cc.thonly.reverie_dreams.block.base.AbstractCropBlock;
import cc.thonly.reverie_dreams.block.base.FruitLeavesBlock;
import cc.thonly.reverie_dreams.config.ReverieDreamsConfiguration;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import eu.pb4.factorytools.api.block.model.SignModel;
import eu.pb4.factorytools.api.block.model.generic.BlockStateModelManager;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.virtualentity.api.BlockWithElementHolder;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.block.*;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
@Slf4j
public class PolymerBlockHelper {
    public static void registerOverlay(class_2248 block) {
        if (ConstantInfo.IS_DATAGEN) {
            return;
        }
        class_2960 id = class_7923.field_41175.method_10221(block);
        PolymerBlock polymerBlock = requestBlockOverlay(block);
        PolymerBlock.registerOverlay(block, polymerBlock);
        if (polymerBlock instanceof BlockWithElementHolder blockWithElementHolder) {
            BlockWithElementHolder.registerOverlay(block, blockWithElementHolder);
        }

        if (block instanceof class_2478) {
            LateLoaderInit.LATE_INIT.add(() -> SignModel.setModel(block, Touhou.id("block_sign/" + id.method_12832())));
        }
    }

    public static PolymerBlock requestBlockOverlay(class_2248 block) {
        Identifier id = Registries.BLOCK.getId(block);
        BlockState defaultState = block.getDefaultState();

        LateLoaderInit.LATE_INIT.add(() -> {
            try {
                BlockStateModelManager.addBlock(id, block);
            } catch (Exception err) {
                log.error("Can't add block state model {}", id, err);
            }
        });

        return switch (block) {
            case ItemStackDisplay ignored -> new ItemStackDisplayImpl();
            case AbstractCropBlock ignored -> new CropBlockImpl(ignored);
            case FruitLeavesBlock ignored -> new FruitLeavesImpl(ignored);
            case ModelBlock ignored -> new ModelFactoryImpl(ignored);
            case BaseFumoBlock ignored -> new FumoImpl(ignored);
            case GensokyoAltarBlock ignored -> new GensokyoAltarImpl();
            case CashBoxBlock ignored -> new HorizontalFacingImpl(ignored);
            case AbstractKitchenwareBlock ignored -> new AbstractKitchenwareImpl(ignored);
            case RedstoneLampBlock ignored -> StatePolymerBlock.of(block, BlockModelType.FULL_BLOCK);
            case StairsBlock ignored -> StateCopyFactoryBlock.STAIR;
            case SlabBlock ignored -> SlabFactoryBlock.INSTANCE;
            case FenceGateBlock ignored -> StateCopyFactoryBlock.FENCE_GATE;
            case FenceBlock ignored -> StateCopyFactoryBlock.FENCE;
            case WallBlock ignored -> StateCopyFactoryBlock.WALL;
            case LeavesBlock ignored -> RealSingleStatePolymerBlock.of(block, BlockModelType.TRANSPARENT_BLOCK);
            case SignBlock ignored -> StateCopyFactoryBlock.SIGN;
            case WallSignBlock ignored -> StateCopyFactoryBlock.WALL_SIGN;
            case HangingSignBlock ignored -> StateCopyFactoryBlock.HANGING_SIGN;
            case WallHangingSignBlock ignored -> StateCopyFactoryBlock.HANGING_WALL_SIGN;
            case DoorBlock ignored -> DoorPolymerBlock.INSTANCE;
            case TrapdoorBlock ignored -> TrapdoorPolymerBlock.INSTANCE;
            case ButtonBlock ignored -> StateCopyFactoryBlock.BUTTON;
            case PressurePlateBlock ignored -> StateCopyFactoryBlock.PRESSURE_PLATE;
            case PlantBlock ignored -> BaseFactoryBlock.SAPLING;
            case FlowerPotBlock ignored -> new PottedPlantPolymerBlock(id);
            case PaneBlock ignored -> StateCopyFactoryBlock.PANE;
            case LanternBlock ignored -> StateCopyFactoryBlock.LANTERN;
            case HorizontalFacingBlock ignored -> BaseFactoryBlock.BARRIER;
            case CarpetBlock ignored -> StateCopyFactoryBlock.CARPET;
            case ChainBlock ignored -> StateCopyFactoryBlock.CHAIN;
            case PillarBlock ignored -> BaseFactoryBlock.BARRIER;
            case GrateBlock ignored -> BaseFactoryBlock.BARRIER;
            default -> {
                if (defaultState.isFullCube(PolymerCommonUtils.getFakeWorld(), BlockPos.ORIGIN)) {
                    yield StatePolymerBlock.of(block, BlockModelType.FULL_BLOCK);
                } else {
                    yield BaseFactoryBlock.BARRIER;
                }
            }
        };
    }
}
