package cc.thonly.polymer.block;

import cc.thonly.reverie_dreams.util.ConstantInfo;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.resourcepack.extras.api.format.blockstate.BlockStateAsset;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import xyz.nucleoid.packettweaker.PacketContext;

import java.nio.file.Files;
import java.util.Set;

public record RealSingleStatePolymerBlock(class_2680 state) implements PolymerTexturedBlock {

    public static RealSingleStatePolymerBlock of(class_2248 block, BlockModelType type) {
        if (ConstantInfo.IS_DATAGEN) {
            return new RealSingleStatePolymerBlock(block.method_9564());
        }

        try {
            BlockStateAsset decoded;
            var id = class_7923.field_41175.method_10221(block);

            var path = FabricLoader.getInstance().getModContainer("reverie_dreams").get()
                    .findPath("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json").get();

            decoded = BlockStateAsset.CODEC.decode(JsonOps.INSTANCE, JsonParser.parseString(Files.readString(path))).getOrThrow().getFirst();
            var set = Set.copyOf(decoded.variants().get().values());

            var model = set.size() == 1 ? set.iterator().next() : decoded.variants().orElseThrow().get("");

            return new RealSingleStatePolymerBlock(PolymerBlockResourceUtils.requestBlock(
                    type,
                    model.stream().map(x -> new PolymerBlockModel(x.model(), x.x(), x.y(), x.uvlock(), x.weigth())).toArray(PolymerBlockModel[]::new)));
        } catch (Throwable e) {
            return null;
        }
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 blockState, PacketContext packetContext) {
        return state;
    }

    @Override
    public boolean isIgnoringBlockInteractionPlaySoundExceptedEntity(class_2680 state, class_3222 player, class_1268 hand, class_1799 stack, class_3218 world, class_3965 blockHitResult) {
        return true;
    }
}