package cc.thonly.polymer.entity;

import cc.thonly.reverie_dreams.entity.misc.BaguaFurnaceEntity;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.ModItems;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.List;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5629;
import net.minecraft.class_811;

public record BaguaFurnaceImpl(BaguaFurnaceEntity baguaFurnaceEntity) implements PolymerEntity {
    public BaguaFurnaceImpl {

    }

    public void setTileProjectileData(List<class_2945.class_7834<?>> data, boolean initial) {
        if (initial && !this.baguaFurnaceEntity.method_37908().field_9236) {
            var sendBase = true;
            for (int i = 0; i < data.size(); i++) {
                var roll = data.get(i);
                if (roll.comp_1115() == DanmakuEntity.ROLL.comp_2327() && roll.comp_1116() == DanmakuEntity.ROLL.comp_2328()) {
                    float base = (float) roll.comp_1117();
                    Quaternionf from = new Quaternionf().rotateY(class_3532.field_29845).rotateZ(base);
                    Quaternionf to = new Quaternionf().rotateY(class_3532.field_29845).rotateZ(base + (float) (2 * Math.PI));
                    data.set(i, class_2945.class_7834.method_46360(DisplayTrackedData.LEFT_ROTATION, from));
                    data.add(class_2945.class_7834.method_46360(DisplayTrackedData.RIGHT_ROTATION, to));
                    data.add(class_2945.class_7834.method_46360(DisplayTrackedData.INTERPOLATION_DURATION, 20));
                    sendBase = false;
                    break;
                }

            }

            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.TELEPORTATION_DURATION, 3));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.INTERPOLATION_DURATION, 0));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.SCALE, new Vector3f(2f)));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.TRANSLATION, new Vector3f(0, -0.1f, 0)));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.INTERPOLATION_DURATION, 2));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.TELEPORTATION_DURATION, 4));
            if (sendBase) {
                data.add(class_2945.class_7834.method_46360(DisplayTrackedData.LEFT_ROTATION, new Quaternionf().rotateX(class_3532.field_29845)));
            }

            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.Item.ITEM, ModItems.BAGUA_FURNACE.method_7854()));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.Item.ITEM_DISPLAY, class_811.field_4318.method_48961()));
        }
    }

    @Override
    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        PolymerEntity.super.modifyRawTrackedData(data, player, initial);
        setTileProjectileData(data, initial);
    }

    @Override
    public void onEntityTrackerTick(Set<class_5629> listeners) {
        PolymerEntity.super.onEntityTrackerTick(listeners);
    }

    @Override
    public class_1299<?> getPolymerEntityType(PacketContext packetContext) {
        return class_1299.field_42456;
    }
}
