package cc.thonly.polymer.entity;

import cc.thonly.polymer.PolymerEntityHelper;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.entity.ModEntityHolders;
import cc.thonly.reverie_dreams.entity.holder.MagicBroomHolder;
import cc.thonly.reverie_dreams.entity.holder.WheelChairHolder;
import cc.thonly.reverie_dreams.entity.misc.WheelchairEntity;
import cc.thonly.reverie_dreams.item.ModItems;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_811;

public record WheelChairImpl(WheelchairEntity wheelchairEntity) implements PolymerEntity, PolymerHolderEntity {
    public static final WeakHashMap<class_1297, ItemDisplayElement> ELEMENTS = new WeakHashMap<>();

    public WheelChairImpl {
        PolymerEntityHelper.NEXT.add(this);
    }

    @Override
    public void onCreated() {
        this.wheelchairEntity.method_5875(true);
        var x = new ItemDisplayElement();
        var holder = new WheelChairHolder(this.wheelchairEntity);
        var stack = new class_1799(ModBlocks.WHEEL_CHAIR);
        x.setItem(stack);
        x.setItemDisplayContext(class_811.field_4316);
        x.setInvisible(true);
        x.setTeleportDuration(3);
        holder.setElement(x);
        holder.addElement(x);
        EntityAttachment.ofTicking(holder, this.wheelchairEntity);
        VirtualEntityUtils.addVirtualPassenger(this.wheelchairEntity, x.getEntityId());
        ELEMENTS.put(this.wheelchairEntity, x);
    }

    @Override
    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_6093;
    }

    public void onTrackingStopped(class_3222 player) {
        ItemDisplayElement element = ELEMENTS.get(this.wheelchairEntity);
        if (element != null) {
            ElementHolder holder = element.getHolder();
            if (holder != null) {
                holder.destroy();
            }
        }
        ELEMENTS.remove(this.wheelchairEntity);
    }
}
