package cc.thonly.reverie_dreams;

import cc.thonly.mystias_izakaya.block.MIBlocks;
import cc.thonly.reverie_dreams.block.BlockTypeGroup;
import cc.thonly.reverie_dreams.block.CropBlockCreator;
import cc.thonly.reverie_dreams.block.ModBlocks;
import com.mojang.serialization.Codec;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.minecraft.class_11515;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public class TouhouClient implements ClientModInitializer {
    public static final Codec<TouhouClient> CODEC = Codec.unit(TouhouClient::new);
    public static final String MOD_ID = Touhou.MOD_ID;
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    public static final List<class_2248> SERVER_SIDE_BLOCKS = List.of(class_2246.field_10179, class_2246.field_10589);

    @Override
    public void onInitializeClient() {
        BlockTypeGroup.LEAVES.stream().forEach(this::registerBlockCutout);
        BlockTypeGroup.SAPLING.stream().forEach(this::registerBlockCutout);
        BlockTypeGroup.KITCHENWARE.stream().forEach(this::registerBlockCutout);
        BlockTypeGroup.PLANT.stream().forEach(this::registerBlockCutout);
        registerBlockCutout(ModBlocks.MARISA_HAT_BLOCK);
        registerBlockCutout(ModBlocks.CASH_BOX_BLOCK);
        for (Map.Entry<class_2960, CropBlockCreator.Instance> view : CropBlockCreator.getViews()) {
            this.registerBlockCutout(view.getValue().getCropBlock());
        }
        registerBlockCutout(MIBlocks.ITEM_DISPLAY);
        registerBlockCutout(MIBlocks.GENSOKYO_ALTAR);
    }

    public void registerBlockCutout(class_2248 block) {
        BlockRenderLayerMap.putBlock(block, class_11515.field_60925);
    }

    public static class_2960 id(String id) {
        return class_2960.method_60655(MOD_ID, id);
    }

}