package cc.thonly.reverie_dreams.block;

import cc.thonly.reverie_dreams.block.entity.CustomChestBlockEntity;
import cc.thonly.reverie_dreams.gui.CustomChestBlockGui;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.item.weapon.HakureiCane;
import cc.thonly.reverie_dreams.item.weapon.WindBlessingCane;
import cc.thonly.reverie_dreams.server.player.FaithComponent;
import cc.thonly.reverie_dreams.server.player.PlayerComponent;
import cc.thonly.reverie_dreams.server.player.PlayerDataComponentManager;
import cc.thonly.reverie_dreams.util.PredicateSlot;
import com.mojang.serialization.MapCodec;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class CashBoxBlock extends class_2383 implements class_2343 {
    public static final MapCodec<CashBoxBlock> CODEC = method_54094(CashBoxBlock::new);

    public CashBoxBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(field_11177, class_2350.field_11043));
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(field_11177);
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && world instanceof class_3218 serverWorld) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof CustomChestBlockEntity customChestBlockEntity) {
                class_1277 inventory = customChestBlockEntity.getInventory();
                for (int i = 0; i < inventory.method_5439(); i++) {
                    class_1799 stack = inventory.method_5438(i);
                    if (stack.method_7960()) {
                        continue;
                    }
                    class_1542 itemEntity = new class_1542(serverWorld, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
                    serverWorld.method_8649(itemEntity);
                }
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236 && player instanceof class_3222 serverPlayer) {
            if (!(world.method_8321(pos) instanceof CustomChestBlockEntity chestBlockEntity)) {
                return class_1269.field_5814;
            }
            PlayerDataComponentManager playerDataComponentManager = PlayerDataComponentManager.getInstance();
            class_1799 itemStack = player.method_5998(class_1268.field_5808);
            int cal = calValue(itemStack);
            if (cal > 0) {
                PlayerComponent<FaithComponent> faithComponents = playerDataComponentManager.getOrCreatePlayerComponent(serverPlayer, FaithComponent.class);
                FaithComponent faithComponent = faithComponents.get();
                long timeOfDay = world.method_8532();
                long dayCount = timeOfDay / 24000;
                long dateOfLastPrayer = faithComponent.getDateOfLastPrayer();
                if (dayCount != dateOfLastPrayer) {
                    int base = faithComponent.getFaithValue() + cal;
                    int val = (int) (base + 7 * 1.5f * world.field_9229.method_43058());
                    if (base > FaithComponent.MAX_VALUE) {
                        faithComponent.setFaithValue(FaithComponent.MAX_VALUE);
                        player.method_17356(class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
                        player.method_7353(class_2561.method_43469("item.action.click.cashbox.fails.full", FaithComponent.MAX_VALUE), true);
                        return class_1269.field_52422;
                    }
                    faithComponent.setFaithValue(val);
                    faithComponent.setDateOfLastPrayer(dayCount);
                    itemStack.method_57008(world.field_9229.method_39332(1, 3), player);
                    player.method_17356(class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
                    player.method_7353(class_2561.method_43469("item.action.click.cashbox.success", val), true);
                    return class_1269.field_52422;
                }
                player.method_7353(class_2561.method_43471("item.action.click.cashbox.fails.used"), true);
                return class_1269.field_52422;
            } else {
                SimpleGui chestGui = new CustomChestBlockGui(this, chestBlockEntity, serverPlayer, (inventory, index, x, y) -> new PredicateSlot(inventory, index, x, y, (stack) -> CustomChestBlockGui.COIN_ITEMS.contains(stack.method_7909())));
                chestGui.open();
                return class_1269.field_52422;
            }
        }
        return class_1269.field_5812;
    }

    protected static int calValue(class_1799 itemStack) {
        int cal = 0;
        if (itemStack.method_7909() == ModItems.COPPER_COIN) {
            cal += 1;
        }
        if (itemStack.method_7909() == ModItems.SILVER_COIN) {
            cal += 3;
        }
        if (itemStack.method_7909() == ModItems.GOLD_COIN) {
            cal += 8;
        }
        return cal;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(field_11177, ctx.method_8042());
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CustomChestBlockEntity(pos, state);
    }
}
