package cc.thonly.reverie_dreams.block;

import cc.thonly.mystias_izakaya.block.MIBlocks;
import cc.thonly.reverie_dreams.block.base.AbstractCropBlock;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.util.block.CropAgeModelProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.minecraft.class_141;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_212;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Accessors(chain = true)
@Setter
@Getter
public final class CropBlockCreator {
    private static final Map<class_2960, CropBlockCreator.Instance> INSTANCES = new Object2ObjectOpenHashMap<>();
    private final class_2960 identifier;
    private Integer maxAge;
    private float seedCompostingLevel = 0.3f;
    private float cropCompostingLevel = 0.6f;
    private class_1792 gain;
    private CropAgeModelProvider provider;
    private BasicBlockFactory factory;
    private boolean inWater;
    private boolean selfSeed = false;
    private ModelType modelType = ModelType.CROSS;
    @Setter(value = AccessLevel.PRIVATE)
    private CropBlockCreator.Instance instance;

    private CropBlockCreator(class_2960 identifier) {
        this.identifier = identifier;
    }

    public static CropBlockCreator createCreator(class_2960 identifier) {
        return new CropBlockCreator(identifier);
    }

    /**
     * 设置此作物的掉落物既是种子。
     */
    public CropBlockCreator self() {
        this.selfSeed = true;
        return this;
    }

    /**
     * 构建并注册作物 block 与 item
     */
    public CropBlockCreator.Instance build() {
        AbstractCropBlock basicCropBlock = this.factory.newInstance(class_4970.class_2251.method_9637().method_63500(ModBlocks.keyOf(this.identifier)));
        MIBlocks.registerSimpleBlock(basicCropBlock);
        class_2378.method_10230(class_7923.field_41175, this.identifier, basicCropBlock);

        class_1792 seedItem;
        class_2960 seedId = class_2960.method_60655(this.identifier.method_12836(), this.identifier.method_12832() + "_seeds");
        seedItem = ModItems.registerSimpleItem(
                seedId,
                (settings) -> new class_1747(
                        basicCropBlock,
                        settings
                                .method_63686(class_5321.method_29179(class_7924.field_41197, seedId))
                                .method_63687()
                ),
                new class_1792.class_1793()
        );

        CompostingChanceRegistry.INSTANCE.add(seedItem, getSeedCompostingLevel());

        if (this.selfSeed) {
            this.gain = seedItem;
        } else {
            CompostingChanceRegistry.INSTANCE.add(gain, getCropCompostingLevel());
        }

        basicCropBlock.setSeed(seedItem);
        basicCropBlock.setModelProvider(this.provider);

        Instance instance = Instance.createInstance(this.identifier)
                .setCropBlock(basicCropBlock)
                .setSeed(seedItem)
                .setProduct(this.gain)
                .setProvider(this.provider)
                .setModelType(this.modelType)
                .setInWater(this.inWater)
                .setSelfSeed(this.selfSeed);

        instance.getItems().add(seedItem);
        if (this.gain != null) {
            instance.getItems().add(this.gain);
        }

        this.instance = instance;
        INSTANCES.put(this.identifier, instance);
        return instance;
    }

    public static Optional<Instance> getInstance(class_2960 identifier) {
        return Optional.ofNullable(INSTANCES.get(identifier));
    }

    public static Optional<Instance> getInstance(class_2248 block) {
        return Optional.ofNullable(INSTANCES.get(class_7923.field_41175.method_10221(block)));
    }

    public static Set<Map.Entry<class_2960, Instance>> getViews() {
        return INSTANCES.entrySet();
    }

    public interface BasicBlockFactory {
        AbstractCropBlock newInstance(class_4970.class_2251 settings);
    }

    @Accessors(chain = true)
    @Setter
    @Getter
    @ToString
    public static class Instance {
        private final class_2960 identifier;
        private final Set<class_1792> items = new HashSet<>();
        private class_1792 seed;
        private class_1792 product;
        private AbstractCropBlock cropBlock;
        private CropAgeModelProvider provider;
        private ModelType modelType;
        private boolean inWater = false;
        private boolean selfSeed = false;

        private Instance(class_2960 identifier) {
            this.identifier = identifier;
        }

        public static Instance createInstance(class_2960 identifier) {
            return new Instance(identifier);
        }

        public void generateTranslation(FabricLanguageProvider.TranslationBuilder builder, String seed) {
            builder.add(this.cropBlock, seed);
            builder.add(this.seed, seed);
        }

        public void generateLoot(FabricBlockLootTableProvider provider) {
            if (this.cropBlock != null && this.product != null) {
                class_212.class_213 condition = class_212
                        .method_900(this.cropBlock)
                        .method_22584(
                                class_4559.class_4560
                                        .method_22523()
                                        .method_22524(this.cropBlock.getAgeProperty(), this.cropBlock.getMaxAge())
                        );
//                LootTable.Builder lootTableBuilder = provider.cropDrops(this.cropBlock, this.product, this.seed, condition);
                class_52.class_53 lootTableBuilder = class_52.method_324();
                class_85.class_86<?> productEntry = class_77.method_411(this.product)
                        .method_438(class_141.method_621(
                                class_5662.method_32462(1.0f, 3.0f)
                        ));
                class_85.class_86<?> seedEntry = class_77.method_411(this.seed)
                        .method_438(class_141.method_621(
                                class_5662.method_32462(1.0f, 2.0f)
                        ));
                class_85.class_86<?> baseSeedEntry = class_77.method_411(this.seed)
                        .method_438(class_141.method_621(
                                class_44.method_32448(1)
                        ));
                lootTableBuilder.method_336(
                        class_55.method_347()
                                .conditionally(condition.build())
                                .method_352(class_44.method_32448(1))
                                .method_351(baseSeedEntry)
                );
                lootTableBuilder.method_336(
                        class_55.method_347()
                                .conditionally(condition.build())
                                .method_352(class_44.method_32448(1))
                                .method_351(productEntry)
                );
                lootTableBuilder.method_336(
                        class_55.method_347()
                                .conditionally(condition.build())
                                .method_352(class_44.method_32448(1))
                                .method_351(seedEntry)
                );
                provider.method_45988(this.cropBlock, lootTableBuilder);
            }
        }
    }

    public enum ModelType {
        CROSS(),
        CROP(),
        ;
    }
}
