package cc.thonly.reverie_dreams.block;

import cc.thonly.polymer.PolymerBlockHelper;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.world.SaplingGeneratorInit;
import lombok.Getter;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

@Getter
public class ModBlocks {
    public static final Set<class_2248> BLOCKS = new LinkedHashSet<>();
    public static final class_2248 DANMAKU_CRAFTING_TABLE = registerBlock("danmaku_crafting_table", DanmakuCraftingTableBlock::new, class_4970.class_2251.method_9630(class_2246.field_9980));
    public static final class_2248 STRENGTH_TABLE = registerBlock("strength_table", StrengthenTableBlock::new, class_4970.class_2251.method_9630(class_2246.field_16329));
    public static final class_2248 GENSOKYO_ALTAR = registerBlock("gensokyo_altar", GensokyoAltarBlock::new, class_4970.class_2251.method_9630(class_2246.field_10485).method_9631((state) -> 7));
    public static final class_2248 MUSIC_BLOCK = registerBlock("music_block", MusicBlock::new, class_4970.class_2251.method_9630(class_2246.field_10179));

    public static final WoodCreator SPIRITUAL = WoodCreator.create("spiritual", SaplingGeneratorInit.SPIRITUAL_TREE).build();
    public static final class_2248 MAGIC_ICE_BLOCK = registerBlock("magic_ice", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10384));
    public static final class_2248 POINT_BLOCK = registerBlock("point_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10340));
    public static final class_2248 POWER_BLOCK = registerBlock("power_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10340));
    public static final DecorativeBlockCreator ICE_SCALES = DecorativeBlockCreator.create("ice_scales_block").build();
    public static final DecorativeBlockCreator DREAM_STONE = DecorativeBlockCreator.create("dream_stone").build();
    public static final DecorativeBlockCreator DREAM_STONE_BRICK = DecorativeBlockCreator.create("dream_stone_brick").build();
    public static final DecorativeBlockCreator MOON_STONE = DecorativeBlockCreator.create("moon_stone").build();
    public static final DecorativeBlockCreator MOON_STONE_BRICK = DecorativeBlockCreator.create("moon_stone_brick").build();

    static {
        DREAM_STONE_BRICK.base(DREAM_STONE.block());
        MOON_STONE_BRICK.base(MOON_STONE.block());
    }

    public static final class_2248 SILVER_ORE = registerBlock("silver_ore", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10212));
    public static final class_2248 DEEPSLATE_SILVER_ORE = registerBlock("deepslate_silver_ore", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_29027));
    public static final class_2248 SILVER_BLOCK = registerBlock("silver_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10085));
    public static final ChestBlockCreator SILVER_CHEST_BLOCK = ChestBlockCreator.create(
            "silver_chest",
            class_4970.class_2251.method_9630(class_2246.field_10085)
    ).build();
    public static final class_2248 ORB_ORE = registerBlock("orb_ore", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_29027));
    public static final class_2248 DEEPSLATE_ORB_ORE = registerBlock("deepslate_orb_ore", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_29027));
    public static final class_2248 RED_ORB_BLOCK = registerBlock("red_orb_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10234));
    public static final class_2248 YELLOW_ORB_BLOCK = registerBlock("yellow_orb_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10234));
    public static final class_2248 BLUE_ORB_BLOCK = registerBlock("blue_orb_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10234));
    public static final class_2248 GREEN_ORB_BLOCK = registerBlock("green_orb_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10234));
    public static final class_2248 PURPLE_ORB_BLOCK = registerBlock("purple_orb_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10234));

    public static final class_2248 DREAM_RED_BLOCK = registerBlock("dream_world_red_line_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_9987));
    public static final class_2248 DREAM_BLUE_BLOCK = registerBlock("dream_world_blue_line_block", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_9987));
    public static final class_2248 DREAM_CRYSTAL_ORE = registerBlock("dream_crystal_ore", class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10212));

    public static final class_2248 MARISA_HAT_BLOCK = registerBlock("marisa_hat", (settings) -> new MarisaHatBlock(class_243.field_1353, settings), class_4970.class_2251.method_9630(class_2246.field_10446), new class_1792.class_1793().method_7889(1).method_57349(class_9334.field_54196, class_10192.method_64202(class_1304.field_6169).method_64209(false).method_64203()));
    public static final class_2248 CASH_BOX_BLOCK = registerBlock("cash_box", CashBoxBlock::new, class_4970.class_2251.method_9630(class_2246.field_10161));
    public static final class_2248 ANTI_COLLISION_BARREL = registerBlock("anti_collision_barrel", ModelBlock::new, class_4970.class_2251.method_9630(class_2246.field_10085));
    public static final class_2248 WHEEL_CHAIR = registerBlock("wheel_chair", WheelChairBlock::new, class_4970.class_2251.method_9630(class_2246.field_10085));
    public static final ChestBlockCreator WOODEN_BOX = ChestBlockCreator.create(
            "wooden_box",
            class_4970.class_2251.method_9630(class_2246.field_10034)
    ).build();
    public static void registerBlocks() {

    }

    public static class_2248 registerSimpleBlock(class_2248 block) {
        PolymerBlockHelper.registerOverlay(block);
        BlockTypeGroup.join(block);
        return block;
    }

    public static class_2248 registerSimpleBlock(class_2960 id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, class_1792.class_1793 itemSettings) {
        class_2248 block = factory.apply(settings.method_63500(keyOf(id)).method_22488());
        class_2378.method_10230(class_7923.field_41175, id, block);
        class_1792 item = ModItems.registerSimpleItem(id, (itemSetting -> new class_1747(block, itemSetting)), itemSettings.method_63685());
        return registerSimpleBlock(block);
    }

    public static class_2248 registerSimpleBlock(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, class_1792.class_1793 itemSettings) {
        return registerSimpleBlock(Touhou.id(name), factory, settings, itemSettings);
    }

    public static class_2248 registerSimpleBlock(class_2960 id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return registerSimpleBlock(id, factory, settings, new class_1792.class_1793());
    }

    public static class_2248 registerSimpleBlock(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return registerSimpleBlock(name, factory, settings, new class_1792.class_1793());
    }

    public static class_2248 registerBlock(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings, class_1792.class_1793 itemSettings) {
        class_2248 block = registerSimpleBlock(name, factory, settings);
        BLOCKS.add(block);
        return block;
    }

    public static class_2248 registerBlock(String name, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
        return registerBlock(name, factory, settings, new class_1792.class_1793());
    }

    public static class_5321<class_2248> keyOf(String id) {
        return class_5321.method_29179(class_7924.field_41254, Touhou.id(id));
    }

    public static class_5321<class_2248> keyOf(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41254, id);
    }

}
