package cc.thonly.reverie_dreams.block;

import cc.thonly.reverie_dreams.Touhou;
import lombok.Getter;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.block.*;
import net.minecraft.class_10716;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2960;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_7923;
import net.minecraft.class_8177;
import net.minecraft.class_8813;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class WoodCreator extends AbstractBlockCreator {
    public static final List<WoodCreator> INSTANCES = new ArrayList<>();
    public static final List<class_1792> BLOCK_ITEMS = new ArrayList<>();
    @Getter
    private final class_8813 saplingGenerator;
    @Getter
    private class_5794 blockFamily;
    private class_2248 log;
    private class_2248 wood;
    private class_2248 strippedLog;
    private class_2248 strippedWood;
    private class_2248 leaves;
    private class_2248 sapling;
    private class_2248 planks;
    private class_2248 stairs;
    private class_2248 slab;
    private class_2248 door;
    private class_2248 trapdoor;
    private class_2248 fence;
    private class_2248 fenceGate;
    private class_2248 button;

    private WoodCreator(class_2960 id, class_8813 saplingGenerator) {
        super(id.method_12832(), id);
        this.saplingGenerator = saplingGenerator;
        INSTANCES.add(this);
    }

    private WoodCreator(String name, class_8813 saplingGenerator) {
        this(Touhou.id(name), saplingGenerator);
    }

    public WoodCreator build() {
        this.log = ModBlocks.registerSimpleBlock(suffix("log"),
                class_2465::new, class_4970.class_2251.method_9630(class_2246.field_10431).method_22488());

        this.wood = ModBlocks.registerSimpleBlock(suffix("wood"),
                class_2465::new, class_4970.class_2251.method_9630(class_2246.field_10431).method_22488());

        this.strippedLog = ModBlocks.registerSimpleBlock(prefix(suffix("log"), "stripped"),
                class_2465::new, class_4970.class_2251.method_9630(class_2246.field_10431).method_22488());

        this.strippedWood = ModBlocks.registerSimpleBlock(prefix(suffix("wood"), "stripped"),
                class_2465::new, class_4970.class_2251.method_9630(class_2246.field_10126).method_22488());

        this.leaves = ModBlocks.registerSimpleBlock(suffix("leaves"),
                (settings) -> new class_10716(0.01f, settings), class_4970.class_2251.method_9630(class_2246.field_10503));

        this.sapling = ModBlocks.registerSimpleBlock(suffix("sapling"),
                (settings) -> new class_2473(this.saplingGenerator, settings), class_4970.class_2251.method_9630(class_2246.field_10394));

        this.planks = ModBlocks.registerSimpleBlock(suffix("planks"),
                class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10161));

        this.stairs = ModBlocks.registerSimpleBlock(suffix("stairs"),
                (settings) -> new class_2510(this.planks.method_9564(), settings), class_4970.class_2251.method_9630(class_2246.field_10563));

        this.slab = ModBlocks.registerSimpleBlock(suffix("slab"),
                class_2482::new, class_4970.class_2251.method_9630(class_2246.field_10119));

        this.door = ModBlocks.registerSimpleBlock(suffix("door"),
                (settings) -> new class_2323(class_8177.field_42823, settings), class_4970.class_2251.method_9630(class_2246.field_10149));

        this.trapdoor = ModBlocks.registerSimpleBlock(suffix("trapdoor"),
                (settings) -> new class_2533(class_8177.field_42823, settings), class_4970.class_2251.method_9630(class_2246.field_10137));

        this.fence = ModBlocks.registerSimpleBlock(suffix("fence"),
                class_2354::new, class_4970.class_2251.method_9630(class_2246.field_10620));

        this.fenceGate = ModBlocks.registerSimpleBlock(suffix("fence_gate"),
                (settings) -> new class_2349(class_4719.field_21676, settings), class_4970.class_2251.method_9630(class_2246.field_10188));

        this.button = ModBlocks.registerSimpleBlock(suffix("button"),
                (settings) -> new class_2269(class_8177.field_42823, 30, settings), class_4970.class_2251.method_9630(class_2246.field_10057));

        class_7923.field_41178.addAlias(suffix("stair"), suffix("stairs"));

        this.stream().forEach((block) -> {
            BLOCK_ITEMS.add(block.method_8389());
        });
        StrippableBlockRegistry.register(this.log, this.strippedLog);

        this.blockFamily = class_5793.method_33468(this.planks())
                .method_33492(this.slab())
                .method_33493(this.stairs())
                .method_33490(this.fence())
                .method_33491(this.fenceGate())
                .method_33482(this.button())
                .method_33489(this.door())
                .method_33496(this.trapdoor())
                .method_33484("wooden").method_33487("has_planks")
                .method_33481();
        return this;
    }

    public class_2248 log() {
        return this.log;
    }

    public class_2248 wood() {
        return this.wood;
    }

    public class_2248 strippedLog() {
        return this.strippedLog;
    }

    public class_2248 strippedWood() {
        return this.strippedWood;
    }

    public class_2248 leaves() {
        return this.leaves;
    }

    public class_2248 sapling() {
        return this.sapling;
    }

    public class_2248 planks() {
        return this.planks;
    }

    public class_2248 stairs() {
        return this.stairs;
    }

    public class_2248 slab() {
        return this.slab;
    }

    public class_2248 door() {
        return this.door;
    }

    public class_2248 trapdoor() {
        return this.trapdoor;
    }

    public class_2248 fence() {
        return this.fence;
    }

    public class_2248 fenceGate() {
        return this.fenceGate;
    }

    public class_2248 button() {
        return this.button;
    }

    public Stream<class_2248> stream() {
        return Stream.of(
                log,
                wood,
                strippedLog,
                strippedWood,
                leaves,
                sapling,
                planks,
                stairs,
                slab,
                door,
                trapdoor,
                fence,
                fenceGate,
                button
        ).filter(Objects::nonNull);
    }


    public static WoodCreator create(String name, class_8813 saplingGenerator) {
        return new WoodCreator(name, saplingGenerator);
    }

    public static WoodCreator create(class_2960 id, class_8813 saplingGenerator) {
        return new WoodCreator(id, saplingGenerator);
    }
}
