package cc.thonly.reverie_dreams.command;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.debug.DebugExportWriter;
import cc.thonly.reverie_dreams.dialog.DialogFiles;
import cc.thonly.reverie_dreams.dialog.DialogInit;
import cc.thonly.reverie_dreams.dialog.DialogPlayer;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeCategoryGui;
import cc.thonly.reverie_dreams.util.ImageToTextScanner;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_11419;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import java.awt.image.BufferedImage;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;

@Slf4j
public class MainCommand implements CommandInit.CommandRegistration {

    public static class DialogSuggestionProvider implements SuggestionProvider<class_2168> {
        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            for (String string : DialogInit.ARGS_DIALOG.keySet()) {
                builder.suggest(string);
            }
            return builder.buildFuture();
        }
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher,
                         class_7157 access,
                         class_2170.class_5364 environment
    ) {
        dispatcher.register(
                class_2170.method_9247("touhou")
                        .executes(this::run)
                        .then(
                                class_2170.method_9247("help")
                                        .executes(this::help)
                        )
                        .then(
                                class_2170.method_9247("recipe")
                                        .executes(this::recipe)
                        )
                        .then(
                                class_2170.method_9247("dialog")
                                        .then(
                                                class_2170
                                                        .method_9244("value", StringArgumentType.string())
                                                        .suggests(new DialogSuggestionProvider())
                                                        .executes(this::dialog)
                                        )
                        )
                        .then(
                                class_2170.method_9247("video")
                                        .requires(source -> source.method_9259(2))
                                        .then(
                                                class_2170.method_9247("play")
                                                        .then(
                                                                class_2170.method_9244("target", class_2186.method_9309())
                                                                        .then(
                                                                                class_2170.method_9244("file", StringArgumentType.string())
                                                                                        .suggests(new DialogFiles.FilesSuggestionProvider())
                                                                                        .executes(this::playVideo)
                                                                                        .then(
                                                                                                class_2170.method_9244("sound", class_2232.method_9441())
                                                                                                        .suggests(class_2321.method_71942(class_2321.field_10934))
                                                                                                        .executes(this::playVideo)
                                                                                        )
                                                                        )
                                                        )

                                        )
                                        .then(
                                                class_2170
                                                        .method_9247("reload")
                                                        .executes(this::reloadVideo)
                                        )
                        )
                        .then(
                                class_2170.method_9247("about")
                                        .executes(this::about)
                        )
//                        .then(
//                                CommandManager.literal("export_registries")
//                                        .executes(this::exportRegistries)
//                        )
                        .then(
                                class_2170.method_9247("ui_relay_recipe")
                                        .executes((context) -> 0)
                        )
        );
    }

    private int run(CommandContext<class_2168> context) {
        class_5250 text = class_2561.method_43471("command.touhou.suggest_help");
        context.getSource().method_9226(() -> text.method_10862(class_2583.field_24360.method_10977(class_124.field_1054)), false);
        return 1;
    }

    private int reloadVideo(CommandContext<class_2168> context) {
        DialogFiles.reload();
        context.getSource().method_9226(()-> class_2561.method_43471("command.touhou.video.reload"), false);
        return 1;
    }

    private int playVideo(CommandContext<class_2168> context) {
        try {
            class_3222 player = class_2186.method_9315(context, "target");
            String file = StringArgumentType.getString(context, "file");
            class_2960 soundEventId = null;
            class_3414 soundEvent = null;
            try {
                soundEventId = class_2232.method_9443(context, "sound");
            } catch (Exception ignored) {
            }
            if (soundEventId != null) {
                soundEvent = class_3414.method_47908(soundEventId);
            }
            context.getSource().method_9226(()-> class_2561.method_43471("command.touhou.video.reload"), false);
            DialogPlayer.play(player, file, soundEvent);
            context.getSource().method_9226(()-> class_2561.method_43471("command.touhou.video.load.done"), false);
        } catch (Exception err) {
            log.error("Can't play video", err);
        }
        return 1;
    }

    private int help(CommandContext<class_2168> context) {
        List<String> keys = List.of(
                "command.touhou.help.title",
                "command.touhou.help.help",
                "command.touhou.help.recipe",
                "command.touhou.help.about",
                "command.touhou.help.empty"
        );

        for (String key : keys) {
            context.getSource().method_9226(() -> class_2561.method_43471(key).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)), false);
        }
        return 1;
    }

    private int dialog(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        if (!source.method_43737()) {
            return 0;
        }
        class_3222 player = source.method_44023();
        String value = StringArgumentType.getString(context, "value");
        class_11419 dialog = DialogInit.ARGS_DIALOG.get(value);
        if (player != null && dialog != null) {
            player.method_71753(class_6880.method_40223(dialog));
        }
        return 1;
    }

    private int exportRegistries(CommandContext<class_2168> context) {
        List<String> lines = new LinkedList<>();
        class_2168 source = context.getSource();
        MinecraftServer server = source.method_9211();
        class_5455.class_6890 registryManager = server.method_30611();
        Stream<class_5455.class_6892<Object>> entryStream = (Stream<class_5455.class_6892<Object>>) (Object) registryManager.method_40311();
        List<class_5455.class_6892<Object>> list = entryStream.toList();
        for (class_5455.class_6892<Object> entry : list) {
            class_5321<? extends class_2378<Object>> key = entry.comp_350();
            class_2378<Object> registry = entry.comp_351();

            lines.add("===== Registry: " + key.method_29177() + " =====");
            registry.forEach(obj -> {
                int rawId = registry.method_10206(obj);
                class_2960 id = registry.method_10221(obj);
                if (rawId == 97) {
                    lines.add("!!! Found 97 in " + key.method_29177() + " = " + id);
                }
            });
        }
        DebugExportWriter output = DebugExportWriter.OUTPUT;
        for (String line : lines) {
            output.write(line);
        }
        output.export();
        return 1;
    }

    private int about(CommandContext<class_2168> context) {
        Class<?> clazz = Touhou.class;
        ImageToTextScanner instance = ImageToTextScanner.createInstance(clazz);
        String path = ImageToTextScanner.ofNamespace(Touhou.MOD_ID, "icon_about.png");
        BufferedImage iconBuffer = instance.loadImageFromJar(path);
        List<class_2561> iconText = instance.renderImageToText(iconBuffer, 16, 16);

        String[] infoKeys = new String[]{
                "command.touhou.about.line1",
                "command.touhou.about.line2",
                "command.touhou.about.line3",
                "command.touhou.about.line4",
                "command.touhou.about.line5",
                "command.touhou.about.line6",
                "command.touhou.about.title",
                "command.touhou.about.version",
                "command.touhou.about.author",
                "command.touhou.about.line10",
                "command.touhou.about.line11"
        };

        List<class_2561> rightTexts = new ArrayList<>();
        for (String key : infoKeys) {
            if (key.equals("command.touhou.about.version")) {
                rightTexts.add(class_2561.method_43469(key, ConstantInfo.VERSION));
            } else {
                rightTexts.add(class_2561.method_43471(key));
            }
        }

        while (rightTexts.size() < iconText.size()) {
            rightTexts.add(class_2561.method_43470(""));
        }

        for (int i = 0; i < iconText.size(); i++) {
            class_2561 left = iconText.get(i);
            class_2561 right = rightTexts.get(i).method_27661().method_27692(class_124.field_1068);
            context.getSource().method_9226(() -> class_2561.method_43473().method_10852(left).method_10852(class_2561.method_43470("  ")).method_10852(right), false);
        }

        return 1;
    }

    private int recipe(CommandContext<class_2168> context) {
        class_2168 source = context.getSource();
        class_3222 player = source.method_44023();
        if (player != null) {
            RecipeTypeCategoryGui.create(player);
        }
        return 1;
    }
}
