package cc.thonly.reverie_dreams.compat;

import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.mystias_izakaya.recipe.MiRecipeManager;
import cc.thonly.mystias_izakaya.recipe.entry.KitchenRecipe;
import cc.thonly.mystias_izakaya.registry.FoodProperties;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesCallback;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesImpl;
import cc.thonly.reverie_dreams.api.RegistryManagerReloadCallback;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import vectorwing.farmersdelight.common.registry.ModItems;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

@SuppressWarnings("unchecked")
public class FarmersdelightCompatImpl {
    public static void bootstrap() {
        RecipeCompatPatchesCallback.EVENT.register(() -> {
            RecipeCompatPatchesImpl.Builder<KitchenRecipe> builder = RecipeCompatPatchesImpl.getOrCreateBuilder(MiRecipeManager.KITCHEN_RECIPE);
            builder.add(MIItems.TOMATO, ModItems.TOMATO.get());
            builder.add(MIItems.ONION, ModItems.ONION.get());
            builder.add(class_1802.field_8389, ModItems.BACON.get());
            builder.add(class_1802.field_17518, ModItems.PUMPKIN_SLICE.get());
            builder.add(class_1802.field_8748, ModItems.MUTTON_CHOPS.get());
            builder.add(class_1802.field_8429, ModItems.COD_SLICE.get());
            builder.add(class_1802.field_8209, ModItems.SALMON_SLICE.get());
            builder.add(class_1802.field_8046, ModItems.MINCED_BEEF.get());
            builder.add(MIItems.WAGYU_BEEF, ModItems.MINCED_BEEF.get());
        });
        RegistryManagerReloadCallback.EVENT.register(simpleRegistry -> {
            if (!simpleRegistry.equals(MIRegistryManager.FOOD_PROPERTY)) {
                return;
            }
            IntrinsicalRegister<FoodProperty> registry = (IntrinsicalRegister<FoodProperty>) simpleRegistry;
            Stream<? extends Map.Entry<class_2960, FoodProperty>> stream = registry.streamIdToValue();
            stream.forEach((Consumer<Map.Entry<class_2960, FoodProperty>>) mapEntry -> {
                FoodProperty property = mapEntry.getValue();
                Set<class_1792> tags = property.getItems();
                if (property.equals(FoodProperties.VEGETARIAN)) {
                    tags.add(ModItems.CABBAGE.get());
                    tags.add(ModItems.CABBAGE_LEAF.get());
                    tags.add(ModItems.TOMATO.get());
                    tags.add(ModItems.ONION.get());
                }
                if (property.equals(FoodProperties.UMAMI)) {
                    tags.add(ModItems.ONION.get());
                }
                if (property.equals(FoodProperties.AQUATIC_PRODUCTS)) {
                    tags.add(ModItems.COD_SLICE.get());
                    tags.add(ModItems.SALMON_SLICE.get());
                }
            });
        });
    }
}
