package cc.thonly.reverie_dreams.compat;

import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.mystias_izakaya.recipe.MiRecipeManager;
import cc.thonly.mystias_izakaya.recipe.entry.KitchenRecipe;
import cc.thonly.mystias_izakaya.registry.FoodProperties;
import cc.thonly.mystias_izakaya.registry.MIRegistryManager;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesCallback;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesImpl;
import cc.thonly.reverie_dreams.api.RegistryManagerReloadCallback;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import com.axperty.moredelight.registry.ItemRegistry;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

@SuppressWarnings("unchecked")
public class MoreDelightCompatImpl {
    public static void bootstrap() {
        RecipeCompatPatchesCallback.EVENT.register(() -> {
            RecipeCompatPatchesImpl.Builder<KitchenRecipe> builder = RecipeCompatPatchesImpl.getOrCreateBuilder(MiRecipeManager.KITCHEN_RECIPE);
            builder.add(ItemRegistry.DICED_POTATOES, class_1802.field_8567);
        });
        RegistryManagerReloadCallback.EVENT.register(simpleRegistry -> {
            if (!simpleRegistry.equals(MIRegistryManager.FOOD_PROPERTY)) {
                return;
            }
            IntrinsicalRegister<FoodProperty> registry = (IntrinsicalRegister<FoodProperty>) simpleRegistry;
            Stream<Map.Entry<class_2960, FoodProperty>> stream = registry.streamIdToValue();
            stream.forEach(mapEntry -> {
                FoodProperty property = mapEntry.getValue();
                Set<class_1792> items = property.getItems();
                if (property.equals(FoodProperties.VEGETARIAN)) {
                    items.add( ItemRegistry.DICED_POTATOES);
                }
                if (property.equals(FoodProperties.HOMESTYLE)) {
                    items.add( ItemRegistry.DICED_POTATOES);
                }
            });
        });
    }
}
