package cc.thonly.reverie_dreams.compat;

import cc.thonly.polydex2eiv.api.ItemViewServerModifier;
import cc.thonly.reverie_dreams.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.danmaku.SpellCardTemplates;
import cc.thonly.reverie_dreams.item.builder.RoleCard;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public class Polydex2EIVCompatImpl {
    public static void bootstrap(
    ) {
        ItemViewServerModifier.MODIFIER.register(() -> {
            List<class_1799> stacks = new ArrayList<>();
            Collection<DanmakuType> danmakuTypes = RegistryManager.DANMAKU_TYPE.values();
            for (DanmakuType danmakuType : danmakuTypes) {
                List<class_3545<class_1792, class_1799>> pairs = danmakuType.getColorPairs();
                for (class_3545<class_1792, class_1799> pair : pairs) {
                    stacks.add(pair.method_15441());
                }
            }

            Collection<class_1799> spellCardTemplates = SpellCardTemplates.getRegistryItemStackView().values();
            stacks.addAll(spellCardTemplates);

            Collection<RoleCard> roleCards = RegistryManager.ROLE_CARD.values();
            for (RoleCard instance : roleCards) {
                stacks.add(instance.itemStack());
            }

            return stacks;
        });
    }
}
