package cc.thonly.reverie_dreams.compat.page;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.gui.BasePageGui;
import cc.thonly.reverie_dreams.gui.recipe.GuiOpeningPrevCallback;
import cc.thonly.reverie_dreams.gui.recipe.display.DanmakuShapeDisplayView;
import cc.thonly.reverie_dreams.item.ModGuiItems;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import cc.thonly.reverie_dreams.recipe.view.RecipeEntryWrapper;
import eu.pb4.polydex.api.v1.recipe.*;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import lombok.Getter;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

@Getter
public class DanmakuShapePage implements PolydexPage {
    public static final class_2960 id = Touhou.id("recipe/danmaku_shape");
    public static final PolydexCategory CATEGORY = PolydexCategory.of(id);
    private static final class_2561 TEXTURE = class_2561.method_43473();
    public static final class_1799 ICON = new GuiElementBuilder(ModItems.DANMAKU_SHAPE_CREATOR).setName(class_2561.method_43471(id.method_42094())).asStack();
    public final class_2960 key;
    public final DanmakuShapeDrawRecipe value;
    private final List<PolydexIngredient<?>> ingredients;
    private final PolydexStack<?> output;

    public DanmakuShapePage(class_2960 key, DanmakuShapeDrawRecipe value) {
        this.key = key.method_45138("recipe/");
        this.value = value;
        this.ingredients = List.of(PolydexIngredient.of(class_1856.method_8101(ModGuiItems.ENABLE)));
        this.output = PolydexStack.of(this.value.getOutput().getItemStack());
    }

    @Override
    public class_2960 identifier() {
        return key;
    }

    @Override
    public class_1799 typeIcon(class_3222 serverPlayerEntity) {
        return ICON;
    }

    @Override
    public class_1799 entryIcon(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity) {
        return this.value.getOutput().getItemStack();
    }

    @Override
    public void createPage(@Nullable PolydexEntry polydexEntry, class_3222 serverPlayerEntity, PageBuilder layout) {
        Runnable runnable = ()-> {
            DanmakuShapeDisplayView view = new DanmakuShapeDisplayView(serverPlayerEntity, RecipeEntryWrapper.of(this.key, this.value), null);
            view.open();
        };
        String[][] views = {
                {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "E", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
                {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
        };
        for (int row = 0; row < views.length; row++) {
            for (int col = 0; col < views[row].length; col++) {
                layout.set(col, row, getViewStack(views[row][col], (i, clickType, slotActionType) -> runnable.run()));
            }
        }
    }

    private GuiElementBuilder getViewStack(String s, GuiElementInterface.ItemClickCallback callback) {
        if (s.equalsIgnoreCase("X")) {
            return new GuiElementBuilder(ModGuiItems.EMPTY_SLOT);
        }
        if (s.equalsIgnoreCase("E")) {
            return new GuiElementBuilder(this.value.getOutput().getItemStack().copy())
                    .setCallback(callback)
                    .setLore(List.of(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.recipe.no_compat"))));
        }
        return new GuiElementBuilder(class_1802.field_8162);
    }

    @Override
    public List<PolydexIngredient<?>> ingredients() {
        return this.getIngredients();
    }

    @Override
    public List<PolydexCategory> categories() {
        return List.of(CATEGORY);
    }

    @Override
    public boolean isOwner(MinecraftServer minecraftServer, PolydexEntry polydexEntry) {
        return polydexEntry.isPartOf(output);
    }
}
