package cc.thonly.reverie_dreams.component;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.tooltip.ModTooltips;
import cc.thonly.reverie_dreams.item.prop.MusicalInstrumentItem;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.mojang.serialization.Codec;
import eu.pb4.polymer.core.api.other.PolymerComponent;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2378;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import java.util.List;

@Slf4j
public class ModDataComponentTypes {
    public static class Danmaku {
        public static final class_9331<String> TEMPLATE = registerComponent("template",
                class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880());
        public static final class_9331<Integer> COUNT = registerComponent("count",
                class_9331.<Integer>method_57873().method_57881(Codec.INT).method_57880());
        public static final class_9331<Float> DAMAGE = registerComponent("damage",
                class_9331.<Float>method_57873().method_57881(Codec.FLOAT).method_57880());
        public static final class_9331<String> DAMAGE_TYPE = registerComponent("damage_type",
                class_9331.<String>method_57873().method_57881(Codec.STRING).method_57880());
        public static final class_9331<Float> SCALE = registerComponent("scale",
                class_9331.<Float>method_57873().method_57881(Codec.FLOAT).method_57880());
        public static final class_9331<Float> SPEED = registerComponent("speed",
                class_9331.<Float>method_57873().method_57881(Codec.FLOAT).method_57880());
        public static final class_9331<Float> ACCELERATION = registerComponent("acceleration",
                class_9331.<Float>method_57873().method_57881(Codec.FLOAT).method_57880());
        public static final class_9331<Boolean> TILE = registerComponent("tile",
                class_9331.<Boolean>method_57873().method_57881(Codec.BOOL).method_57880());
        public static final class_9331<Boolean> INFINITE = registerComponent("infinite",
                class_9331.<Boolean>method_57873().method_57881(Codec.BOOL).method_57880());
        public static final class_9331<ItemStackWrapper> SHAPE = registerComponent("shape",
                class_9331.<ItemStackWrapper>method_57873().method_57881(ItemStackWrapper.CODEC).method_57880());
        public static void init() {

        }
    }

//    public static final ComponentType<Identifier> REGISTRY_KEY = registerComponent("registry_key",
//            ComponentType.<Identifier>builder()
//                    .codec(RegistryKeyComponent.CODEC)
//                    .build());

//    public static final ComponentType<OverTooltipAppender> OVER_TOOLTIP_APPENDER = registerComponent("over_tooltip_appender",
//            ComponentType.<OverTooltipAppender>builder()
//                    .codec(OverTooltipAppender.CODEC)
//                    .build());

    public static final class_9331<class_3902> SILVER_ITEM = registerComponent("silver_item",
            class_9331.<class_3902>method_57873()
                    .method_57881(class_3902.field_51563)
                    .method_57880()
    );
    public static final class_9331<class_2960> ROLE_CARD_ID = registerComponent("role_card_id",
            class_9331.<class_2960>method_57873()
                    .method_57881(class_2960.field_25139)
                    .method_57880());
    public static final class_9331<Integer> MAX_DISTANCE = registerComponent("max_distance",
            class_9331.<Integer>method_57873()
                    .method_57881(Codec.INT)
                    .method_57880());
    public static final class_9331<List<GapRecorder>> GAP_RECORDER = registerComponent("gap_recorder",
            class_9331.<List<GapRecorder>>method_57873()
                    .method_57881(GapRecorder.LIST_CODEC)
                    .method_57880());
    public static final class_9331<BattleStickRecorder> BATTLE_STICK_RECORDER = registerComponent("battle_stick_recorder",
            class_9331.<BattleStickRecorder>method_57873()
                    .method_57881(BattleStickRecorder.CODEC)
                    .method_57880());
    public static final class_9331<String> PLAYING_MUSIC = registerComponent("playing_music",
            class_9331.<String>method_57873()
                    .method_57881(Codec.STRING)
                    .method_57880());
    public static final class_9331<class_2766> NOTE_TYPE = registerComponent("note_type",
            class_9331.<class_2766>method_57873()
                    .method_57881(MusicalInstrumentItem.NOTE_BLOCK_INSTRUMENT_CODEC)
                    .method_57880());
    public static final class_9331<RoleFollowerArchive> ROLE_FOLLOWER_ARCHIVE = registerComponent("role_follower_archive",
            class_9331.<RoleFollowerArchive>method_57873()
                    .method_57881(RoleFollowerArchive.CODEC)
                    .method_57880()
    );
    public static final class_9331<Boolean> ROLE_CAN_RESPAWN = registerComponent("role_can_respawn",
            class_9331.<Boolean>method_57873()
                    .method_57881(Codec.BOOL)
                    .method_57880()
    );

    public static void init() {
        ModTooltips.bootstrap();
        try {
            Class.forName(Danmaku.class.getName(), true, Danmaku.class.getClassLoader());
        } catch (Exception err) {
            log.error("Can't initialize danmaku component", err);
        }

    }

    public static <T> class_9331<T> registerComponent(String path, class_9331<T> componentType) {
        class_9331<T> value = class_2378.method_10230(class_7923.field_49658, Touhou.id(path), componentType);
        PolymerComponent.registerDataComponent(value);
        return value;
    }
}
