package cc.thonly.reverie_dreams.component;

import cc.thonly.minecraft.inventory.InventoriesImpl;
import cc.thonly.minecraft.inventory.Slot2ItemStack;
import cc.thonly.minecraft.text.TextUtil;
import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import java.util.List;
import java.util.Optional;

@Getter
public class RoleFollowerArchive {
    public static final Codec<RoleFollowerArchive> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("entity_type_id").forGetter(RoleFollowerArchive::getEntityTypeId),
            Codec.STRING.fieldOf("name").forGetter(RoleFollowerArchive::getNameJson),
            Codec.STRING.fieldOf("inventory_nbt").forGetter(RoleFollowerArchive::getInventoryJson)
    ).apply(instance, RoleFollowerArchive::new));

    private final class_2960 entityTypeId;
    private final String nameJson;
    private final String inventoryJson;


    public RoleFollowerArchive(class_2960 entityTypeId, String nameJson, String inventoryJson) {
        this.entityTypeId = entityTypeId;
        this.nameJson = nameJson;
        this.inventoryJson = inventoryJson;
    }

    public RoleFollowerArchive(class_1299<?> entityType, NPCEntityImpl entity, class_7225.class_7874 registries) {
        this.entityTypeId = class_7923.field_41177.method_10221(entityType);
        this.nameJson = entity.method_16914() ? TextUtil.encode(entity.method_5477()) : "";
        NPCInventoryImpl inventory = entity.getInventory();
        this.inventoryJson = InventoriesImpl.toJson(inventory.field_5828);
    }

    public NPCEntityImpl respawn(class_3218 world, class_2338 pos, class_7225.class_7874 registries) {
        class_1299<?> entityType = class_7923.field_41177.method_63535(this.entityTypeId);
        class_1297 entity = entityType.method_47821(world, pos, class_3730.field_16471);

        if (!(entity instanceof NPCEntityImpl impl)) {
            return null;
        }

        NPCInventoryImpl inventory = new NPCInventoryImpl(NPCInventoryImpl.MAX_SIZE);
        class_2371<class_1799> heldStacks = inventory.field_5828;
        Optional<List<Slot2ItemStack>> slot2ItemStacks = InventoriesImpl.parseJson(this.inventoryJson);
        if (slot2ItemStacks.isPresent()) {
            List<Slot2ItemStack> list = slot2ItemStacks.get();
            for (Slot2ItemStack slot2ItemStack : list) {
                int index = slot2ItemStack.index();
                if (index < 0 || index >= heldStacks.size()) continue;
                heldStacks.set(slot2ItemStack.index(), slot2ItemStack.itemStack());
            }
        }
        impl.setInventory(inventory);

        if (!this.nameJson.isEmpty()) {
            Optional<class_2561> decode = TextUtil.decode(this.nameJson);
            decode.ifPresent(entity::method_5665);
        }

        return impl;
    }
}
