package cc.thonly.reverie_dreams.component.tooltip;

import cc.thonly.minecraft.api.ItemStackTooltipCallback;
import cc.thonly.mystias_izakaya.component.DrinkProperty;
import cc.thonly.mystias_izakaya.component.FoodProperty;
import cc.thonly.mystias_izakaya.item.base.DrinkItem;
import cc.thonly.mystias_izakaya.item.base.FoodItem;
import cc.thonly.mystias_izakaya.item.base.IngredientItem;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.item.builder.RoleCard;
import cc.thonly.reverie_dreams.item.danmaku.AbstractDanmakuItem;
import cc.thonly.reverie_dreams.item.prop.FumoLicenseItem;
import cc.thonly.reverie_dreams.item.template.DanmakuShapeCreatorItem;
import cc.thonly.reverie_dreams.item.template.RoleCardItem;
import cc.thonly.reverie_dreams.item.template.SpellCardTemplateItem;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class ModTooltips {
    public static void bootstrap() {
        Event<ItemStackTooltipCallback> event = ItemStackTooltipCallback.EVENT;
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof AbstractDanmakuItem abstractDanmakuItem)) {
                return;
            }
            Float damage = stack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE, null);
            Float scale = stack.method_58695(ModDataComponentTypes.Danmaku.SCALE, null);
            Float speed = stack.method_58695(ModDataComponentTypes.Danmaku.SPEED, null);
            Integer count = stack.method_58695(ModDataComponentTypes.Danmaku.COUNT, AbstractDanmakuItem.DEFAULT_COUNT);
            String templateType = stack.method_58695(ModDataComponentTypes.Danmaku.TEMPLATE, Touhou.id("single").toString());

            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.damage")).method_27693(String.valueOf(damage)));
            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.speed")).method_27693(String.valueOf(speed)));
            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.count")).method_27693(String.valueOf(count)));
            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.base_type")).method_10852(class_2561.method_43471(class_2960.method_60654(templateType).method_42094())));
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof DanmakuShapeCreatorItem danmakuShapeCreatorItem)) {
                return;
            }
            ItemStackWrapper itemStackWrapper = stack.method_58695(ModDataComponentTypes.Danmaku.SHAPE, ItemStackWrapper.of(class_1802.field_8162));
            class_1799 itemStack = itemStackWrapper.getItemStack();
            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.shape")).method_10852(itemStack.method_7964()));
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof DrinkItem drinkItem)) {
                return;
            }
            List<DrinkProperty> allProperties = DrinkProperty.getAllProperties(stack);
            if (!allProperties.isEmpty()) {
                textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.food_properties")));
            }
            for (DrinkProperty property : allProperties) {
                textConsumer.accept(class_2561.method_43473().method_27693("§b+").method_10852(class_2561.method_43471(property.translateKey())));
            }
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof FoodItem foodItem)) {
                return;
            }
            List<FoodProperty> foodProperties = FoodProperty.getFromItemStackComponent(stack);
            List<FoodProperty> foodIngredientProperties = FoodProperty.getIngredientProperties(stack.method_7909());
            Set<FoodProperty> foodPropertyList = new HashSet<>();
            foodPropertyList.addAll(foodProperties);
            foodPropertyList.addAll(foodIngredientProperties);
            if (!foodPropertyList.isEmpty()) {
                textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.food_properties")));
            }
            for (FoodProperty foodProperty : foodPropertyList) {
                textConsumer.accept(class_2561.method_43473().method_27693(FoodProperty.getDisplayPrefix(stack, foodProperty)).method_10852(foodProperty.getTooltip()));
            }
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof FumoLicenseItem fumoLicenseItem)) {
                return;
            }
            textConsumer.accept(class_2561.method_43471("item.tooltip.use.villager"));
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof IngredientItem ingredientItem)) {
                return;
            }
            List<FoodProperty> foodProperties = FoodProperty.getIngredientProperties(stack.method_7909());
            if (!foodProperties.isEmpty()) {
                textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.food_properties")));
            }
            for (FoodProperty foodProperty : foodProperties) {
                textConsumer.accept(class_2561.method_43473().method_27693(FoodProperty.getDisplayPrefix(stack, foodProperty)).method_10852(foodProperty.getTooltip()));
            }
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof RoleCardItem roleCardItem)) {
                return;
            }
            Optional<RoleCard> roleCardComponent = roleCardItem.getRoleCardComponent(stack);
            if (roleCardComponent.isEmpty()) {
                textConsumer.accept(class_2561.method_43471("item.disabled"));
                return;
            }
            if (roleCardComponent.get().isEmpty()) {
                textConsumer.accept(class_2561.method_43471("item.disabled"));
                return;
            }
            textConsumer.accept(class_2561.method_43471("item.tooltip.use"));
        });
        event.register((stack, context, displayComponent, player, textConsumer, type) -> {
            if (!(stack.method_7909() instanceof SpellCardTemplateItem spellCardTemplateItem)) {
                return;
            }
            Float damage = stack.method_58695(ModDataComponentTypes.Danmaku.DAMAGE, null);
            Float scale = stack.method_58695(ModDataComponentTypes.Danmaku.SCALE, null);
            Float speed = stack.method_58695(ModDataComponentTypes.Danmaku.SPEED, null);
            Integer count = stack.method_58695(ModDataComponentTypes.Danmaku.COUNT, AbstractDanmakuItem.DEFAULT_COUNT);
            String templateType = stack.method_58695(ModDataComponentTypes.Danmaku.TEMPLATE, Touhou.id("single").toString());

            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.base_type")).method_10852(class_2561.method_43471(class_2960.method_60654(templateType).method_42094())));

        });
    }
}
