package cc.thonly.reverie_dreams.creative_tab.content;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.block.BlockTypeGroup;
import cc.thonly.reverie_dreams.block.DecorativeBlockCreator;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.block.WoodCreator;
import cc.thonly.reverie_dreams.block.base.FruitLeavesBlock;
import cc.thonly.reverie_dreams.effect.ModPotions;
import cc.thonly.reverie_dreams.item.ModItems;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ItemBlockCreativeTab implements ItemGroupContentHelper {
    public static final class_5321<class_1761> ITEM_GROUP_KEY = class_5321.method_29179(class_7924.field_44688, Touhou.id("item_group"));
    public static final class_1761 ITEM_GROUP = ItemGroupContentHelper.builder()
            .method_47320(() -> new class_1799(ModItems.HAKUREI_CANE))
            .method_47321(class_2561.method_43471("item_group.touhou_block_and_item"))
            .method_47324();

    public static void bootstrap() {
        ItemGroupEvents.modifyEntriesEvent(ItemBlockCreativeTab.ITEM_GROUP_KEY).register(itemGroup -> {
            itemGroup.method_45423(ModItems.getItemView().stream().map(class_1792::method_7854).toList());
            for (class_1935 item : ModItems.getItemView()) {
                itemGroup.method_45421(item);
            }
            itemGroup.method_45421(ModItems.ROLE_CARD);
            itemGroup.method_45420(ModPotions.createStack(ModPotions.ELIXIR_OF_LIFE_POTION));
            itemGroup.method_45420(ModPotions.createStack(ModPotions.ELIXIR_OF_LIFE_POTION_INF));
            itemGroup.method_45420(ModPotions.createStack(ModPotions.MENTAL_DISORDER_POTION));
            itemGroup.method_45420(ModPotions.createStack(ModPotions.BACK_OF_LIFE_POTION));
            itemGroup.method_45420(ModPotions.createStack(ModPotions.KANJU_KUSURI_POTION));
            for (class_1935 item : ModBlocks.BLOCKS) {
                itemGroup.method_45421(item);
            }
            for (WoodCreator instance : WoodCreator.INSTANCES) {
                instance.stream().forEach(block -> itemGroup.method_45421(block.method_8389()));
            }
            for (class_2248 block : BlockTypeGroup.FRUIT_LEAVES.blocks()) {
                if (block instanceof FruitLeavesBlock fruitLeavesBlock) {
                    itemGroup.addAfter(fruitLeavesBlock.getEmptyLeavesBlock(), block);
                }
            }
            for (DecorativeBlockCreator instance : DecorativeBlockCreator.INSTANCES) {
                instance.stream().forEach(block -> itemGroup.method_45421(block.method_8389()));
            }
            FruitLeavesBlock.FRUIT_LEAVES_BLOCKS.forEach(itemGroup::method_45421);
        });
        ItemGroupContentHelper.registerGroup(ItemBlockCreativeTab.ITEM_GROUP_KEY, ItemBlockCreativeTab.ITEM_GROUP);
    }
}
