package cc.thonly.reverie_dreams.damage;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.registry.BuiltinObject;
import cc.thonly.reverie_dreams.registry.CodecStep;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.OwnerBinding;
import com.mojang.serialization.Codec;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1282;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import net.minecraft.class_8109;
import net.minecraft.class_8110;
import net.minecraft.class_8111;

@Setter
@Getter
public class DanmakuDamageType implements CodecStep<DanmakuDamageType>, OwnerBinding<DanmakuDamageType>, BuiltinObject {
    public static final Codec<DanmakuDamageType> CODEC = class_5321.method_39154(class_7924.field_42534)
            .xmap(DanmakuDamageType::new, DanmakuDamageType::getRegistryKey);
    public static final class_2960 DEFAULT_ID = Touhou.id("generic");
    private class_2960 id;
    private final class_5321<class_8110> registryKey;
    private IntrinsicalRegister<DanmakuDamageType> owner;

    public DanmakuDamageType(class_5321<class_8110> registryKey) {
        this.registryKey = registryKey;
    }

    public class_1282 mapToSource(class_8109 sources) {
        if (this.registryKey == null) {
            return null;
        }
        if (this.registryKey == class_8111.field_42348) {
            return sources.method_48830();
        }
        if (this.registryKey == class_8111.field_42349) {
            return sources.method_48831();
        }
        return sources.method_48830();
    }

    public class_5321<class_8110> getType() {
        return this.registryKey;
    }

    public class_8110 getValue(class_5455 registryManager) {
        if (this.registryKey == null) return null;
        class_2378<class_8110> registry = registryManager.method_30530(class_7924.field_42534);
        return registry.method_29107(this.registryKey);
    }

    @Override
    public Codec<DanmakuDamageType> getCodec() {
        return CODEC;
    }

    @FunctionalInterface
    public interface SourceGetter {
        class_1282 getSource();
    }
}
