package cc.thonly.reverie_dreams.danmaku;

import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.base.IDanmakuItem;
import cc.thonly.reverie_dreams.registry.BuiltinObject;
import cc.thonly.reverie_dreams.registry.CodecStep;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.OwnerBinding;
import com.mojang.serialization.Codec;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Setter
@Getter
@NoArgsConstructor
public class DanmakuTrajectory implements CodecStep<DanmakuTrajectory>, OwnerBinding<DanmakuTrajectory>, BuiltinObject {
    public static final Codec<DanmakuTrajectory> CODEC = Codec.unit(DanmakuTrajectory::new);
    private IntrinsicalRegister<DanmakuTrajectory> owner;

    public void run(class_3218 world, @Nullable class_1309 livingEntity, class_1799 stack, Double x, Double y, Double z, float pitch, float yaw, float speed, float acceleration, float divergence, float offsetDist, IDanmakuItem pThis) {

    }

    public static DanmakuEntity spawnByItemStack(class_3218 world, @NotNull class_1309 livingEntity, class_1799 stack, Float speed, Float acceleration, Float divergence, Float offsetDist) {
        stack = stack.method_7972();
        double x = livingEntity.method_23317();
        double y = livingEntity.method_23318();
        double z = livingEntity.method_23321();
        if (offsetDist == null) {
            offsetDist = 1.5f;
        }
        DanmakuEntity danmakuEntity = new DanmakuEntity(
                livingEntity,
                world,
                x, y, z,
                stack,
                livingEntity.method_36455(),
                livingEntity.method_36454(),
                speed,
                acceleration,
                divergence,
                offsetDist
        );
        world.method_8649(danmakuEntity);
        return danmakuEntity;
    }

    public static DanmakuEntity spawnByItemStack(class_3218 world, @Nullable class_1309 livingEntity, Double x, Double y, Double z, class_1799 stack, Float pitch, Float yaw, Float speed, Float acceleration, Float divergence, Float offsetDist) {
        stack = stack.method_7972();
        if (offsetDist == null) {
            offsetDist = 1.5f;
        }
        DanmakuEntity danmakuEntity = new DanmakuEntity(
                livingEntity,
                world,
                x, y, z,
                stack,
                pitch,
                yaw,
                speed,
                acceleration,
                divergence,
                offsetDist
        );
        world.method_8649(danmakuEntity);
        return danmakuEntity;
    }

    @Override
    public Codec<DanmakuTrajectory> getCodec() {
        return CODEC;
    }
}
