package cc.thonly.reverie_dreams.danmaku;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.data.ModTags;
import cc.thonly.reverie_dreams.datagen.generator.RecipeTypeProvider;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.danmaku.DanmakuItem;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import cc.thonly.reverie_dreams.registry.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_10130;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import java.util.*;

@Setter
@Getter
public class DanmakuType implements CodecStep<DanmakuType>, OwnerBinding<DanmakuType>, Translatable, BuiltinObject {
    public static final Codec<DanmakuType> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    class_2960.field_25139.fieldOf("registry_key").forGetter(DanmakuType::getId),
                    Codec.FLOAT.fieldOf("damage").forGetter(DanmakuType::getDamage),
                    Codec.FLOAT.fieldOf("scale").forGetter(DanmakuType::getScale),
                    Codec.FLOAT.fieldOf("speed").forGetter(DanmakuType::getSpeed),
                    Codec.BOOL.fieldOf("tile").forGetter(DanmakuType::isTile),
                    Codec.BOOL.fieldOf("infinite").forGetter(DanmakuType::isInfinite)
            ).apply(instance, DanmakuType::new)
    );

    private class_2960 id;
    private final float damage;
    private final float scale;
    private final float speed;
    private final boolean tile;
    private final boolean infinite;
    private class_1792 item;
    private DanmakuEntity.OnHitFactory hitFactory;
    private IntrinsicalRegister<DanmakuType> owner;

    public DanmakuType(class_2960 id, float damage, float scale, float speed, boolean tile, boolean infinite) {
        this.id = id;
        this.damage = damage;
        this.scale = scale;
        this.speed = speed;
        this.tile = tile;
        this.infinite = infinite;
        this.buildItem();
    }

    @Override
    public String translateKey() {
        return this.item.method_7876();
    }

    public DanmakuShape toShape() {
        for (Map.Entry<class_2960, DanmakuShape> mapEntry : RegistryManager.DANMAKU_SHAPE.entrySet()) {
            DanmakuShape shape = mapEntry.getValue();
            if (shape.getType() == this) {
                return shape;
            }
        }
        return new DanmakuShape(this);
    }

    public void buildShapeRecipe(RecipeTypeProvider.Factory<DanmakuShapeDrawRecipe> factory, List<List<Boolean>> shape) {
        factory.register(this.id, new DanmakuShapeDrawRecipe(shape, ItemStackWrapper.of(this.toShape().getItemStack().method_7972())));
    }

    public void buildShapeRecipe(RecipeTypeProvider.Factory<DanmakuShapeDrawRecipe> factory, String[] shape) {
        List<List<Boolean>> list = new ArrayList<>();

        for (String line : shape) {
            ArrayList<Boolean> row = new ArrayList<>();
            for (int i = 0; i < line.length(); i++) {
                char c = line.charAt(i);
                if (c == 'T') {
                    row.add(true);
                } else if (c == 'F') {
                    row.add(false);
                } else {
                    throw new IllegalArgumentException("Invalid character in shape string: " + c);
                }
            }
            list.add(row);
        }

        this.buildShapeRecipe(factory, list);
    }

    public void buildItem() {
        DanmakuItem item = new DanmakuItem(this.createItemSettings()
                .method_57349(class_9334.field_49644, new class_9282(14606046))
                .method_7895(120)
        );
        item.type(this);
        this.item = item;
        class_2378.method_10230(class_7923.field_41178, this.getIdentifier(), this.item);
    }

    public List<class_3545<class_1792, class_1799>> getColorPairs() {
        List<class_3545<class_1792, class_1799>> pairList = new LinkedList<>();
        class_1799 defaultStack = this.item.method_7854();
        for (Map.Entry<class_1792, Long> itemLongEntry : ItemColor.getView().entrySet()) {
            class_1792 dyeItem = itemLongEntry.getKey();
            class_1799 stack = defaultStack.method_7972();
            stack.method_57379(class_9334.field_49644, new class_9282(itemLongEntry.getValue().intValue()));
            stack.method_57379(class_9334.field_53966, new class_10130(0.5f, Optional.of(class_2960.method_60654(UUID.randomUUID().toString()))));
            pairList.add(new class_3545<>(dyeItem, stack));
        }
        return pairList;
    }

    public class_2960 getIdentifier() {
        return class_2960.method_60655(this.id.method_12836(), "danmaku/" + this.id.method_12832());
    }

    public class_1792.class_1793 createItemSettings() {
        return new class_1792.class_1793()
                .method_63686(class_5321.method_29179(class_7924.field_41197, this.getIdentifier()))
                .method_57349(ModDataComponentTypes.Danmaku.TEMPLATE, Touhou.id("single").toString())
                .method_57349(ModDataComponentTypes.Danmaku.DAMAGE, this.damage)
                .method_57349(ModDataComponentTypes.Danmaku.SPEED, this.speed)
                .method_57349(ModDataComponentTypes.Danmaku.SCALE, this.scale)
                .method_57349(ModDataComponentTypes.Danmaku.COUNT, 1)
                .method_57349(ModDataComponentTypes.Danmaku.TILE, this.tile)
                .method_57349(ModDataComponentTypes.Danmaku.INFINITE, this.infinite)
                .method_57349(ModDataComponentTypes.Danmaku.DAMAGE_TYPE, Touhou.id("generic").toString())
                .method_57349(class_9334.field_53966, new class_10130(0.5f, Optional.of(class_2960.method_60654(UUID.randomUUID().toString()))))
                .method_7895(120)
                .method_61647(ModTags.ItemTypeTag.POWER_BLOCK);
    }

    @Override
    public Codec<DanmakuType> getCodec() {
        return CODEC;
    }
}
