package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.danmaku.SpellCardTemplates;
import cc.thonly.reverie_dreams.entity.GoblinEntity;
import cc.thonly.reverie_dreams.entity.HairballEntity;
import cc.thonly.reverie_dreams.entity.Yousei;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.item.base.AlbumItem;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_141;
import net.minecraft.class_1588;
import net.minecraft.class_1627;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_219;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_5819;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9320;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ModLootModifies {
    public static final class_5321<class_52> VILLAGE_WEAPONSMITH_CHEST = class_39.field_434;
    public static final class_5321<class_52> END_CITY_TREASURE_CHEST = class_39.field_274;
    public static final class_5321<class_52> OPEN_MINESHAFT_CHEST = class_39.field_472;
    public static final class_5321<class_52> NETHER_BRIDGE_CHEST = class_39.field_615;
    public static final class_5321<class_52> VILLAGE_PLAINS_CHEST = class_39.field_16748;
    public static final class_5321<class_52> VILLAGE_SAVANNA_HOUSE_CHEST = class_39.field_16753;
    public static final class_5321<class_52> PILLAGER_OUTPOST_CHEST = class_39.field_16593;
    public static final class_5321<class_52> SIMPLE_DUNGEON_CHEST = class_39.field_16593;
    public static final class_5321<class_52> SHIPWRECK_TREASURE_CHEST = class_39.field_665;
    public static final class_5321<class_52> SHIPWRECK_SUPPLY_CHEST = class_39.field_880;
    public static final class_5321<class_52> DESERT_PYRAMID_CHEST = class_39.field_885;
    public static final List<class_5321<class_52>> COMMON_CHESTS = new ArrayList<>(
            List.of(
                    VILLAGE_WEAPONSMITH_CHEST,
                    END_CITY_TREASURE_CHEST,
                    OPEN_MINESHAFT_CHEST,
                    NETHER_BRIDGE_CHEST,
                    VILLAGE_PLAINS_CHEST,
                    VILLAGE_SAVANNA_HOUSE_CHEST,
                    PILLAGER_OUTPOST_CHEST,
                    SIMPLE_DUNGEON_CHEST,
                    SHIPWRECK_SUPPLY_CHEST,
                    SHIPWRECK_TREASURE_CHEST,
                    DESERT_PYRAMID_CHEST
            )
    );

    public static void register() {
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            Optional<class_5321<class_52>> lootTableKey = class_2246.field_10295.method_26162();
            if (lootTableKey.isPresent() && lootTableKey.get().equals(key)) {
                class_55.class_56 poolBuilder = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.1f));

                poolBuilder.method_351(class_77.method_411(ModBlocks.MAGIC_ICE_BLOCK).method_437(10));
                tableBuilder.method_336(poolBuilder);
            }
        });
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            if (
                    COMMON_CHESTS.contains(key)
            ) {
                // disc pool
                class_55.class_56 discPool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.4f));
                for (var item : AlbumItem.ITEMS) {
                    discPool.method_351(class_77.method_411(item).method_437(8));
                }
                tableBuilder.method_336(discPool);

                class_55.class_56 fragmentPool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.3f));
                fragmentPool.method_351(
                        class_77.method_411(ModItems.UPGRADED_HEALTH_FRAGMENT)
                                .method_437(10)
                                .method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f)))
                );
                fragmentPool.method_351(
                        class_77.method_411(ModItems.BOMB_FRAGMENT)
                                .method_437(10)
                                .method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f)))
                );
                tableBuilder.method_336(fragmentPool);

                class_55.class_56 rarePool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.2f));
                rarePool.method_351(class_77.method_411(ModItems.UPGRADED_HEALTH).method_437(10));
                rarePool.method_351(class_77.method_411(ModItems.BOMB).method_437(10));
                tableBuilder.method_336(rarePool);
            }
        });
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            if (key.equals(OPEN_MINESHAFT_CHEST) || key.equals(VILLAGE_WEAPONSMITH_CHEST) || key.equals(END_CITY_TREASURE_CHEST)) {
                class_55.class_56 poolBuilder = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.4f));
                for (var entry : SpellCardTemplates.getRegistryItemStackView().entrySet()) {
                    class_1799 itemStack = entry.getValue();
                    String templateId = itemStack.method_58694(ModDataComponentTypes.Danmaku.TEMPLATE);
                    if (templateId == null) continue;

                    poolBuilder.method_351(class_77.method_411(itemStack.method_7909())
                            .method_438(class_9320.method_57650(ModDataComponentTypes.Danmaku.TEMPLATE, templateId))
                            .method_437(6));
                }
                tableBuilder.method_336(poolBuilder);
            }
        });

        ServerLivingEntityEvents.AFTER_DEATH.register(ModLootModifies::modifyDrops);
    }

    private static void modifyDrops(class_1309 entity, class_1282 damageSource) {
        dropPointPower(entity, damageSource);
        dropIceScales(entity, damageSource);
        dropCoins(entity, damageSource);
    }

    private static void dropCoins(class_1309 entity, class_1282 damageSource) {
        class_2960 entityId = class_7923.field_41177.method_10221(entity.method_5864());
        class_1937 world = entity.method_37908();
        if (!(world instanceof class_3218 serverWorld)) {
            return;
        }
        if (entity instanceof Yousei || entity instanceof GoblinEntity) {
            class_5819 random = class_5819.method_43047();
            List<class_1792> itemPool = List.of(
                    ModItems.COPPER_COIN,
                    ModItems.SILVER_COIN,
                    ModItems.SILVER_COIN,
                    ModItems.GOLD_COIN,
                    ModItems.COPPER_COIN,
                    ModItems.COPPER_COIN,
                    ModItems.COPPER_COIN
            );
            int dropChance = 45;
            int maxDropCount = 3;
            if (random.method_43048(100) < dropChance) {
                entity.method_5775(serverWorld, new class_1799(itemPool.get(random.method_39332(0, itemPool.size() - 1)), random.method_43048(maxDropCount + 1) + 1));
            }
        }
    }

    private static void dropPointPower(class_1309 entity, class_1282 damageSource) {
        class_2960 entityId = class_7923.field_41177.method_10221(entity.method_5864());
        class_1937 world = entity.method_37908();
        if ((entity instanceof HairballEntity || entity instanceof class_1588 || entity instanceof Yousei) && world instanceof class_3218 serverWorld) {
            class_5819 random = class_5819.method_43047();
            int dropChance = 45;
            int maxDropCount = 3;

            if (random.method_43048(100) < dropChance) {
                entity.method_5775(serverWorld, new class_1799(ModItems.POWER, random.method_43048(maxDropCount + 1) + 1));
                entity.method_5775(serverWorld, new class_1799(ModItems.POINT, random.method_43048(maxDropCount + 1) + 1));
            }
        }

    }

    private static void dropIceScales(class_1309 entity, class_1282 damageSource) {
        class_1937 world = entity.method_37908();
        if (world instanceof class_3218 serverWorld && entity instanceof class_1627) {
            class_5819 random = class_5819.method_43047();
            int dropChance = 45;
            int maxDropCount = 3;
            if (random.method_43048(100) < dropChance) {
                entity.method_5775(serverWorld, new class_1799(ModItems.ICE_SCALES, random.method_43048(maxDropCount + 1) + 1));
            }
        }
    }

    private static class_5321<class_52> vanillaKey(String path) {
        return class_5321.method_29179(class_7924.field_50079, class_2960.method_60656(path));
    }

    private static class_5321<class_52> key(String path) {
        return class_5321.method_29179(class_7924.field_50079, Touhou.id(path));
    }

}
