package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.api.RegistryManagerReloadCallback;
import cc.thonly.reverie_dreams.dialog.DialogInit;
import cc.thonly.reverie_dreams.server.CookingInputRecipeManager;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import cc.thonly.reverie_dreams.server.ItemTagManager;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ModServerReloadListener implements SimpleSynchronousResourceReloadListener {
    @Override
    public class_2960 getFabricId() {
        return Touhou.id("data");
    }

    @Override
    public void method_14491(class_3300 manager) {
        RecipeManager.onReload(manager);
        for (var entry : RegistryManager.ROOT.entrySet()) {
            IntrinsicalRegister<?> registry = entry.getValue();
            if (registry.isReloadable()) {
                registry.reload(manager);
                RegistryManagerReloadCallback.EVENT.invoker().onLoad(registry);
            }
            registry.validate();
        }
        this.onLoad(manager);
        CookingInputRecipeManager.getInstance().clearItems();
        ItemTagManager.getInstance().clearTags();
        DialogInit.initRegistriesDialog();
    }

    public void onLoad(class_3300 manager) {

    }
}
