package cc.thonly.reverie_dreams.datagen;

import cc.thonly.mystias_izakaya.block.MIBlocks;
import cc.thonly.mystias_izakaya.block.kitchenware.AbstractKitchenwareBlock;
import cc.thonly.reverie_dreams.block.CropBlockCreator;
import cc.thonly.reverie_dreams.block.DecorativeBlockCreator;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.block.WoodCreator;
import cc.thonly.reverie_dreams.fumo.Fumo;
import cc.thonly.reverie_dreams.fumo.Fumos;
import cc.thonly.reverie_dreams.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_1792;
import net.minecraft.class_219;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2397;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ModBlockLootTableProvider extends FabricBlockLootTableProvider {
    private final Function<WoodCreator, Void> woodCreatorLootFunction = (creator) -> {
        creator.stream().forEach((block -> {
            if (block instanceof class_2323) {
                class_52.class_53 builder = this.method_46022(block);
                this.method_45988(block, builder);
                return;
            }
            if (block instanceof class_2397) {
                this.method_45986(block, creator.sapling(), 0.2f);
                return;
            }
            if (block instanceof class_2482) {
                class_52.class_53 builder = this.method_45980(block);
                this.method_45988(block, builder);
                return;
            }
            this.method_46025(block);
        }));
        return null;
    };
    private final Function<DecorativeBlockCreator, Void> decorativeBlockCreatorLootFunction = (creator) -> {
        creator.stream().forEach((block -> {
            if (block instanceof class_2482) {
                class_52.class_53 builder = this.method_45980(block);
                this.method_45988(block, builder);
                return;
            }
            this.method_46025(block);
        }));
        return null;
    };

    public ModBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public void method_10379() {
        method_46025(ModBlocks.DANMAKU_CRAFTING_TABLE);
        method_46025(ModBlocks.STRENGTH_TABLE);
        method_46025(ModBlocks.GENSOKYO_ALTAR);
        method_46025(ModBlocks.MUSIC_BLOCK);

        this.woodCreatorLootFunction.apply(ModBlocks.SPIRITUAL);

        method_46025(ModBlocks.MAGIC_ICE_BLOCK);
        method_46025(ModBlocks.MARISA_HAT_BLOCK);
        method_46025(ModBlocks.ANTI_COLLISION_BARREL);
        method_46025(ModBlocks.CASH_BOX_BLOCK);
        method_46025(ModBlocks.WHEEL_CHAIR);

        method_46025(ModBlocks.POINT_BLOCK);
        method_46025(ModBlocks.POWER_BLOCK);
        method_45994(ModBlocks.SILVER_ORE, (class_2248 block) -> this.method_45981(block, ModItems.RAW_SILVER));
        method_45994(ModBlocks.DEEPSLATE_SILVER_ORE, (class_2248 block) -> this.method_45981(block, ModItems.RAW_SILVER));
        Function<class_2248, class_52.class_53> orbDropFunction = (class_2248 block) -> {
            class_52.class_53 builder = new class_52.class_53();

            List<class_1792> itemList = List.of(
                    ModItems.RED_ORB,
                    ModItems.BLUE_ORB,
                    ModItems.YELLOW_ORB,
                    ModItems.GREEN_ORB,
                    ModItems.PURPLE_ORB
            );

            for (class_1792 item : itemList) {
                class_55.class_56 pool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.25f))
                        .method_351(class_77.method_411(item));
                builder.method_336(pool);
            }

            class_55.class_56 fallbackPool = class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(ModItems.RED_ORB).method_437(1))
                    .method_351(class_77.method_411(ModItems.BLUE_ORB).method_437(1))
                    .method_351(class_77.method_411(ModItems.YELLOW_ORB).method_437(1))
                    .method_351(class_77.method_411(ModItems.GREEN_ORB).method_437(1))
                    .method_351(class_77.method_411(ModItems.PURPLE_ORB).method_437(1));
            builder.method_336(fallbackPool);

            return builder;
        };
        method_45994(ModBlocks.ORB_ORE, orbDropFunction);
        method_45994(ModBlocks.DEEPSLATE_ORB_ORE, orbDropFunction);
        method_46025(ModBlocks.SILVER_BLOCK);
        method_46025(ModBlocks.SILVER_CHEST_BLOCK.chestBlock());
        Function<class_2248, class_52.class_53> dreamCrystlDropFunction = (class_2248 block) -> {
            class_52.class_53 builder = new class_52.class_53();

            List<class_1792> itemList = List.of(
                    ModItems.DREAM_CRYSTAL_FRAGMENT,
                    ModItems.DREAM_CRYSTAL_FRAGMENT
            );

            for (class_1792 item : itemList) {
                class_55.class_56 pool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.25f))
                        .method_351(class_77.method_411(item));
                builder.method_336(pool);
            }

            class_55.class_56 fallbackPool = class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(ModItems.DREAM_CRYSTAL_FRAGMENT).method_437(1))
                    ;
            builder.method_336(fallbackPool);

            return builder;
        };
        method_45994(ModBlocks.DREAM_CRYSTAL_ORE, dreamCrystlDropFunction);

        this.decorativeBlockCreatorLootFunction.apply(ModBlocks.ICE_SCALES);
        this.decorativeBlockCreatorLootFunction.apply(ModBlocks.DREAM_STONE);
        this.decorativeBlockCreatorLootFunction.apply(ModBlocks.DREAM_STONE_BRICK);
        this.decorativeBlockCreatorLootFunction.apply(ModBlocks.MOON_STONE);
        this.decorativeBlockCreatorLootFunction.apply(ModBlocks.MOON_STONE_BRICK);

        for (Fumo fumo : Fumos.getView()) {
            method_46025(fumo.block());
        }

        this.generateMI();
    }

    public void generateMI() {
        for (class_2248 block : AbstractKitchenwareBlock.KITCHENWARE_BLOCKS) {
            method_46025(block);
        }
        method_46025(MIBlocks.ITEM_DISPLAY);

        for (Map.Entry<class_2960, CropBlockCreator.Instance> view : CropBlockCreator.getViews()) {
            CropBlockCreator.Instance instance = view.getValue();
            instance.generateLoot(this);
        }

        this.woodCreatorLootFunction.apply(MIBlocks.LEMON);
        method_46006(MIBlocks.LEMON_FRUIT_LEAVES, MIBlocks.LEMON.sapling());

        this.woodCreatorLootFunction.apply(MIBlocks.GINKGO);
        method_46006(MIBlocks.GINKGO_FRUIT_LEAVES, MIBlocks.GINKGO.sapling());

        this.woodCreatorLootFunction.apply(MIBlocks.PEACH);
        method_46006(MIBlocks.PEACH_FRUIT_LEAVES, MIBlocks.PEACH.sapling());

//        addDrop(MIBlocks.COOKTOP);
        method_46025(MIBlocks.BLACK_SALT_BLOCK);
        method_46025(MIBlocks.UDUMBARA_FLOWER);
        method_46025(MIBlocks.TREMELLA);
    }
}
