package cc.thonly.reverie_dreams.datagen;

import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.reverie_dreams.block.BlockTypeGroup;
import cc.thonly.reverie_dreams.block.CropBlockCreator;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.block.WoodCreator;
import cc.thonly.reverie_dreams.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.data.ModTags;
import cc.thonly.reverie_dreams.fumo.Fumo;
import cc.thonly.reverie_dreams.fumo.Fumos;
import cc.thonly.reverie_dreams.item.ItemTypeGroup;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.item.base.AlbumItem;
import cc.thonly.reverie_dreams.item.base.ArmorItem;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_11389;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class ModItemTagProvider extends FabricTagProvider.ItemTagProvider {

    public ModItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        // === 基础工具方法 ===
        BiConsumer<class_6862<class_1792>, Collection<? extends class_1792>> addAll = (tag, items) -> valueLookupBuilder(tag).method_71558(items.toArray(class_1792[]::new));
        Supplier<List<class_1792>> allDanmakuItemGetter = () -> {
            IntrinsicalRegister<DanmakuType> registry = RegistryManager.DANMAKU_TYPE;
            Stream<class_1792> itemStream = registry.values().stream().map(DanmakuType::getItem);
            return itemStream.toList();
        };
        Supplier<List<class_1792>> allToolGetter = () -> {
            List<class_1792> list = new ArrayList<>();
            list.add(ModItems.NUE_TRIDENT);
            list.addAll(allDanmakuItemGetter.get());
            return list;
        };
        List<class_1792> allTool = allToolGetter.get();

        // === 通用 Tag ===
        valueLookupBuilder(ModTags.ItemTypeTag.EMPTY).method_71554(class_1802.field_8542).method_71554(class_1802.field_8077);
        addAll.accept(ModTags.ItemTypeTag.FUMO, Fumos.getView().stream().map(Fumo::item).toList());
        addAll.accept(class_3489.field_23969, AlbumItem.ITEMS);

        // === 工具类 Tag ===
        addAll.accept(class_3489.field_42611, ItemTypeGroup.SWORD.items());
        addAll.accept(class_3489.field_42614, ItemTypeGroup.PICKAXES.items());
        addAll.accept(class_3489.field_42612, ItemTypeGroup.AXES.items());
        addAll.accept(class_3489.field_42615, ItemTypeGroup.SHOVELS.items());
        addAll.accept(class_3489.field_42613, ItemTypeGroup.HOES.items());
        addAll.accept(class_3489.field_48309, allTool);
        addAll.accept(class_3489.field_48310, allTool);
        addAll.accept(class_3489.field_48310, List.of(ModItems.TENGU_SHIELD));
        addAll.accept(ConventionalItemTags.SHIELD_TOOLS, List.of(ModItems.TENGU_SHIELD));

        // === 盔甲类 Tag ===
        addAll.accept(class_3489.field_48297, ArmorItem.HEAD_ITEMS);
        addAll.accept(class_3489.field_48296, ArmorItem.CHEST_ITEMS);
        addAll.accept(class_3489.field_48295, ArmorItem.LEG_ITEMS);
        addAll.accept(class_3489.field_48294, ArmorItem.FEET_ITEMS);
        addAll.accept(ModTags.ItemTypeTag.ARMOR, ArmorItem.ITEMS);

        // === 工具材料 ===
        valueLookupBuilder(ModTags.ItemTypeTag.SILVER_ARMOR).method_71558(ModItems.SILVER_HELMET, ModItems.SILVER_CHESTPLATE, ModItems.SILVER_LEGGINGS, ModItems.SILVER_BOOTS);
        valueLookupBuilder(ModTags.ItemTypeTag.SILVER_TOOL_MATERIALS).method_71554(ModItems.SILVER_INGOT);
        valueLookupBuilder(ModTags.ItemTypeTag.MAGIC_ICE_ARMOR).method_71558(ModItems.MAGIC_ICE_HELMET, ModItems.MAGIC_ICE_CHESTPLATE, ModItems.MAGIC_ICE_LEGGINGS, ModItems.MAGIC_ICE_BOOTS);
        valueLookupBuilder(ModTags.ItemTypeTag.MAGIC_ICE_TOOL_MATERIALS).method_71554(ModItems.ICE_SCALES);
        valueLookupBuilder(ModTags.ItemTypeTag.MAID_ARMOR).method_71558(ModItems.MAID_HAIRBAND, ModItems.MAID_UPPER_SKIRT, ModItems.MAID_LOWER_SKIRT, ModItems.MAID_SHOE);
        valueLookupBuilder(ModTags.ItemTypeTag.DREAM_ARMOR).method_71554(ModItems.DREAM_HELMET).method_71554(ModItems.DREAM_CHESTPLATE).method_71554(ModItems.DREAM_LEGGINGS).method_71554(ModItems.DREAM_BOOTS);
        valueLookupBuilder(ModTags.ItemTypeTag.DREAM_TOOL_MATERIALS).method_71554(ModItems.DREAM_CRYSTAL_FRAGMENT);

        // === 自定义方块 ===
        valueLookupBuilder(class_3489.field_15537).method_71557(WoodCreator.INSTANCES.stream().map(ins->ins.planks().method_8389()));
        valueLookupBuilder(ModTags.ItemTypeTag.ORB_BLOCK).method_71558(
                ModBlocks.RED_ORB_BLOCK.method_8389(),
                ModBlocks.YELLOW_ORB_BLOCK.method_8389(),
                ModBlocks.BLUE_ORB_BLOCK.method_8389(),
                ModBlocks.GREEN_ORB_BLOCK.method_8389(),
                ModBlocks.PURPLE_ORB_BLOCK.method_8389()
        );
        valueLookupBuilder(ModTags.ItemTypeTag.POWER_BLOCK).method_71554(ModBlocks.POWER_BLOCK.method_8389());
        valueLookupBuilder(ModTags.ItemTypeTag.POINT_BLOCK).method_71554(ModBlocks.POINT_BLOCK.method_8389());
        valueLookupBuilder(ModTags.ItemTypeTag.SILVER_BLOCK).method_71554(ModBlocks.SILVER_BLOCK.method_8389());
        valueLookupBuilder(ModTags.ItemTypeTag.VAISRAVANAS_PAGODA).method_71554(class_1802.field_8183);
        valueLookupBuilder(ModTags.ItemTypeTag.INGREDIENT_ITEM).method_71555(MIItems.INGREDIENTS);
        valueLookupBuilder(ModTags.ItemTypeTag.FOOD_ITEM).method_71555(MIItems.FOOD_ITEMS);
        valueLookupBuilder(ModTags.ItemTypeTag.DRINK_ITEM).method_71555(MIItems.DRINK_ITEMS);

        valueLookupBuilder(ModTags.ItemTypeTag.ROLE_TAME_FOOD)
                .method_71554(class_1802.field_17534)
                .method_71554(MIItems.ORDINARY_SMALL_CAKE)
                .method_71554(MIItems.SCARLET_DEVILS_CAKE);

        // === 兼容物品 ===
        valueLookupBuilder(ConventionalItemTags.FOODS).method_71555(MIItems.FOOD_ITEMS);
        valueLookupBuilder(ModTags.ItemTypeTag.PEACH).method_71554(MIItems.PEACH);

        // === 方块物品分类 ===
        Map<class_6862<class_1792>, Collection<? extends class_1935>> blockItemGroups = Map.of(
                class_3489.field_16585, BlockTypeGroup.FENCE.items(),
                class_3489.field_40858, BlockTypeGroup.FENCE_GATE.items(),
                class_3489.field_15560, BlockTypeGroup.WALL.items(),
                class_3489.field_15526, BlockTypeGroup.STAIR.items(),
                class_3489.field_15535, BlockTypeGroup.SLAB.items(),
                class_3489.field_15551, BlockTypeGroup.BUTTON.items(),
                class_3489.field_15548, BlockTypeGroup.TRAPDOOR.items(),
                class_3489.field_15553, BlockTypeGroup.DOOR.items(),
                class_3489.field_15558, BlockTypeGroup.LEAVES.items()
        );
        blockItemGroups.forEach((tag, list) -> {
            class_11389<class_1792, class_1792> builder = valueLookupBuilder(tag);
            list.forEach(item -> builder.method_71554(item.method_8389()));
        });

        // === 种子 ===
        class_11389<class_1792, class_1792> seeds = valueLookupBuilder(ConventionalItemTags.SEEDS);
        class_11389<class_1792, class_1792> villagerPlantableSeeds = valueLookupBuilder(class_3489.field_44591);
        for (var entry : CropBlockCreator.getViews()) {
            class_1792 seed = entry.getValue().getSeed();
            villagerPlantableSeeds.method_71554(seed);
            seeds.method_71554(seed);
        }

        class_11389<class_1792, class_1792> pigFoods = valueLookupBuilder(class_3489.field_49950);
        pigFoods.method_71554(MIItems.WHITE_RADISH);

        class_11389<class_1792, class_1792> rabbitFoods = valueLookupBuilder(class_3489.field_49951);
        rabbitFoods.method_71554(MIItems.WHITE_RADISH);

        // === 模组兼容扩展 ===
        this.configureCompat(wrapperLookup);
    }


    protected void configureCompat(class_7225.class_7874 wrapperLookup) {
        // Farmer'delight
        class_11389<class_1792, class_1792> onion = valueLookupCommon("crops/onion");
        class_11389<class_1792, class_1792> tomatoCrop = valueLookupCommon("crops/tomato");
        class_11389<class_1792, class_1792> cabbage = valueLookupCommon("crops/cabbage");
        class_11389<class_1792, class_1792> rawSalmon = valueLookupCommon("foods/raw_salmon");
        class_11389<class_1792, class_1792> rawFish = valueLookupCommon("foods/raw_fish");
        class_11389<class_1792, class_1792> tomatoFood = valueLookupCommon("foods/tomato");

        onion.method_71554(MIItems.ONION);
        tomatoCrop.method_71554(MIItems.TOMATO);
        rawSalmon.method_71554(MIItems.SALMON);
        rawFish.method_71558(MIItems.SALMON, MIItems.HAGFISH, MIItems.TUNA, MIItems.SUPREME_TUNA);
        tomatoFood.method_71554(MIItems.TOMATO);

        class_11389<class_1792, class_1792> meals = valueLookupFarmerDelight("meals");
        meals.method_71558(
                MIItems.BLACK_PORK,
                MIItems.VENISON,
                MIItems.WAGYU_BEEF,
                MIItems.WILD_BOAR_MEAT
        );
    }

    private class_11389<class_1792, class_1792> valueLookupFarmerDelight(String name) {
        return valueLookupBuilder(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("farmersdelight", name)));
    }

    private class_11389<class_1792, class_1792> valueLookupCommon(String name) {
        return valueLookupBuilder(class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", name)));
    }

}
