package cc.thonly.reverie_dreams.datagen;

import cc.thonly.mystias_izakaya.block.MIBlocks;
import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.block.WoodCreator;
import cc.thonly.reverie_dreams.item.ModItems;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public class ModRecipeGenerator extends class_2446 {
    public static ImmutableList<class_1935> SILVER = ImmutableList.of(ModBlocks.SILVER_ORE.method_8389(), ModBlocks.DEEPSLATE_SILVER_ORE.method_8389(), ModItems.RAW_SILVER);
    public static ImmutableList<class_1935> DREAM = ImmutableList.of(ModBlocks.DREAM_CRYSTAL_ORE.method_8389());

    protected ModRecipeGenerator(class_7225.class_7874 registries, class_8790 exporter) {
        super(registries, exporter);
    }

    @Override
    public void method_10419() {
        // 入门书
        method_62746(class_7800.field_40642, ModItems.TOUHOU_HELPER)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', ModItems.POWER)
                .method_10434('#', class_1802.field_8529)
                .method_10429("has_diamond", method_10426(class_1802.field_8477))
                .method_36443(field_53721, method_36450(ModItems.TOUHOU_HELPER));

        // Point / 块
        offerIngotToBlockRecipe(field_53721, ModItems.POINT, ModBlocks.POINT_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.POINT_BLOCK.method_8389(), ModItems.POINT);

        // Power / 块
        offerIngotToBlockRecipe(field_53721, ModItems.POWER, ModBlocks.POWER_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.POWER_BLOCK.method_8389(), ModItems.POWER);

        // 速度羽毛
        method_62746(class_7800.field_40635, ModItems.SPEED_FEATHER)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8153)
                .method_10434('#', class_1802.field_8477)
                .method_10429("has_diamond", method_10426(class_1802.field_8477))
                .method_36443(field_53721, method_36450(ModItems.SPEED_FEATHER));

        // 梦境枕头
        method_62746(class_7800.field_40635, ModItems.DREAM_PILLOW)
                .method_10439("XXX")
                .method_10439("Y#Y")
                .method_10434('X', class_1802.field_19050)
                .method_10434('Y', class_1802.field_8695)
                .method_10434('#', class_1802.field_8687)
                .method_10429("has_emerald", method_10426(class_1802.field_8687))
                .method_36443(field_53721, method_36450(ModItems.DREAM_PILLOW));

        // Bomb
        offer1To4Recipe(field_53721, ModItems.UPGRADED_HEALTH_FRAGMENT, ModItems.UPGRADED_HEALTH);
        method_62747(class_7800.field_40642, ModItems.UPGRADED_HEALTH, 2)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', ModBlocks.POWER_BLOCK)
                .method_10434('#', ModItems.UPGRADED_HEALTH_FRAGMENT)
                .method_10429("has_health_fragment", method_10426(ModItems.UPGRADED_HEALTH_FRAGMENT))
                .method_36443(field_53721, method_36450(ModItems.UPGRADED_HEALTH_FRAGMENT) + "_copy");

        // 残机
        offer1To4Recipe(field_53721, ModItems.BOMB_FRAGMENT, ModItems.BOMB);
        method_62747(class_7800.field_40642, ModItems.BOMB_FRAGMENT, 2)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', ModBlocks.POINT_BLOCK)
                .method_10434('#', ModItems.BOMB_FRAGMENT)
                .method_10429("has_bomb_fragment", method_10426(ModItems.BOMB_FRAGMENT))
                .method_36443(field_53721, method_36450(ModItems.BOMB_FRAGMENT) + "_copy");

        // 弹幕创作模板
        method_62746(class_7800.field_40642, ModItems.DANMAKU_SHAPE_CREATOR)
                .method_10439("RRR")
                .method_10439("R#R")
                .method_10439("RRR")
                .method_10434('R', ModItems.POWER)
                .method_10434('#', class_1802.field_8674)
                .method_10429("has_power", method_10426(ModItems.POWER))
                .method_36443(field_53721, method_36450(ModItems.DANMAKU_SHAPE_CREATOR));

        // 空白角色卡
        method_62746(class_7800.field_40642, ModItems.ROLE_CARD)
                .method_10439(" R ")
                .method_10439("R#R")
                .method_10439(" R ")
                .method_10434('R', class_1802.field_8725)
                .method_10434('#', class_1802.field_8407)
                .method_10429("has_paper", method_10426(class_1802.field_8407))
                .method_36443(field_53721, method_36450(ModItems.ROLE_CARD));

        // 魔理沙的帽子
        method_62746(class_7800.field_40635, ModBlocks.MARISA_HAT_BLOCK)
                .method_10439(" X ")
                .method_10439("X#X")
                .method_10439("XYX")
                .method_10434('X', class_1802.field_19044)
                .method_10434('Y', class_1802.field_8745)
                .method_10434('#', class_1802.field_19059)
                .method_10429("has_diamond", method_10426(class_1802.field_8477))
                .method_36443(field_53721, method_36450(ModBlocks.MARISA_HAT_BLOCK));

        // 塞钱箱
        method_62746(class_7800.field_40642, ModBlocks.CASH_BOX_BLOCK)
                .method_10439("YYY")
                .method_10439("X#X")
                .method_10439("YYY")
                .method_10434('X', ModBlocks.SPIRITUAL.planks())
                .method_10434('Y', ModBlocks.SPIRITUAL.slab())
                .method_10434('#', class_1802.field_8106)
                .method_10429("has_wool", method_10426(class_1802.field_8106))
                .method_36443(field_53721, method_36450(ModBlocks.CASH_BOX_BLOCK));

        // 防撞桶
        method_62746(class_7800.field_40642, ModBlocks.ANTI_COLLISION_BARREL)
                .method_10439("YXY")
                .method_10439("Z#Z")
                .method_10439("YXY")
                .method_10434('X', class_1802.field_19048)
                .method_10434('Y', class_1802.field_19058)
                .method_10434('Z', class_1802.field_19044)
                .method_10434('#', class_1802.field_8773)
                .method_10429("has_iron_block", method_10426(class_1802.field_8773))
                .method_36443(field_53721, method_36450(ModBlocks.ANTI_COLLISION_BARREL));
        // 轮椅
        method_62746(class_7800.field_40642, ModBlocks.WHEEL_CHAIR)
                .method_10439("Z  ")
                .method_10439("X# ")
                .method_10439("YYY")
                .method_10434('#', class_1802.field_8620)
                .method_10434('X', class_1802.field_8773)
                .method_10434('Y', class_1802.field_55044)
                .method_10434('Z', class_1802.field_19059)
                .method_10429("has_iron", method_10426(class_1802.field_8620))
                .method_36443(field_53721, method_36450(ModBlocks.WHEEL_CHAIR));

        // 木板箱
        method_62746(class_7800.field_40642, ModBlocks.WOODEN_BOX.chestBlock())
                .method_10439("YZY")
                .method_10439("X#X")
                .method_10439("YZY")
                .method_10434('#', class_1802.field_8106)
                .method_10434('X', class_1802.field_8320)
                .method_10434('Y', class_1802.field_8118)
                .method_10434('Z', class_1802.field_8600)
                .method_10429("has_stick", method_10426(class_1802.field_8600))
                .method_36443(field_53721, method_36450(ModBlocks.WOODEN_BOX.chestBlock()));

        // Fumo销售许可
        method_62746(class_7800.field_40642, ModItems.FUMO_LICENSE)
                .method_10439("YXY")
                .method_10439("X#X")
                .method_10439("YXY")
                .method_10434('X', class_1802.field_19044)
                .method_10434('Y', class_1802.field_8477)
                .method_10434('#', class_1802.field_8407)
                .method_10429("has_wool", method_10426(class_1802.field_19044))
                .method_36443(field_53721, method_36450(ModItems.FUMO_LICENSE));

        // 烟火之星
        method_62746(class_7800.field_40642, class_1802.field_8450)
                .method_10439("###")
                .method_10439("#X#")
                .method_10439("###")
                .method_10434('#', class_1802.field_8054)
                .method_10434('X', class_1802.field_8858)
                .method_10429("has_sand", method_10426(class_1802.field_8054))
                .method_36443(field_53721, "rd_provided_" + method_36450(class_1802.field_8450));

        // 弹幕核心
        method_62746(class_7800.field_40642, ModItems.DANMAKU_CORE)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('#', class_1802.field_8450)
                .method_10434('X', class_1802.field_8675)
                .method_10429("has_sand", method_10426(class_1802.field_8450))
                .method_36443(field_53721, method_36450(ModItems.DANMAKU_CORE));

        this.generateWoodCreator(ModBlocks.SPIRITUAL);
        this.generateWoodCreator(MIBlocks.LEMON);
        this.generateWoodCreator(MIBlocks.GINKGO);
        this.generateDecorativeBlock();

        this.generateWorkBlock();
        this.generateOrb();
        this.generateSilver();
        this.generateMaid();
        this.generateMagicIce();
        this.generateDream();
        this.generateMusicBlock();
        this.generateIngredient();
        this.generateMIPlant2Ingredient();
        this.generateMICookRecipe();
    }

    private void generateWoodCreator(WoodCreator creator) {
        class_7871<class_1792> itemImpl = this.field_48981.method_46762(class_7924.field_41197);
        class_2248 log = creator.log();
        class_2248 wood = creator.wood();
        class_2248 strippedLog = creator.strippedLog();
        class_2248 strippedWood = creator.strippedWood();
        class_2248 planks = creator.planks();
        class_2248 stair = creator.stairs();
        class_2248 slab = creator.slab();
        class_2248 door = creator.door();
        class_2248 trapdoor = creator.trapdoor();
        class_2248 fence = creator.fence();
        class_2248 fenceGate = creator.fenceGate();
        class_2248 button = creator.button();

        method_33535(creator.getBlockFamily(), class_7699.method_45397());

        // 原木 -> 木板（shapeless）
        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(log)
                .method_10452("planks")
                .method_10442("has_log", method_10426(log))
                .method_36443(field_53721, method_33714(planks, log));

        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(wood)
                .method_10452("planks")
                .method_10442("has_wood", method_10426(wood))
                .method_36443(field_53721, method_33714(planks, wood));
        // 去皮木 -> 木板（shapeless）
        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(strippedLog)
                .method_10452("planks")
                .method_10442("has_log", method_10426(log))
                .method_36443(field_53721, method_33714(planks, strippedLog));

        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(strippedWood)
                .method_10452("planks")
                .method_10442("has_wood", method_10426(wood))
                .method_36443(field_53721, method_33714(planks, strippedWood));

        // 木板 -> 楼梯
        method_32808(stair, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 台阶
        method_32804(class_7800.field_40635, slab, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 + 棍子 -> 栅栏
        method_33546(fence, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 + 棍子 -> 栅栏门
        method_33548(fenceGate, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 活板门
        method_33553(trapdoor, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 门
        method_33544(door, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 按钮
        method_33542(button, class_1856.method_8101(planks)).
                method_33529("wooden_button")
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);
    }

    private void generateIngredient() {
        method_62746(class_7800.field_40640, MIItems.CHEESE)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', class_1802.field_8103)
                .method_10429("has_milk", method_10426(class_1802.field_8103))
                .method_36443(field_53721, method_36450(MIItems.CHEESE));
        method_62746(class_7800.field_40640, MIItems.BUTTER)
                .method_10439("#")
                .method_10439("#")
                .method_10439("X")
                .method_10434('#', class_1802.field_8103)
                .method_10434('X', class_1802.field_8428)
                .method_10429("has_milk", method_10426(MIItems.FLOUR))
                .method_36443(field_53721, method_36450(MIItems.BUTTER));
        method_62746(class_7800.field_40640, MIItems.FLOUR)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', class_1802.field_8861)
                .method_10429("has_wheat", method_10426(class_1802.field_8861))
                .method_36443(field_53721, method_36450(MIItems.FLOUR));
        method_62746(class_7800.field_40640, MIItems.TOFU)
                .method_10439("##")
                .method_10439("##")
                .method_10433('#', MIBlocks.SOY_BEANS.getSeed())
                .criterion("has_soy_beans", method_10426(MIBlocks.SOY_BEANS.getSeed()))
                .offerTo(field_53721, method_36450(MIItems.TOFU));
        method_62746(class_7800.field_40640, MIItems.CAPSAICIN)
                .method_10439("#")
                .method_10439("X")
                .method_10434('#', MIItems.CHILI)
                .method_10434('X', class_1802.field_8469)
                .method_10429("has_chili", method_10426(MIItems.CHILI))
                .method_36443(field_53721, method_36450(MIItems.CAPSAICIN));
        method_62746(class_7800.field_40640, MIItems.CREAM)
                .method_10439("#")
                .method_10439("#")
                .method_10439("X")
                .method_10434('#', class_1802.field_8103)
                .method_10434('X', class_1802.field_8469)
                .method_10429("has_chili", method_10426(MIItems.CHILI))
                .method_36443(field_53721, method_36450(MIItems.CREAM));

        method_36233(List.of(MIItems.BLACK_PORK, MIItems.WILD_BOAR_MEAT), class_7800.field_40642, class_1802.field_8261, 0.7F, 160, "food");

//        createShaped(RecipeCategory.FOOD, MIItems.FLOWERS)
//                .pattern("##")
//                .pattern("##")
//                .input('#', ItemTags.FLOWERS)
//                .criterion("has_wheat", conditionsFromItem(Items.WHEAT))
//                .offerTo(exporter, getRecipeName(MIItems.FLOUR));
    }

    private void generateDecorativeBlock() {
        ModBlocks.ICE_SCALES.offerRecipe(this, ModItems.ICE_SCALES);
        ModBlocks.DREAM_STONE.offerRecipe(this, ModBlocks.DREAM_STONE.block().method_8389());
        ModBlocks.DREAM_STONE_BRICK.offerRecipe(this, ModBlocks.DREAM_STONE_BRICK.block().method_8389());
        ModBlocks.MOON_STONE.offerRecipe(this, ModBlocks.MOON_STONE.block().method_8389());
        ModBlocks.MOON_STONE_BRICK.offerRecipe(this, ModBlocks.MOON_STONE_BRICK.block().method_8389());
    }

    private void generateMusicBlock() {
        // 音乐盒
        method_62746(class_7800.field_40636, ModBlocks.MUSIC_BLOCK)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8687)
                .method_10434('#', class_1802.field_8643)
                .method_10429("has_emerald", method_10426(class_1802.field_8687))
                .method_36443(field_53721, method_36450(ModBlocks.MUSIC_BLOCK));
        // 小提琴
        method_62746(class_7800.field_40638, ModItems.VIOLIN)
                .method_10439(" X ")
                .method_10439("XYX")
                .method_10439("X#X")
                .method_10434('X', class_1802.field_8113)
                .method_10434('Y', class_1802.field_8276)
                .method_10434('#', ModBlocks.MUSIC_BLOCK)
                .method_10429("has_music_block", method_10426(ModBlocks.MUSIC_BLOCK))
                .method_36443(field_53721, method_36450(ModItems.VIOLIN));
        // 键盘
        method_62746(class_7800.field_40638, ModItems.KEYBOARD)
                .method_10439("XYX")
                .method_10439("YXY")
                .method_10439("Z#W")
                .method_10434('X', class_1802.field_19059)
                .method_10434('Y', class_1802.field_8592)
                .method_10434('Z', class_1802.field_8781)
                .method_10434('W', class_1802.field_8725)
                .method_10434('#', ModBlocks.MUSIC_BLOCK)
                .method_10429("has_music_block", method_10426(ModBlocks.MUSIC_BLOCK))
                .method_36443(field_53721, method_36450(ModItems.KEYBOARD));
        // 小号
        method_62746(class_7800.field_40638, ModItems.TRUMPET)
                .method_10439("XXX")
                .method_10439("XY#")
                .method_10439("ZYX")
                .method_10434('X', class_1802.field_8695)
                .method_10434('Y', class_1802.field_8781)
                .method_10434('Z', class_1802.field_8725)
                .method_10434('#', ModBlocks.MUSIC_BLOCK)
                .method_10429("has_music_block", method_10426(ModBlocks.MUSIC_BLOCK))
                .method_36443(field_53721, method_36450(ModItems.TRUMPET));
    }

    private void generateWorkBlock() {
        // 弹幕工作台
        method_62746(class_7800.field_40635, ModBlocks.DANMAKU_CRAFTING_TABLE)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8725)
                .method_10434('#', class_1802.field_8465)
                .method_10429("has_redstone", method_10426(class_1802.field_8725))
                .method_36443(field_53721, method_36450(ModBlocks.DANMAKU_CRAFTING_TABLE));

        // 幻想乡祭坛
        method_62746(class_7800.field_40635, ModBlocks.GENSOKYO_ALTAR)
                .method_10439("X")
                .method_10439("#")
                .method_10434('X', class_1802.field_8733)
                .method_10434('#', class_1802.field_8657)
                .method_10429("has_emerald", method_10426(class_1802.field_8733))
                .method_36443(field_53721, method_36450(ModBlocks.GENSOKYO_ALTAR));

        // 强化台
        method_62746(class_7800.field_40635, ModBlocks.STRENGTH_TABLE)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', ModItems.SILVER_INGOT)
                .method_10434('#', class_1802.field_8657)
                .method_10429("has_silver", method_10426(ModItems.SILVER_INGOT))
                .method_36443(field_53721, method_36450(ModBlocks.STRENGTH_TABLE));
    }

    private void generateOrb() {
        // 宝玉 / 宝玉块
        offerIngotToBlockRecipe(field_53721, ModItems.RED_ORB, ModBlocks.RED_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.RED_ORB_BLOCK.method_8389(), ModItems.RED_ORB);

        offerIngotToBlockRecipe(field_53721, ModItems.YELLOW_ORB, ModBlocks.YELLOW_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.YELLOW_ORB_BLOCK.method_8389(), ModItems.YELLOW_ORB);

        offerIngotToBlockRecipe(field_53721, ModItems.BLUE_ORB, ModBlocks.BLUE_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.BLUE_ORB_BLOCK.method_8389(), ModItems.BLUE_ORB);

        offerIngotToBlockRecipe(field_53721, ModItems.GREEN_ORB, ModBlocks.GREEN_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.GREEN_ORB_BLOCK.method_8389(), ModItems.GREEN_ORB);

        offerIngotToBlockRecipe(field_53721, ModItems.PURPLE_ORB, ModBlocks.PURPLE_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.PURPLE_ORB_BLOCK.method_8389(), ModItems.PURPLE_ORB);

    }

    private void generateSilver() {
        // 银武器/工具
        offerSwordRecipe(field_53721, ModItems.SILVER_SWORD, ModItems.SILVER_INGOT);
        offerPickaxeRecipe(field_53721, ModItems.SILVER_PICKAXE, ModItems.SILVER_INGOT);
        offerAxeRecipe(field_53721, ModItems.SILVER_AXE, ModItems.SILVER_INGOT);
        offerShovelRecipe(field_53721, ModItems.SILVER_SHOVEL, ModItems.SILVER_INGOT);
        offerHoeRecipe(field_53721, ModItems.SILVER_HOE, ModItems.SILVER_INGOT);

        // 银盔甲
        offerHelmetRecipe(field_53721, ModItems.SILVER_HELMET, ModItems.SILVER_INGOT);
        offerChestplateRecipe(field_53721, ModItems.SILVER_CHESTPLATE, ModItems.SILVER_INGOT);
        offerLeggingsRecipe(field_53721, ModItems.SILVER_LEGGINGS, ModItems.SILVER_INGOT);
        offerBootsRecipe(field_53721, ModItems.SILVER_BOOTS, ModItems.SILVER_INGOT);

        // 银粒 / 锭 / 块
        offerIngotToBlockRecipe(field_53721, ModItems.SILVER_NUGGET, ModItems.SILVER_INGOT);
        offerBlockToIngotRecipe(field_53721, ModItems.SILVER_INGOT, ModItems.SILVER_NUGGET);
        offerIngotToBlockRecipe(field_53721, ModItems.SILVER_INGOT, ModBlocks.SILVER_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, ModBlocks.SILVER_BLOCK.method_8389(), ModItems.SILVER_INGOT);

        method_62746(class_7800.field_40635, ModBlocks.SILVER_CHEST_BLOCK.chestBlock())
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', ModItems.SILVER_INGOT)
                .method_10434('#', class_1802.field_8106)
                .method_10429("has_silver", method_10426(ModItems.SILVER_INGOT))
                .method_36443(field_53721, method_36450(ModBlocks.SILVER_CHEST_BLOCK.chestBlock()));

        // 烧银矿
        method_36233(SILVER, class_7800.field_40642, ModItems.SILVER_INGOT, 0.7F, 250, "silver_ingot");
        method_36234(SILVER, class_7800.field_40642, ModItems.SILVER_INGOT, 0.7F, 250, "silver_ingot");

    }

    private void generateMaid() {
        Map<class_1792, class_1792> itemItemMap = new HashMap<>(
                Map.of(
                        ModItems.SILVER_HELMET, ModItems.MAID_HAIRBAND,
                        ModItems.SILVER_CHESTPLATE, ModItems.MAID_UPPER_SKIRT,
                        ModItems.SILVER_LEGGINGS, ModItems.MAID_LOWER_SKIRT,
                        ModItems.SILVER_BOOTS, ModItems.MAID_SHOE
                )
        );
        for (Map.Entry<class_1792, class_1792> itemItemEntry : itemItemMap.entrySet()) {
            class_1792 left = itemItemEntry.getKey();
            class_1792 right = itemItemEntry.getValue();
            method_62746(class_7800.field_40636, right)
                    .method_10439("XXX")
                    .method_10439("X#X")
                    .method_10439("XXX")
                    .method_10433('X', class_3489.field_15544)
                    .method_10434('#', left)
                    .method_10429("has_wool", method_10420(class_3489.field_15544))
                    .method_36443(field_53721, method_36450(right));
        }
    }

    private void generateMagicIce() {
        method_36233(List.of(ModBlocks.MAGIC_ICE_BLOCK.method_8389()), class_7800.field_40642, ModItems.ICE_SCALES, 0.7F, 140, "silver_ingot");
        method_36234(List.of(ModBlocks.MAGIC_ICE_BLOCK.method_8389()), class_7800.field_40642, ModItems.ICE_SCALES, 0.7F, 70, "silver_ingot");
        // 魔法冰
        method_62746(class_7800.field_40635, ModBlocks.MAGIC_ICE_BLOCK)
                .method_10439("XX")
                .method_10439("XX")
                .method_10434('X', class_1802.field_8426)
                .method_10429("has_ice", method_10426(class_1802.field_8426))
                .method_36443(field_53721, method_36450(ModBlocks.MAGIC_ICE_BLOCK));

        // 冰武器/工具
        offerSwordRecipe(field_53721, ModItems.MAGIC_ICE_SWORD, ModItems.ICE_SCALES);
        offerPickaxeRecipe(field_53721, ModItems.MAGIC_ICE_PICKAXE, ModItems.ICE_SCALES);
        offerAxeRecipe(field_53721, ModItems.MAGIC_ICE_AXE, ModItems.ICE_SCALES);
        offerShovelRecipe(field_53721, ModItems.MAGIC_ICE_SHOVEL, ModItems.ICE_SCALES);
        offerHoeRecipe(field_53721, ModItems.MAGIC_ICE_HOE, ModItems.ICE_SCALES);

        // 冰盔甲
        offerHelmetRecipe(field_53721, ModItems.MAGIC_ICE_HELMET, ModBlocks.MAGIC_ICE_BLOCK.method_8389());
        offerChestplateRecipe(field_53721, ModItems.MAGIC_ICE_CHESTPLATE, ModBlocks.MAGIC_ICE_BLOCK.method_8389());
        offerLeggingsRecipe(field_53721, ModItems.MAGIC_ICE_LEGGINGS, ModBlocks.MAGIC_ICE_BLOCK.method_8389());
        offerBootsRecipe(field_53721, ModItems.MAGIC_ICE_BOOTS, ModBlocks.MAGIC_ICE_BLOCK.method_8389());

    }

    private void generateDream() {
        // 梦境水晶武器/工具
        offerSwordRecipe(field_53721, ModItems.DREAM_SWORD, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerPickaxeRecipe(field_53721, ModItems.DREAM_PICKAXE, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerAxeRecipe(field_53721, ModItems.DREAM_AXE, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerShovelRecipe(field_53721, ModItems.DREAM_SHOVEL, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerHoeRecipe(field_53721, ModItems.DREAM_HOE, ModItems.DREAM_CRYSTAL_FRAGMENT);

        // 梦境水晶盔甲
        offerHelmetRecipe(field_53721, ModItems.DREAM_HELMET, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerChestplateRecipe(field_53721, ModItems.DREAM_CHESTPLATE, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerLeggingsRecipe(field_53721, ModItems.DREAM_LEGGINGS, ModItems.DREAM_CRYSTAL_FRAGMENT);
        offerBootsRecipe(field_53721, ModItems.DREAM_BOOTS, ModItems.DREAM_CRYSTAL_FRAGMENT);

        // 烧梦境水晶矿
        method_36233(DREAM, class_7800.field_40642, ModItems.DREAM_CRYSTAL_FRAGMENT, 0.7F, 250, "dream_ingot");
        method_36234(DREAM, class_7800.field_40642, ModItems.DREAM_CRYSTAL_FRAGMENT, 0.7F, 250, "dream_ingot");

    }

    private void generateMIPlant2Ingredient() {
        method_62746(class_7800.field_40640, MIItems.UDUMBARA)
                .method_10439("#")
                .method_10434('#', MIBlocks.UDUMBARA_FLOWER)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIItems.UDUMBARA));
        method_62746(class_7800.field_40640, MIItems.TREMELLA)
                .method_10439("#")
                .method_10434('#', MIBlocks.TREMELLA)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIItems.TREMELLA));
    }

    private void generateMICookRecipe() {
        // 厨具
        method_62746(class_7800.field_40635, MIBlocks.COOKING_POT)
                .method_10439(" Y ")
                .method_10439("X X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8675)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIBlocks.COOKING_POT));

        method_62746(class_7800.field_40635, MIBlocks.CUTTING_BOARD)
                .method_10439(" Y ")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8320)
                .method_10434('Y', class_1802.field_8371)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIBlocks.CUTTING_BOARD));

        method_62746(class_7800.field_40635, MIBlocks.FRYING_PAN)
                .method_10439(" XX")
                .method_10439(" XX")
                .method_10439("Y  ")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8675)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIBlocks.FRYING_PAN));

        method_62746(class_7800.field_40635, MIBlocks.GRILL)
                .method_10439("YYY")
                .method_10439("X X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8675)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIBlocks.GRILL));

        method_62746(class_7800.field_40635, MIBlocks.STEAMER)
                .method_10439("YYY")
                .method_10439("X X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8320)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIBlocks.STEAMER));
        method_62746(class_7800.field_40635, MIBlocks.ITEM_DISPLAY)
                .method_10439("YXY")
                .method_10439(" Y ")
                .method_10434('X', class_1802.field_8143)
                .method_10434('Y', class_1802.field_8155)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(MIBlocks.ITEM_DISPLAY));

        this.offerMIUpgradeRecipes();
//        // 能量罩
//        createShaped(RecipeCategory.DECORATIONS, MIBlocks.COOKTOP)
//                .pattern("YYY")
//                .pattern("YXY")
//                .pattern("YYY")
//                .input('X', Items.FURNACE)
//                .input('Y', Items.BRICKS)
//                .criterion("always", conditionsFromItem(Items.AIR))
//                .offerTo(exporter, getRecipeName(MIBlocks.COOKTOP));
    }

    private void offerMIUpgradeRecipes() {
        Map<class_2248, class_2248> mystiaUpgrade = new Object2ObjectOpenHashMap<>();
        mystiaUpgrade.put(MIBlocks.COOKING_POT, MIBlocks.MYSTIA_COOKING_POT);
        mystiaUpgrade.put(MIBlocks.CUTTING_BOARD, MIBlocks.MYSTIA_CUTTING_BOARD);
        mystiaUpgrade.put(MIBlocks.FRYING_PAN, MIBlocks.MYSTIA_FRYING_PAN);
        mystiaUpgrade.put(MIBlocks.GRILL, MIBlocks.MYSTIA_GRILL);
        mystiaUpgrade.put(MIBlocks.STEAMER, MIBlocks.MYSTIA_STEAMER);
        this.offerUpgradeRecipes(mystiaUpgrade, class_1802.field_8153);

        Map<class_2248, class_2248> superUpgrade = new Object2ObjectOpenHashMap<>();
        superUpgrade.put(MIBlocks.COOKING_POT, MIBlocks.SUPER_COOKING_POT);
        superUpgrade.put(MIBlocks.CUTTING_BOARD, MIBlocks.SUPER_CUTTING_BOARD);
        superUpgrade.put(MIBlocks.FRYING_PAN, MIBlocks.SUPER_FRYING_PAN);
        superUpgrade.put(MIBlocks.GRILL, MIBlocks.SUPER_GRILL);
        superUpgrade.put(MIBlocks.STEAMER, MIBlocks.SUPER_STEAMER);
        this.offerUpgradeRecipes(superUpgrade, class_1802.field_8695);

        Map<class_2248, class_2248> extremeUpgrade = new Object2ObjectOpenHashMap<>();
        extremeUpgrade.put(MIBlocks.COOKING_POT, MIBlocks.EXTREME_COOKING_POT);
        extremeUpgrade.put(MIBlocks.CUTTING_BOARD, MIBlocks.EXTREME_CUTTING_BOARD);
        extremeUpgrade.put(MIBlocks.FRYING_PAN, MIBlocks.EXTREME_FRYING_PAN);
        extremeUpgrade.put(MIBlocks.GRILL, MIBlocks.EXTREME_GRILL);
        extremeUpgrade.put(MIBlocks.STEAMER, MIBlocks.EXTREME_STEAMER);
        this.offerUpgradeRecipes(extremeUpgrade, class_1802.field_8477);

        Map<class_2248, class_2248> nukeUpgrade = new Object2ObjectOpenHashMap<>();
        nukeUpgrade.put(MIBlocks.COOKING_POT, MIBlocks.NUKE_COOKING_POT);
        nukeUpgrade.put(MIBlocks.CUTTING_BOARD, MIBlocks.NUKE_CUTTING_BOARD);
        nukeUpgrade.put(MIBlocks.FRYING_PAN, MIBlocks.NUKE_FRYING_PAN);
        nukeUpgrade.put(MIBlocks.GRILL, MIBlocks.NUKE_GRILL);
        nukeUpgrade.put(MIBlocks.STEAMER, MIBlocks.NUKE_STEAMER);
        this.offerUpgradeRecipes(nukeUpgrade, class_1802.field_20398);


    }

    private void offerUpgradeRecipes(Map<class_2248, class_2248> blockBlockMap, class_1792 upgradeMaterial) {
        Set<Map.Entry<class_2248, class_2248>> entries = blockBlockMap.entrySet();
        for (Map.Entry<class_2248, class_2248> entry : entries) {
            class_2248 key = entry.getKey();
            class_2248 value = entry.getValue();
            method_62746(class_7800.field_40635, value)
                    .method_10439("YYY")
                    .method_10439("YXY")
                    .method_10439("YYY")
                    .method_10434('X', key)
                    .method_10434('Y', upgradeMaterial)
                    .method_10429("always", method_10426(class_1802.field_8162))
                    .method_36443(field_53721, method_36450(value));
        }
    }

    private void offerSwordRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("X")
                .method_10439("X")
                .method_10439("#")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerPickaxeRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("XXX")
                .method_10439(" # ")
                .method_10439(" # ")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerAxeRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("XX")
                .method_10439("X#")
                .method_10439(" #")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerShovelRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("X")
                .method_10439("#")
                .method_10439("#")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerHoeRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("XX")
                .method_10439(" #")
                .method_10439(" #")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerHelmetRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("XXX")
                .method_10439("X X")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerChestplateRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("X X")
                .method_10439("XXX")
                .method_10439("XXX")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerLeggingsRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("XXX")
                .method_10439("X X")
                .method_10439("X X")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerBootsRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("X X")
                .method_10439("X X")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offer4To1Recipe(class_8790 exporter, class_1792 input, class_1792 export) {
        class_2960 id = class_7923.field_41178.method_10221(input);
        method_62746(class_7800.field_40634, export)
                .method_10439("XX")
                .method_10439("XX")
                .method_10434('X', input)
                .method_10429("has_" + id.method_12832(), method_10426(input))
                .method_36443(exporter, method_36450(export));
    }

    private void offer1To4Recipe(class_8790 exporter, class_1792 input, class_1792 export) {
        class_2960 id = class_7923.field_41178.method_10221(input);
        method_62747(class_7800.field_40634, export, 4)
                .method_10439("X")
                .method_10434('X', input)
                .method_10429("has_" + id.method_12832(), method_10426(input))
                .method_36443(exporter, method_36450(export));
    }

    private void offerIngotToBlockRecipe(class_8790 exporter, class_1792 ingot, class_1792 block) {
        method_62746(class_7800.field_40634, block)
                .method_10439("XXX")
                .method_10439("XXX")
                .method_10439("XXX")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(block));
    }

    private void offerBlockToIngotRecipe(class_8790 exporter, class_1792 block, class_1792 ingot) {
        method_62750(class_7800.field_40642, ingot, 9)
                .method_10454(block)
                .method_10442("has_block", method_10426(block))
                .method_36443(exporter, method_36450(ingot) + "_from_block");
    }


}
