package cc.thonly.reverie_dreams.datagen.generator;

import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10186;
import net.minecraft.class_10394;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

@Slf4j
@Environment(value = EnvType.CLIENT)
public abstract class EquipmentAssetProvider implements class_2405 {
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public EquipmentAssetProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    protected abstract void bootstrap(BiConsumer<class_5321<class_10394>, class_10186> consumer);

    protected class_10186 createHumanoidOnlyModel(String id) {
        return class_10186.method_63994().method_63998(class_2960.method_60656(id)).method_63997();
    }

    protected class_10186 createHumanoidAndHorseModel(String id) {
        return class_10186.method_63994().method_63998(class_2960.method_60656(id)).method_64001(class_10186.class_10190.field_54129, class_10186.class_10189.method_64005(class_2960.method_60656(id), false)).method_63997();
    }

    protected class_10186 createHumanoidOnlyModel(class_2960 id) {
        return class_10186.method_63994().method_63998(id).method_63997();
    }

    protected class_10186 createHumanoidAndHorseModel(class_2960 id) {
        return class_10186.method_63994().method_63998(id).method_64001(class_10186.class_10190.field_54129, class_10186.class_10189.method_64005(id, false)).method_63997();
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> this.export(writer));
    }

    public void export(class_7403 writer) {
        try {
            Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR);
            HashMap<class_5321<class_10394>, class_10186> map = new HashMap<>();
            this.bootstrap((key, model) -> {
                if (map.putIfAbsent(key, model) != null) {
                    throw new IllegalStateException("Tried to register equipment asset twice for id: " + String.valueOf(key));
                }
                class_2960 identifier = key.method_29177();
                String namespaceRef = identifier.method_12836();
                String pathRef = identifier.method_12832();
                Path generatePath = DataGeneratorUtil.getAssets(path, namespaceRef, "equipment", null);

                DataResult<JsonElement> result = class_10186.field_54120.encodeStart(JsonOps.INSTANCE, model);
                Optional<JsonElement> optional = result.result();

                if (optional.isPresent()) {
                    JsonElement element = optional.get();
                    Path output = generatePath.resolve(pathRef + ".json");
                    String jsonString = this.gson.toJson(element);
                    byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                    try {
                        Files.createDirectories(output.getParent());
                        writer.method_43346(output, bytes, HashCode.fromBytes(bytes));
                    } catch (IOException e) {
                        log.error("Can't generate equipment asset {}", identifier.toString());
                    }
                }
            });
        } catch (Exception err) {
            log.error("Fail to generate equipment provider");
        }
    }

    @Override
    public String method_10321() {
        return "Equipment Asset Definitions";
    }
}
