package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.*;
import java.util.concurrent.CompletableFuture;

@Slf4j
@SuppressWarnings({"unchecked", "rawtypes"})
public abstract class RecipeTypeProvider implements class_2405 {
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, Factory<?>> identifierFactoryMap = new Object2ObjectOpenHashMap<>();

    public RecipeTypeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    public ItemStackWrapper ofEmpty() {
        return ItemStackWrapper.empty();
    }

    public ItemStackWrapper ofItem(class_1799 item) {
        return ItemStackWrapper.of(item);
    }

    public ItemStackWrapper ofItem(class_1792 item) {
        return ItemStackWrapper.of(item);
    }

    public ItemStackWrapper ofItem(class_2248 block) {
        return ItemStackWrapper.of(block.method_8389());
    }

    public ItemStackWrapper ofItem(class_2248 block, int amount) {
        return ItemStackWrapper.of(block.method_8389(), amount);
    }

    public ItemStackWrapper ofItem(class_1792 item, int amount) {
        return ItemStackWrapper.of(item, amount);
    }

    public ItemStackWrapper ofItem(class_1792 item, int amount, class_9326 components) {
        return ItemStackWrapper.of(item, amount, components);
    }

    public List<ItemStackWrapper> ofList(class_1792... items) {
        LinkedList<ItemStackWrapper> wrappers = new LinkedList<>();
        for (class_1792 item : items) {
            wrappers.add(this.ofItem(item));
        }
        return wrappers;
    }

    public List<ItemStackWrapper> ofList(class_1799... items) {
        LinkedList<ItemStackWrapper> wrappers = new LinkedList<>();
        for (class_1799 stack : items) {
            wrappers.add(this.ofItem(stack));
        }
        return wrappers;
    }

    public List<ItemStackWrapper> ofList(ItemStackWrapper... stackRecipeWrappers) {
        return new LinkedList<>(Arrays.asList(stackRecipeWrappers));
    }

    public synchronized <R extends BaseRecipe> Factory<R> getOrCreateFactory(BaseRecipeType<R> recipeType, Class<R> rClass) {
        class_2960 id = recipeType.getId();
        if (this.identifierFactoryMap.containsKey(id)) {
            return (Factory<R>) this.identifierFactoryMap.get(id);
        }
        Factory<R> factory = new Factory<>(recipeType, rClass);
        this.identifierFactoryMap.put(id, factory);
        return factory;
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    public abstract void configured();

    public void export(class_7403 writer) {
        try {
            Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR);
            for (Map.Entry<class_2960, Factory<?>> entry : identifierFactoryMap.entrySet()) {
                Factory<?> factory = entry.getValue();
                Codec codec = factory.getCodec();
                BaseRecipeType<?> recipeType = factory.getRecipeType();
                Map<class_2960, ?> registries = factory.getRegistries();
                Path generatePath = DataGeneratorUtil.getData(path, Touhou.MOD_ID, recipeType.getTypeId() + "_recipe", null);

                for (Map.Entry<class_2960, ?> registryEntry : registries.entrySet()) {
                    class_2960 identifier = registryEntry.getKey();
                    Object value = registryEntry.getValue();
                    DataResult<JsonElement> result = codec.encodeStart(JsonOps.INSTANCE, value);
                    Optional<JsonElement> optional = result.result();

                    if (optional.isPresent()) {
                        JsonElement element = optional.get();
                        Path output = generatePath.resolve(identifier.method_12832() + ".json");
                        String jsonString = this.gson.toJson(element);
                        byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                        Files.createDirectories(output.getParent());

                        writer.method_43346(output, bytes, HashCode.fromBytes(bytes));
                    }
                }
            }
        } catch (Exception err) {
            log.error("Error: ", err);
        }
    }

    @Getter
    public static class Factory<R extends BaseRecipe> {
        protected final Class<R> rClass;
        protected final BaseRecipeType<R> recipeType;
        protected final Codec<R> codec;
        protected final Map<class_2960, R> registries = new Object2ObjectOpenHashMap<>();

        protected Factory(BaseRecipeType<R> recipeType, Class<R> rClass) {
            this.recipeType = recipeType;
            this.codec = recipeType.getCodec();
            this.rClass = rClass;
        }

        public Factory<R> register(class_1792 output, R recipe) {
            return this.register(class_7923.field_41178.method_10221(output), recipe);
        }

        public Factory<R> register(class_2248 output, R recipe) {
            class_2960 id = class_7923.field_41175.method_10221(output);
            if (output.method_8389() == class_1802.field_8162) {
                log.error("Found unknown BlockItem {} in {}", id, id + ".json");
                return this;
            }
            return this.register(id, recipe);
        }

        public Factory<R> register(class_2960 id, R recipe) {
            class_2960 identifier = class_2960.method_60655(id.method_12836(), id.method_12832().replaceAll("/", "-"));
            boolean contains = this.registries.containsKey(id);
            if (contains) {
                log.error("Duplicate recipe id found {} in {}", id, id + ".json");
            }
            this.registries.put(identifier, recipe);
            return this;
        }

        public void export(RegistryEntriesFactory<R> factory) {
            factory.apply(this.registries);
        }

        @FunctionalInterface
        public interface RegistryEntriesFactory<R> {
            void apply(Map<class_2960, R> registries);
        }
    }

}
