package cc.thonly.reverie_dreams.dialog;

import cc.thonly.mystias_izakaya.block.MIBlocks;
import cc.thonly.mystias_izakaya.entity.MIEntities;
import cc.thonly.registry_modifier.api.DynamicRegistryManagerCallback;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.block.ModBlocks;
import cc.thonly.reverie_dreams.entity.ModEntities;
import cc.thonly.reverie_dreams.item.ModItems;
import cc.thonly.reverie_dreams.registry.IntrinsicalRegister;
import cc.thonly.reverie_dreams.registry.OwnerBinding;
import cc.thonly.reverie_dreams.registry.RegistryManager;
import cc.thonly.reverie_dreams.registry.Translatable;
import cc.thonly.reverie_dreams.util.network.NetUtil;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.net.URI;
import java.time.ZoneId;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11419;
import net.minecraft.class_11426;
import net.minecraft.class_11434;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_11525;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class DialogInit {
    public static final Map<String, class_11419> ARGS_DIALOG = new Object2ObjectLinkedOpenHashMap<>();
    private static final List<String> ALTAR_STR = List.of(
            "§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹",
            "§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹",
            "§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹",
            "§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹",
            "§c⏹§b⏹§b⏹§b⏹§e⏹§b⏹§b⏹§b⏹§c⏹",
            "§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹",
            "§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹§b⏹",
            "§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹",
            "§b⏹§b⏹§b⏹§b⏹§c⏹§b⏹§b⏹§b⏹§b⏹"
    );
    private static final class_11419 TEMPLATE = new class_11426(
            new class_11417(
                    class_2561.method_43470("标题"),
                    Optional.empty(),
                    true, false,
                    class_11520.field_60962,
                    new ArrayList<>(List.of(

                    )),
                    new ArrayList<>(List.of(

                    ))
            ),
            new ArrayList<>(List.of()),
            Optional.empty(),
            1
    );
    private static final URI GROUP_LINK = URI.create("https://qun.qq.com/universal-share/share?ac=1&authKey=ijHEaEfpwdV4sNlrpdjmEjSZsCWx4zO9F7UM4B8vI47y4nIg%2FtNOSptKxn%2BxSrhN&busi_data=eyJncm91cENvZGUiOiIxMDU3MTMyMTc1IiwidG9rZW4iOiJjN0xaWmtWWk9KUk9hSFpkdHRrUmE4U2NhUzQyZDRHYlZIblYvRkxrWlRoUmJ6T0VXcG9nVG9hUllqRHQxUWllIiwidWluIjoiODA3MTMxODI5In0%3D&data=LLbqAIG4qDGldPh2yXGEmiNpZEV9Ch4t82ROb7z5ozfubUArvyZNB5d8huGu6plHcZ61ugJfy5suoiA4Lr6e_A&svctype=4&tempid=h5_group_info");
    public static List<class_11434> UPGRADE_ITEM_BODIES = new ArrayList<>();
    public static final List<class_1799> UPGRADE_ITEM = getUpgradeItemList();
    public static final class_5321<class_2378<class_11419>> REGISTRY = class_7924.field_60818;
    public static final class_2960 MAIN_HELP_ID = Touhou.id("main_help");
    public static final class_2960 ALTAR_HELP_ID = Touhou.id("altar_help");
    public static final class_2960 CRAFTING_DANMAKU_HELP_ID = Touhou.id("crafting_danmaku_help");
    public static final class_2960 UPGRADE_DANMAKU_HELP_ID = Touhou.id("upgrade_danmaku_help");
    public static final class_2960 GET_FUMO_HELP_ID = Touhou.id("get_fumo_help");
    public static final class_2960 ROLE_HELP_ID = Touhou.id("role_help");
    public static final class_2960 TOUHOU_MYSTIA_HELP_ID = Touhou.id("touhou_mystia_help");
    public static final class_2960 REGISTRIES_ID = Touhou.id("registries");
    public static final class_2960 OTHER_MOD_LIST_ID = Touhou.id("other_mod_list");
    public static final class_11426 MAIN_HELP;
    public static final class_11426 ALTAR_HELP;
    public static final class_11426 CRAFTING_DANMAKU_HELP;
    public static final class_11426 UPGRADE_DANMAKU_HELP;
    public static final class_11426 GET_FUMO_HELP;
    public static final class_11426 ROLE_HELP;
    public static final class_11426 TOUHOU_MYSTIA_HELP;
    public static class_11426 REGISTRIES;
    public static final class_11426 OTHER_MOD_LIST;

    public static void initRegistriesDialog() {
        record SubInfo(String argId, class_2960 registryKey, class_11426 dialog) {
        }
        List<SubInfo> list = new ArrayList<>();
        for (Map.Entry<class_5321<? extends class_2378<?>>, IntrinsicalRegister<?>> mapEntry : RegistryManager.ROOT.entrySet()) {
            class_2960 key = mapEntry.getKey().method_29177();
            IntrinsicalRegister<?> registry = mapEntry.getValue();
            class_5250 text = class_2561.method_43473();
            var page = new class_11426(
                    new class_11417(
                            class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.registries")).method_10852(class_2561.method_43470(": %s".formatted(registry.method_46765()))),
                            Optional.empty(),
                            true, false,
                            class_11520.field_60962,
                            new ArrayList<>(),
                            new ArrayList<>()
                    ),
                    new ArrayList<>(List.of()),
                    Optional.empty(),
                    1
            );
            for (Map.Entry<class_2960, ?> id2ValueMapEntry : registry.entrySet()) {
                class_2960 entryKey = id2ValueMapEntry.getKey();
                Object entryValue = id2ValueMapEntry.getValue();
                if (entryValue instanceof Translatable translatable) {
                    text.method_27693(entryKey.toString());
                    text.method_27693(" → ");
                    text.method_10852(class_2561.method_43471(translatable.translateKey()));
                    text.method_27693("\n");
                } else if (entryValue instanceof OwnerBinding<?> owner) {
                    IntrinsicalRegister<?> registryRef = owner.getOwner();
                    text.method_27693(entryKey.toString());
                    text.method_27693(" → ");
                    text.method_10852(class_2561.method_43471(registryRef.method_46765().method_29177().method_12832() + ".null"));
                    text.method_27693("\n");
                }
            }
            page.comp_4305().comp_4304().add(new class_11435(text, 800));
            page.comp_4317().add(new class_11519(
                    new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.text.back")), 200),
                    Optional.of(new class_11525(showPage("REGISTRIES")))
            ));
            list.add(new SubInfo("registry/" + key.toString(), key, page));
        }
        REGISTRIES = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.registries"),
                        Optional.empty(),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                        )),
                        new ArrayList<>(List.of(
                        ))
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        for (SubInfo subInfo : list) {
            String argId = subInfo.argId();
            class_2960 registryKey = subInfo.registryKey;
            class_11426 dialog = subInfo.dialog();
            REGISTRIES.comp_4317().add(
                    new class_11519(
                            new class_11416(
                                    class_2561.method_43470(registryKey.toString()),
                                    300
                            ),
                            Optional.of(new class_11525(showPage(argId)))
                    )
            );
            ARGS_DIALOG.put(argId, dialog);
        }
        REGISTRIES.comp_4317().add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.text.back")), 200),
                Optional.of(new class_11525(showPage("MAIN")))
        ));
        ARGS_DIALOG.put("REGISTRIES", REGISTRIES);
    }

    public static List<class_1799> getUpgradeItemList() {
        List<class_1799> list = new ArrayList<>();
        list.add(class_1802.field_8371.method_7854());
        list.add(class_1802.field_8828.method_7854());
        list.add(ModItems.SPEED_FEATHER.method_7854());
        list.add(ModItems.SPELL_CARD_TEMPLATE.method_7854());
        list.forEach(value -> UPGRADE_ITEM_BODIES.add(createItemStackBody(value)));
        return list;
    }

    static {
        MAIN_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.main"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43473(), 200),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.main.welcome")), 200),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43469("dialog.main.description.0", ConstantInfo.VERSION)), 200),
                                new class_11435(class_2561.method_43473(), 200)
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(),
                Optional.empty(),
                1);
        ALTAR_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.altar"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModBlocks.GENSOKYO_ALTAR.method_63499())).method_10852(class_2561.method_43470("使用方式：空手 + Shift + 右键")), 200),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.altar.material")), 180),
                                new class_11434(ModBlocks.SPIRITUAL.strippedLog().method_8389().method_7854(), Optional.of(new class_11435(
                                        class_2561.method_43473()
                                                .method_10852(class_2561.method_43471(ModBlocks.SPIRITUAL.strippedLog().method_63499()))
                                                .method_10852(class_2561.method_43470(" - "))
                                                .method_10852(class_2561.method_43470("§c\u999a").method_10862(class_2583.field_24360.method_27704(Touhou.id("reverie_dreams"))))
                                                .method_10852(class_2561.method_43470(" * 3"))
                                        , 200)

                                ), true, true, 16, 16),
                                new class_11434(ModBlocks.GENSOKYO_ALTAR.method_8389().method_7854(), Optional.of(new class_11435(
                                        class_2561.method_43473()
                                                .method_10852(class_2561.method_43471(ModBlocks.GENSOKYO_ALTAR.method_63499()))
                                                .method_10852(class_2561.method_43470(" - "))
                                                .method_10852(class_2561.method_43470("§e\u999a").method_10862(class_2583.field_24360.method_27704(Touhou.id("reverie_dreams"))))
                                                .method_10852(class_2561.method_43470(""))
                                        , 200)
                                ), true, true, 16, 16),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.altar.ways")), 180)
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of(
                )),
                Optional.empty(),
                9
        );
        CRAFTING_DANMAKU_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.danmaku"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11434(
                                        new class_1799(ModBlocks.DANMAKU_CRAFTING_TABLE, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModBlocks.DANMAKU_CRAFTING_TABLE.method_63499())).method_10852(class_2561.method_43470("")), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.danmaku.description.0")), 200),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.danmaku.description.1")), 180),
                                new class_11434(
                                        new class_1799(class_1802.field_8264, 4),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(class_1802.field_8264.method_7876())).method_10852(class_2561.method_43470("")), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(ModItems.DANMAKU_CORE, 4),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.DANMAKU_CORE.method_7876())).method_10852(class_2561.method_43470("")), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(ModItems.POWER, 35),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.POWER.method_7876())).method_10852(class_2561.method_43470("")), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(ModItems.POINT, 35),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.POINT.method_7876())).method_10852(class_2561.method_43470("")), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(ModItems.DANMAKU_SHAPE_CREATOR),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.DANMAKU_SHAPE_CREATOR.method_7876())).method_10852(class_2561.method_43470("")), 200)),
                                        true, true, 16, 16
                                )

                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        UPGRADE_DANMAKU_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.upgrade_danmaku"),
                        Optional.empty(),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43471("dialog.upgrade_danmaku.description.0"), 200),
                                new class_11435(class_2561.method_43471("dialog.upgrade_danmaku.description.1"), 200)
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        GET_FUMO_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.fumo"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43471("dialog.fumo.description.0"), 200),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.fumo.description.1")), 200),
                                new class_11435(class_2561.method_43473().method_10852(class_2561.method_43469("dialog.fumo.description.2", class_2561.method_43471(ModItems.FUMO_LICENSE.method_7876()))), 200),
                                new class_11434(ModItems.FUMO_LICENSE.method_7854(), Optional.empty(), true, true, 16, 16),
                                new class_11434(class_1802.field_8086.method_7854(), Optional.empty(), true, true, 16, 16),
                                new class_11434(ModEntities.SPAWN_EGG_BIND.getOrDefault(ModEntities.FUMO_SELLER_VILLAGER, ModItems.SPAWN_EGG).method_7854(), Optional.empty(), true, true, 16, 16)
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        ROLE_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.role"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43471("dialog.role.description.0"), 200),
                                new class_11435(class_2561.method_43471("dialog.role.description.1"), 200),
                                new class_11435(class_2561.method_43469("dialog.role.description.2", class_2561.method_43471(ModItems.ROLE_ARCHIVE.method_7876())), 200),
                                new class_11435(class_2561.method_43471("dialog.role.description.3"), 200),
                                new class_11435(class_2561.method_43471("dialog.role.description.4"), 200),
                                new class_11435(class_2561.method_43471("dialog.role.description.5"), 200),
                                new class_11434(
                                        new class_1799(ModItems.ROLE_CARD, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.ROLE_CARD.method_7876())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(ModItems.ROLE_ARCHIVE, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModItems.ROLE_ARCHIVE.method_7876())), 200)),
                                        true, true, 16, 16
                                )
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        TOUHOU_MYSTIA_HELP = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.mystia.main"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.0"), 200),
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.1"), 200),
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.2"), 200),
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.3"), 200),
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.4"), 200),
                                new class_11434(
                                        new class_1799(MIBlocks.COOKING_POT, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(MIBlocks.COOKING_POT.method_63499())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(MIBlocks.CUTTING_BOARD, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(MIBlocks.CUTTING_BOARD.method_63499())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(MIBlocks.FRYING_PAN, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(MIBlocks.FRYING_PAN.method_63499())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(MIBlocks.GRILL, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(MIBlocks.GRILL.method_63499())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(MIBlocks.STEAMER, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(MIBlocks.STEAMER.method_63499())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.5"), 200),
                                new class_11435(class_2561.method_43471("dialog.touhou_mystia.description.6"), 200),
                                new class_11435(class_2561.method_43469("dialog.touhou_mystia.description.7", class_2561.method_43471(MIEntities.TAVERN_VILLAGER.method_5882())), 200),
                                new class_11435(class_2561.method_43469("dialog.touhou_mystia.description.8", class_2561.method_43471(class_2246.field_16328.method_63499()), class_2561.method_43471(MIEntities.TAVERN_VILLAGER.method_5882())), 200),
                                new class_11434(
                                        new class_1799(class_2246.field_16328, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(class_2246.field_16328.method_63499())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(class_1802.field_8086, 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(class_1802.field_8086.method_7876())), 200)),
                                        true, true, 16, 16
                                ),
                                new class_11434(
                                        new class_1799(ModEntities.SPAWN_EGG_BIND.getOrDefault(MIEntities.TAVERN_VILLAGER, class_1802.field_8086), 1),
                                        Optional.of(new class_11435(class_2561.method_43473().method_10852(class_2561.method_43471(ModEntities.SPAWN_EGG_BIND.getOrDefault(MIEntities.TAVERN_VILLAGER, class_1802.field_8086).method_7876())), 200)),
                                        true, true, 16, 16
                                )
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of()),
                Optional.empty(),
                1
        );
        OTHER_MOD_LIST = new class_11426(
                new class_11417(
                        class_2561.method_43471("dialog.title.other_mod_list"),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of(
                                new class_11435(class_2561.method_43471("dialog.other_mod_list.description.0"), 200)
                        )),
                        new ArrayList<>(List.of(

                        ))
                ),
                new ArrayList<>(List.of(
                        new class_11519(
                                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43470("Polymer - Quality of Life")), 200),
                                Optional.of(new class_11525(new class_2558.class_10608(URI.create("https://modrinth.com/mod/polymer-qol"))))
                        ),
                        new class_11519(
                                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43470("Polydex")), 200),
                                Optional.of(new class_11525(new class_2558.class_10608(URI.create("https://modrinth.com/mod/polydex"))))
                        ),
                        new class_11519(
                                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43470("ExtendedItemView")), 200),
                                Optional.of(new class_11525(new class_2558.class_10608(URI.create("https://github.com/SAGUMEDREAM/ExtendedItemView/releases"))))
                        ),
                        new class_11519(
                                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43470("Polydex2EIV")), 200),
                                Optional.of(new class_11525(new class_2558.class_10608(URI.create("https://modrinth.com/mod/polydex2eiv"))))
                        )
                )),
                Optional.empty(),
                1
        );
        MAIN_HELP.comp_4317().addAll(getMainList());
        ALTAR_HELP.comp_4317().addAll(createAltarButtonList());
        ALTAR_HELP.comp_4317().add(getActionMain());
        CRAFTING_DANMAKU_HELP.comp_4317().add(getActionMain());
        UPGRADE_DANMAKU_HELP.comp_4305().comp_4304().addAll(UPGRADE_ITEM_BODIES);
        UPGRADE_DANMAKU_HELP.comp_4317().add(getActionMain());
        GET_FUMO_HELP.comp_4317().add(getActionMain());
        ROLE_HELP.comp_4317().add(getActionMain());
        TOUHOU_MYSTIA_HELP.comp_4317().add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.touhou_mystia.wiki")), 200),
                Optional.of(new class_11525(new class_2558.class_10608(URI.create("https://izakaya.cc/"))))
        ));
        TOUHOU_MYSTIA_HELP.comp_4317().add(getActionMain());
        OTHER_MOD_LIST.comp_4317().add(getActionMain());
    }

    public static class_11434 createItemStackBody(class_1799 itemStack) {
        return new class_11434(
                itemStack,
                Optional.of(new class_11435(class_2561.method_43473().method_10852(itemStack.method_7964()), 200)),
                true, true, 16, 16
        );
    }

    public static List<class_11519> getMainList() {
        List<class_11519> list = new ArrayList<>();
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.altar")), 200),
                Optional.of(new class_11525(showPage("ALTAR")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.danmaku")), 200),
                Optional.of(new class_11525(showPage("DANMAKU")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.upgrade_danmaku")), 200),
                Optional.of(new class_11525(showPage("UPGRADE_DANMAKU")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.fumo")), 200),
                Optional.of(new class_11525(showPage("FUMO")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.role")), 200),
                Optional.of(new class_11525(showPage("ROLE")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.mystia.main")), 200),
                Optional.of(new class_11525(showPage("TOUHOU_MYSTIA")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.registries")), 200),
                Optional.of(new class_11525(showPage("REGISTRIES")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.other_mod_list")), 200),
                Optional.of(new class_11525(showPage("OTHER_MOD_LIST")))
        ));
        if (isChina()) {
            list.add(getIssueButtonData());
        }
        list.add(new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.open_recipe_manager")), 200),
                Optional.of(new class_11525(new class_2558.class_10609("touhou recipe")))
        ));
        list.add(new class_11519(
                new class_11416(class_2561.method_43471("dialog.text.exit"), 100),
                Optional.empty()
        ));
        return list;
    }

    public static class_11519 getIssueButtonData() {
        if (isChina()) {
            return new class_11519(
                    new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.title.cn.issue")), 200),
                    Optional.of(new class_11525(new class_2558.class_10608(GROUP_LINK)))
            );
        }
        return null;
    }

    private static boolean isChina() {
        ZoneId zone = ZoneId.systemDefault();
        String zoneId = zone.getId();

        if (zoneId.equals("Asia/Shanghai") || zoneId.equals("Asia/Chongqing")) {
            return true;
        }

        Locale locale = Locale.getDefault();
        String country = locale.getCountry().toUpperCase();
        if (country.equals("CN") || country.equals("HK") || country.equals("MO") || country.equals("TW")) {
            return true;
        }

        return NetUtil.isChinaNetwork();
    }

    public static List<class_11519> createAltarButtonList() {
        List<class_11519> list = new ArrayList<>();
        Pattern p = Pattern.compile("§.⏹");
        for (String line : ALTAR_STR) {
            Matcher m = p.matcher(line);
            while (m.find()) {
                String token = m.group();
                class_5250 result = class_2561.method_43473();
//                result.append(" ");
                result.method_10852(class_2561.method_43470(token.replace("⏹", "\u999a"))
                        .method_10862(class_2583.field_24360.method_27704(Touhou.id("reverie_dreams"))));
//                result.append(" ");
                list.add(new class_11519(
                        new class_11416(result, 30),
                        Optional.of(new class_11525(showPage("ALTAR")))
                ));
            }
        }
        return list;
    }

    public static class_2558.class_10609 showPage(String name) {
        return new class_2558.class_10609("touhou dialog \"%s\"".formatted(name));
    }

    public static class_11519 getActionMain() {
        return new class_11519(
                new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.text.back")), 200),
                Optional.of(new class_11525(showPage("MAIN")))
        );
    }

    public static void bootstrap() {
        DynamicRegistryManagerCallback.Builder<class_11419> builder = DynamicRegistryManagerCallback.createBuilder(REGISTRY);
        builder.register(MAIN_HELP_ID, MAIN_HELP);
        builder.register(ALTAR_HELP_ID, ALTAR_HELP);
        builder.register(CRAFTING_DANMAKU_HELP_ID, CRAFTING_DANMAKU_HELP);
        builder.register(UPGRADE_DANMAKU_HELP_ID, UPGRADE_DANMAKU_HELP);
        builder.register(GET_FUMO_HELP_ID, GET_FUMO_HELP);
        builder.register(ROLE_HELP_ID, ROLE_HELP);
        builder.register(TOUHOU_MYSTIA_HELP_ID, TOUHOU_MYSTIA_HELP);
        builder.register(OTHER_MOD_LIST_ID, OTHER_MOD_LIST);
    }

    static {
        ARGS_DIALOG.put("MAIN", MAIN_HELP);
        ARGS_DIALOG.put("ALTAR", ALTAR_HELP);
        ARGS_DIALOG.put("DANMAKU", CRAFTING_DANMAKU_HELP);
        ARGS_DIALOG.put("UPGRADE_DANMAKU", UPGRADE_DANMAKU_HELP);
        ARGS_DIALOG.put("FUMO", GET_FUMO_HELP);
        ARGS_DIALOG.put("ROLE", ROLE_HELP);
        ARGS_DIALOG.put("TOUHOU_MYSTIA", TOUHOU_MYSTIA_HELP);
        ARGS_DIALOG.put("OTHER_MOD_LIST", OTHER_MOD_LIST);
    }
}
