package cc.thonly.reverie_dreams.dialog;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.server.DelayedTask;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11428;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_11525;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.*;

@Slf4j
@Getter
public class DialogPlayer {
    public static final Map<String, DialogPlayer> INSTANCES = new Object2ObjectOpenHashMap<>();
    public static final Map<String, String> FILENAME2UID = new Object2ObjectOpenHashMap<>();
    public static final Map<String, Boolean> LOADED = new Object2ObjectOpenHashMap<>();

    public static synchronized DialogPlayer play(class_3222 player, String filename, @Nullable class_3414 soundEvent) {
        if (DialogFiles.contain(filename)) {
            DialogFiles.Entry entry = DialogFiles.getEntry(filename);
            ;
            if (!LOADED.getOrDefault(filename, false)) {
                LOADED.put(filename, true);
                String uid = UUID.randomUUID().toString();
                FILENAME2UID.put(filename, uid);
                entry = DialogFiles.add(new DialogFiles.Entry(filename, uid));
            }
            if (entry == null) {
                return null;
            }
            DialogPlayer dialogPlayer = new DialogPlayer(player, entry, soundEvent);
            dialogPlayer.start();
            return dialogPlayer;
        }
        return null;
    }

    public static void reload() {
        LOADED.clear();
        FILENAME2UID.clear();
        INSTANCES.clear();
        DialogFiles.reload();
    }

    public static synchronized void tick(MinecraftServer server) {
        class_8915 tickManager = server.method_54833();
        if (!tickManager.method_54754()) {
            for (Map.Entry<String, DialogPlayer> entry : INSTANCES.entrySet()) {
                entry.getValue().tick();
            }
        }
    }

    public static DialogPlayer getInstance(String uuid) {
        return INSTANCES.get(uuid);
    }

    private final class_3222 player;
    private final String uuid;
    private LinkedList<LinkedList<String>> source = new LinkedList<>();
    private ListIterator<LinkedList<String>> iterator = null;
    private int state = 0;
    @Setter
    private boolean paused = true;
    @Nullable
    private class_3414 soundEvent;

    public DialogPlayer(class_3222 player, String fileId) {
        this.player = player;
        this.uuid = this.player.method_5667().toString();
        this.parse(fileId);
        INSTANCES.put(this.uuid, this);
    }

    public DialogPlayer(class_3222 player, DialogFiles.Entry entry) {
        this(player, entry.getFileId());
    }

    public DialogPlayer(class_3222 player, DialogFiles.Entry entry, @Nullable class_3414 soundEvent) {
        this(player, entry.getFileId());
        this.soundEvent = soundEvent;
    }

    public synchronized void start() {
        this.iterator = this.source.listIterator();
        if (this.soundEvent != null) {
            this.player.method_56078(this.soundEvent);
        }
        DelayedTask.createFromSecond(Touhou.getServer(), 0.75f, () -> {
            this.paused = false;
        });
    }

    public synchronized void parse(String fileId) {
        DialogFiles.Entry file = DialogFiles.getFile(fileId);
        if (file == null) {
            return;
        }
        LinkedList<LinkedList<String>> data = new LinkedList<>();
        try {
            JsonElement json = file.json();
            if (json instanceof JsonArray main) {
                for (JsonElement element : main) {
                    LinkedList<String> frame = new LinkedList<>();
                    if (element instanceof JsonArray frameElement) {
                        for (JsonElement lineStr : frameElement) {
                            String line = lineStr.getAsString();
                            line = line.replaceAll("■", "■■");
                            frame.add(line);
                        }
                    }
                    data.add(frame);
                }
            }
            this.source = new LinkedList<>(data);
        } catch (Exception err) {
            log.error("Can't parse dialog video {}", fileId, err);
        }
    }

    public synchronized void next() {
        next(20);
    }

    public synchronized void next(int frame) {
        if (iterator == null) return;
        int moved = 0;
        while (moved < frame && iterator.hasNext()) {
            iterator.next();
            moved++;
        }
    }

    public synchronized void previous() {
        previous(20);
    }

    public synchronized void previous(int frame) {
        if (this.iterator == null) return;
        int moved = 0;
        while (moved < frame && this.iterator.hasPrevious()) {
            this.iterator.previous();
            moved++;
        }
    }

    public synchronized void tick() {
        if (this.player.method_14239()) {
            INSTANCES.remove(this.uuid);
            return;
        }
        if (this.iterator == null) {
            return;
        }
        if (this.paused) {
            return;
        }
//        if (this.state <= 1) {
//            this.state++;
//            return;
//        } else {
//            this.state = 0;
//        }
        this.state++;
//        System.out.println(this.state);
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10582("uid", this.player.method_5845());

        class_11428 result = new class_11428(
                new class_11417(
                        class_2561.method_43470(""),
                        Optional.of(class_2561.method_43473()),
                        true, false,
                        class_11520.field_60962,
                        new ArrayList<>(List.of()),
                        new ArrayList<>(List.of())
                ),
                new class_11519(
                        new class_11416(class_2561.method_43473().method_10852(class_2561.method_43471("dialog.text.back")), 200),
                        Optional.of(new class_11525(new class_2558.class_11506(Touhou.id("stop/dialog_video"), Optional.of(nbtCompound))))
                )
        );

        if (this.iterator.hasNext()) {
            LinkedList<String> next = this.iterator.next();
            class_5250 mutableText = class_2561.method_43473();
            for (String line : next) {
                mutableText.method_10852(class_2561.method_43470(line + "\n"));
            }
            result.comp_4305().comp_4304().add(
                    new class_11435(mutableText, 1024)
            );
            this.player.method_71753(class_6880.method_40223(result));
        } else {
            INSTANCES.remove(this.uuid);
//            System.out.println("removed");
        }
    }

    public void remove() {
        INSTANCES.remove(this.uuid);
    }
}
