package cc.thonly.reverie_dreams.entity;

import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.util.entity.AnimationHelper;
import cc.thonly.reverie_dreams.util.entity.ModelUtil;
import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.api.AnimatedEntityHolder;
import de.tomalbrc.bil.core.holder.entity.EntityHolder;
import de.tomalbrc.bil.core.holder.entity.living.LivingEntityHolder;
import de.tomalbrc.bil.core.model.Model;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import lombok.Getter;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.entity.ai.goal.*;
import java.util.WeakHashMap;

@Getter
public class HairballEntity extends class_1314 implements AnimatedEntity {
    public static final WeakHashMap<class_1297, EntityHolder<HairballEntity>> ELEMENTS = new WeakHashMap<>();
    public static final Model BLUE = ModelUtil.loadModel(Touhou.id("hairball"));
    private final Model hairballModel;
    private EntityHolder<HairballEntity> holder;

    protected HairballEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        this(entityType, world, BLUE);
    }

    protected HairballEntity(class_1299<? extends class_1314> entityType, class_1937 world, Model hairballModel) {
        super(entityType, world);
        this.hairballModel = hairballModel;
        this.method_5941(class_7.field_18, 0.0F);
        this.init();
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1366(this, 1.0, true));
        this.field_6201.method_6277(5, new class_1376(this));
        this.field_6201.method_6277(6, new class_1394(this, 0.8));
        this.field_6201.method_6277(10, new class_1361(this, class_1657.class, 12.0f));

        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));

    }

    private void init() {
        this.holder = new LivingEntityHolder<>(this, this.hairballModel);
        EntityAttachment.ofTicking(this.holder, this);
        ELEMENTS.put(this,holder);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.field_6012 % 2 == 0) {
            AnimationHelper.updateWalkAnimation(this, this.holder); // util methods, see below
            AnimationHelper.updateHurtVariant(this, this.holder); // util methods
        }
    }

    public static class_5132 createAttributes() {
        return class_1309.method_26827()
                .method_26868(class_5134.field_23716, 15)
                .method_26868(class_5134.field_23719, 0.2)
                .method_26868(class_5134.field_23721, 3.5)
                .method_26868(class_5134.field_23717, 15)
                .method_26866();
    }

    @Override
    public AnimatedEntityHolder getHolder() {
        return this.holder;
    }
}
