package cc.thonly.reverie_dreams.entity;

import cc.thonly.mystias_izakaya.item.MIItems;
import cc.thonly.reverie_dreams.Touhou;
import cc.thonly.reverie_dreams.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.entity.ai.goal.DanmakuGoal;
import cc.thonly.reverie_dreams.entity.ai.goal.DifferentRevengeGoal;
import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.server.DelayedTask;
import cc.thonly.reverie_dreams.util.entity.ModelUtil;
import com.mojang.authlib.properties.Property;
import de.tomalbrc.bil.core.model.Model;
import lombok.Getter;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_9817;
import net.minecraft.entity.ai.goal.*;

@Getter
public class SunflowerYouseiEntity extends NPCEntityImpl implements class_9817, FriendlyFaction, Yousei {
    public static final class_2960 ID = Touhou.id("yousei_wing");
    public static final Model MODEL = ModelUtil.loadModel(ID);

    public SunflowerYouseiEntity(class_1299<? extends class_1321> entityType, class_1937 world, Property skin) {
        super(entityType, world, skin);
        NPCInventoryImpl inventory = this.getInventory();
        inventory.setHead(class_1802.field_17525.method_7854());
        inventory.setMainHand(class_1802.field_17525.method_7854());
    }

    @Override
    protected void method_5959() {
        super.method_5959();

        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1386(this));
//        this.goalSelector.add(2, new SmartFlyGoal(this, 1.5));

//        this.goalSelector.add(8, new WanderAroundFarGoal(this, 1.0));

        this.field_6201.method_6277(3, new DanmakuGoal(this, (self, target, world) -> {
            class_1799 stack = DanmakuTypes.random(DanmakuTypes.BUBBLE);
            float[] pitchYaw = MobDanmakuShooter.getPitchYaw(self, target);
            DelayedTask.repeat(world.method_8503(), 2, 0.8f, () -> {
                MobDanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] - 15.0f, 0.5f, 5.0f, 0.2f);
                MobDanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1], 0.5f, 5.0f, 0.2f);
                MobDanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] + 15.0f, 0.5f, 5.0f, 0.2f);
            });
        }));
        this.field_6201.method_6277(3, new class_1361(this, class_1657.class, 10.0f));
        this.field_6201.method_6277(4, new class_1361(this, class_1308.class, 10.0f));
        this.field_6201.method_6277(5, new class_1376(this));

        this.field_6185.method_6277(1, new DifferentRevengeGoal(this).setGroupRevenge());
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, class_1439.class, true));
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        int i = this.field_5974.method_39332(1, 9);
        if (i<=3) {
            class_1937 world = this.method_37908();
            class_1799 itemStack = new class_1799(MIItems.MOONFLOWER, this.field_5974.method_39332(1,2));
            class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
            world.method_8649(itemEntity);
        }
    }

    @Override
    public Boolean canPickItem() {
        return false;
    }

    @Override
    public String getFactionId() {
        return "mob";
    }

    @Override
    public boolean method_17326() {
        return false;
    }

}
