package cc.thonly.reverie_dreams.entity.ai.goal;

import cc.thonly.reverie_dreams.entity.MobDanmakuShooter;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;

@Getter
@Setter
@ToString
public class DanmakuGoal extends class_1352 {
    public static final MobDanmakuShooter DEFAULT_MOB_DANMAKU_FIRE_LAUNCHER = MobDanmakuShooter.DEFAULT;
    private final class_1309 self;
    private final class_1308 mob;
    @Nullable
    private class_1309 attackTarget;
    private final MobDanmakuShooter launcher;

    private final int minDelayTicks;
    private final int maxDelayTicks;
    private int updateCountdownTicks = -1;

    public DanmakuGoal(class_1309 self, @Nullable MobDanmakuShooter launcher) {
        this(self, launcher, 20, 20 * 3);
    }

    public DanmakuGoal(class_1309 self, @Nullable MobDanmakuShooter launcher, int minDelayTicks, int maxDelayTicks) {
        this.self = self;
        this.mob = (class_1308) self;
        this.launcher = launcher != null ? launcher : DEFAULT_MOB_DANMAKU_FIRE_LAUNCHER;
        this.minDelayTicks = minDelayTicks;
        this.maxDelayTicks = maxDelayTicks;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        class_1309 livingEntity = this.mob.method_5968();
        if (livingEntity == null || !livingEntity.method_5805()) {
            return false;
        }
        if (livingEntity instanceof class_1657 player) {
            if (player.method_56992()) {
                return false;
            }
        }
        this.attackTarget = livingEntity;
        return true;
    }

    @Override
    public void method_6269() {
        this.resetCooldown();
    }

    @Override
    public void method_6270() {
        this.attackTarget = null;
        this.updateCountdownTicks = -1;
    }

    @Override
    public boolean method_6266() {
        return this.attackTarget != null && this.attackTarget.method_5805();
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    private void resetCooldown() {
        this.updateCountdownTicks = minDelayTicks + this.self.method_59922().method_43048(maxDelayTicks - minDelayTicks + 1);
    }

    @Override
    public void method_6268() {
        if (this.attackTarget == null || !this.attackTarget.method_5805()) {
            return;
        }

        float[] pitchYaw = MobDanmakuShooter.getPitchYaw(this.self, this.attackTarget);
        this.mob.method_5988().method_35111(this.attackTarget);
        this.mob.method_36457(pitchYaw[0]);
        this.mob.method_36456(pitchYaw[1]);

        double distanceSq = this.self.method_5858(this.attackTarget);
        if (distanceSq > 64.0) {
            if (this.mob.method_5942().method_6357()) {
                this.mob.method_5942().method_6335(this.attackTarget, 1.5);
            }
        } else {
            this.mob.method_5942().method_6340();
        }

        if (--this.updateCountdownTicks <= 0) {
            class_1937 world = this.self.method_37908();
            if (world instanceof class_3218 serverWorld) {
                this.launcher.fire(this.self, this.attackTarget, serverWorld);
                this.launcher.sound(this.self);
            }
            this.resetCooldown();
        }
    }
}
