package cc.thonly.reverie_dreams.entity.ai.goal;

import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import cc.thonly.reverie_dreams.entity.npc.NPCState;
import cc.thonly.reverie_dreams.entity.npc.NPCStates;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_7;

public class NPCFollowOwnerGoal extends class_1352 {
    private final class_1321 tameable;
    @Nullable
    private class_1309 owner;
    private final double speed;
    private final class_1408 navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private float oldWaterPathfindingPenalty;

    public NPCFollowOwnerGoal(class_1321 tameable, double speed, float minDistance, float maxDistance) {
        this.tameable = tameable;
        this.speed = speed;
        this.navigation = tameable.method_5942();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(tameable.method_5942() instanceof class_1409) && !(tameable.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    @Override
    public boolean method_6264() {
        class_1309 livingEntity = this.tameable.method_35057();
        if (livingEntity == null) {
            return false;
        }
        if (this.tameable.method_24345()) {
            return false;
        }
        if (this.tameable.method_6052() != null) {
            if (this.tameable.method_6052().method_5805()) {
                return false;
            }
            return false;
        }
        if (this.tameable.method_5968() != null) {
            if (this.tameable.method_5968().method_5805()) {
                return false;
            }
            return false;
        }
        if (this.tameable.method_60715()) {
            return false;
        }
        if (this.tameable.method_5858(livingEntity) < (double) (this.minDistance * this.minDistance)) {
            return false;
        }
        if (this.tameable instanceof NPCEntityImpl impl) {
            NPCState state = impl.getNpcState();
            if (state == NPCStates.NO_WALK || state == NPCStates.SEATED || state == NPCStates.WORKING) {
                return false;
            }
            if (state == NPCStates.FOLLOW) {
                return true;
            }
        }
        this.owner = livingEntity;
        return false;
    }

    @Override
    public boolean method_6266() {
        if (this.navigation.method_6357()) {
            return false;
        }
        if (this.tameable.method_60715()) {
            return false;
        }
        return !(this.tameable.method_5858(this.owner) <= (double) (this.maxDistance * this.maxDistance));
    }

    @Override
    public void method_6269() {
        this.updateCountdownTicks = 0;
        this.oldWaterPathfindingPenalty = this.tameable.method_5944(class_7.field_18);
        this.tameable.method_5941(class_7.field_18, 0.0f);
    }

    @Override
    public void method_6270() {
        this.owner = null;
        this.navigation.method_6340();
        this.tameable.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
    }

    @Override
    public void method_6268() {
        if (this.owner == null && this.tameable != null) {
            this.owner = this.tameable.method_35057();
        }
        if (this.tameable == null || this.owner == null) {
            return;
        }
        boolean bl = this.tameable.method_60714();
        if (!bl) {
            this.tameable.method_5988().method_6226(this.owner, 10.0f, this.tameable.method_5978());
        }
        if (--this.updateCountdownTicks > 0) {
            return;
        }
        this.updateCountdownTicks = this.method_38847(10);
        if (bl) {
            if (!this.tameable.method_24345()) {
                this.tameable.method_60713();
            }
        } else {
            if (this.tameable.method_6052() == null) {
                this.navigation.method_6335(this.owner, this.speed);
            }
        }
    }
}

