package cc.thonly.reverie_dreams.entity.ai.goal;

import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import java.util.EnumSet;
import net.minecraft.class_1352;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_8177;

public class NPCOpenDoorGoal extends class_1352 {
    private final NPCEntityImpl roleEntity;
    private class_2338 doorPos;
    private boolean hasOpened;

    public NPCOpenDoorGoal(NPCEntityImpl roleEntity) {
        this.roleEntity = roleEntity;
        this.method_6265(EnumSet.of(class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        class_2338 front = this.roleEntity.method_24515().method_10093(this.roleEntity.method_5735());
        class_2680 state = this.roleEntity.method_37908().method_8320(front);

        if (state.method_26204() instanceof class_2323 door && !state.method_11654(class_2323.field_10945)) {
            this.doorPos = front;
            return true;
        }

        return false;
    }

    @Override
    public boolean method_6266() {
        if (this.doorPos == null || !this.hasOpened) return false;
        return roleEntity.method_5649(this.doorPos.method_10263() + 0.5, this.doorPos.method_10264(), this.doorPos.method_10260() + 0.5) <= 4.0;
    }

    @Override
    public void method_6269() {
        if (this.doorPos == null) return;

        class_2680 state = this.roleEntity.method_37908().method_8320(this.doorPos);
        if (state.method_26204() instanceof class_2323 doorBlock && !state.method_11654(class_2323.field_10945)) {
            this.roleEntity.method_37908().method_8652(
                    this.doorPos,
                    state.method_11657(class_2323.field_10945, true),
                    10
            );
            class_8177 blockSetType = doorBlock.method_51169();
            this.roleEntity.method_56078(blockSetType.comp_1292());
            this.hasOpened = true;
        }
    }

    @Override
    public void method_6268() {
        if (this.doorPos == null || !this.hasOpened) return;

        if (this.roleEntity.method_5649(this.doorPos.method_10263() + 0.5, this.doorPos.method_10264(), this.doorPos.method_10260() + 0.5) > 4.0) {
            class_2680 state = this.roleEntity.method_37908().method_8320(this.doorPos);
            if (state.method_26204() instanceof class_2323 doorBlock && state.method_11654(class_2323.field_10945)) {
                this.roleEntity.method_37908().method_8652(
                        this.doorPos,
                        state.method_11657(class_2323.field_10945, false),
                        10
                );
                class_8177 blockSetType = doorBlock.method_51169();
                this.roleEntity.method_56078(blockSetType.comp_1291());
            }
            this.doorPos = null;
            this.hasOpened = false;
        }
    }

    @Override
    public void method_6270() {
        if (this.doorPos != null && this.hasOpened) {
            // 停止时如果门还开着就关门
            class_2680 state = this.roleEntity.method_37908().method_8320(this.doorPos);
            Boolean isOpen = state.method_11654(class_2323.field_10945);
            if (state.method_26204() instanceof class_2323 doorBlock && isOpen) {
                this.roleEntity.method_37908().method_8652(
                        this.doorPos,
                        state.method_11657(class_2323.field_10945, false),
                        10
                );
                class_8177 blockSetType = doorBlock.method_51169();
                this.roleEntity.method_56078(blockSetType.comp_1291());
            }
        }
        this.doorPos = null;
        this.hasOpened = false;
    }
}
