package cc.thonly.reverie_dreams.entity.ai.goal;

import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2742;

public class SleepAtNightGoal extends class_1352 {
    private final NPCEntityImpl entity;
    private final double speed;
    private class_2338 bedPos;

    public SleepAtNightGoal(NPCEntityImpl entity, double speed) {
        this.entity = entity;
        this.speed = speed;
    }

    @Override
    public boolean method_6264() {
        if (!entity.method_37908().method_23886() || entity.method_6113()) {
            return false;
        }

        this.bedPos = findNearbyBed();
        return this.bedPos != null;
    }

    @Override
    public void method_6269() {
        if (this.bedPos != null) {
            this.entity.method_5942().method_6337(
                    bedPos.method_10263() + 0.5,
                    bedPos.method_10264(),
                    bedPos.method_10260() + 0.5,
                    this.speed
            );

        }
    }

    @Override
    public void method_6268() {
        if (this.bedPos == null) {
            return;
        }

        int bedWakeCd = this.entity.getBedWakeCd();
        if (bedWakeCd > 0) {
            this.entity.setBedWakeCd(bedWakeCd - 1);
            this.bedPos = null;
            return;
        }

        double distanceSq = this.entity.method_5707(class_243.method_24953(this.bedPos));
//        System.out.println("Distance to bed: " + Math.sqrt(distanceSq));
//        System.out.println("Current Pos: " + this.entity.getBlockPos() + ", Bed Pos: " + bedPos);
        if (distanceSq <= 2.25) {
//            System.out.println("Sleeping...");
            this.entity.method_18403(this.bedPos);
            this.entity.method_5942().method_6340();
            this.bedPos = null;
        }
    }

    @Override
    public boolean method_6266() {
        return this.bedPos != null && !entity.method_6113();
    }

    @Override
    public void method_6270() {
        this.bedPos = null;
    }

    private double dist(class_2338 a, class_2338 b) {
        double dx = a.method_10263() - b.method_10263();
        double dy = a.method_10264() - b.method_10264();
        double dz = a.method_10260() - b.method_10260();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private class_2338 findNearbyBed() {
        class_2338 entityPos = this.entity.method_24515();
        class_1937 world = this.entity.method_37908();
        List<class_2338> list = new ArrayList<>();
        for (int i = -10; i < 10; i++) {
            for (int j = -5; j < 5; j++) {
                for (int k = -10; k < 10; k++) {
                    list.add(entityPos.method_10069(i, j, k));
                }
            }
        }
        Map<Double, class_2338> hashMap = new HashMap<>();
        for (class_2338 pos : list) {
            class_2680 blockState = world.method_8320(pos);
            if (blockState.method_26204() instanceof class_2244) {
                boolean a = blockState.method_11654(class_2244.field_9968);
                boolean b = blockState.method_11654(class_2244.field_9967) == class_2742.field_12560;
                if (!a && b) {
                    hashMap.put(dist(pos, entityPos), pos);
                }
            }
        }
        if (hashMap.isEmpty()) {
            return null;
        }
        double idx = hashMap.keySet().stream().min(Double::compareTo).get();
        return hashMap.get(idx);
    }
}
