package cc.thonly.reverie_dreams.entity.ai.goal.attack;

import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1675;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import java.util.EnumSet;

@Setter
@Getter
public class NPCBowAttackGoal<T extends class_1321> extends class_1352 {
    private final T actor;
    private final double speed;
    private int attackInterval;
    private final float squaredRange;
    private int cooldown = -1;
    private int targetSeeingTicker;
    private boolean movingToLeft;
    private boolean backward;
    private int combatTicks = -1;
    public NPCBowAttackGoal(T actor, double speed, int attackInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        if ((this.actor).method_5968() == null) {
            return false;
        }
        return this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.actor.method_24518(class_1802.field_8102);
    }

    @Override
    public boolean method_6266() {
        return (this.method_6264() || !this.actor.method_5942().method_6357()) && this.isHoldingBow();
    }

    @Override
    public void method_6269() {
        super.method_6269();
        this.actor.method_19540(true);
    }

    @Override
    public void method_6270() {
        super.method_6270();
        this.actor.method_19540(false);
        this.targetSeeingTicker = 0;
        this.cooldown = -1;
        this.actor.method_6021();
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    @Override
    public void method_6268() {
        boolean bl2;
        class_1309 livingEntity = this.actor.method_5968();
        if (livingEntity == null) {
            return;
        }
        double d = this.actor.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        boolean bl = this.actor.method_5985().method_6369(livingEntity);
        boolean bl3 = bl2 = this.targetSeeingTicker > 0;
        if (bl != bl2) {
            this.targetSeeingTicker = 0;
        }
        this.targetSeeingTicker = bl ? ++this.targetSeeingTicker : --this.targetSeeingTicker;
        if (d > (double)this.squaredRange || this.targetSeeingTicker < 20) {
            this.actor.method_5942().method_6335(livingEntity, this.speed);
            this.combatTicks = -1;
        } else {
            this.actor.method_5942().method_6340();
            ++this.combatTicks;
        }
        if (this.combatTicks >= 20) {
            if ((double)(this.actor).method_59922().method_43057() < 0.3) {
                boolean bl4 = this.movingToLeft = !this.movingToLeft;
            }
            if ((double)(this.actor).method_59922().method_43057() < 0.3) {
                this.backward = !this.backward;
            }
            this.combatTicks = 0;
        }
        if (this.combatTicks > -1) {
            if (d > (double)(this.squaredRange * 0.75f)) {
                this.backward = false;
            } else if (d < (double)(this.squaredRange * 0.25f)) {
                this.backward = true;
            }
            (this.actor).method_5962().method_6243(this.backward ? -0.5f : 0.5f, this.movingToLeft ? 0.5f : -0.5f);
            class_1297 entity = (this.actor).method_49694();
            if (entity instanceof class_1308) {
                class_1308 mobEntity = (class_1308)entity;
                mobEntity.method_5951(livingEntity, 30.0f, 30.0f);
            }
            (this.actor).method_5951(livingEntity, 30.0f, 30.0f);
        } else {
            (this.actor).method_5988().method_6226(livingEntity, 30.0f, 30.0f);
        }
        if ((this.actor).method_6115()) {
            int i;
            if (!bl && this.targetSeeingTicker < -60) {
                (this.actor).method_6021();
            } else if (bl && (i = (this.actor).method_6048()) >= 20) {
                NPCInventoryImpl inventory = ((NPCEntityImpl) this.actor).getInventory();
                class_1799 arrowStack = RangedAttackUtil.getArrowStack(((NPCEntityImpl) this.actor));
                if (arrowStack==null){
                    return;
                }

//                if(inventory.containsAny(NPCEntityImpl.ARROW_ITEMS)) {
//
//                    for (int j = 0; j < inventory.size(); j++) {
//                        ItemStack stack = inventory.getStack(j);
//                        if(NPCEntityImpl.ARROW_ITEMS.contains(stack.getItem())) {
//                            stack.decrement(1);
//                            canNext = true;
//                            break;
//                        }
//                    }
//                }
//                if(!canNext) return;
                (this.actor).method_6021();
                ((class_1603)this.actor).method_7105(livingEntity, class_1753.method_7722(i));
                this.cooldown = this.attackInterval;
            }
        } else if (--this.cooldown <= 0 && this.targetSeeingTicker >= -60) {
            (this.actor).method_6019(class_1675.method_18812(this.actor, class_1802.field_8102));
        }
    }
}
