package cc.thonly.reverie_dreams.entity.ai.goal.attack;

import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1675;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_4802;
import net.minecraft.class_6019;
import net.minecraft.class_9278;
import net.minecraft.class_9334;

public class NPCCrossbowAttackGoal extends class_1352 {
	public static final class_6019 COOLDOWN_RANGE = class_4802.method_24505(1, 2);
	private NPCCrossbowAttackGoal.Stage stage = NPCCrossbowAttackGoal.Stage.UNCHARGED;
	private final NPCEntityImpl maid;
	private final double speed;
	private final float squaredRange;
	private int seeingTargetTicker;
	private int chargedTicksLeft;
	private int cooldown;

	public NPCCrossbowAttackGoal(NPCEntityImpl maid, double speed, float range) {
		this.maid = maid;

		this.speed = speed;
		this.squaredRange = range * range;
		this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
	}

	@Override
	public boolean method_6264() {
		return this.hasAliveTarget() && this.isEntityHoldingCrossbow();
	}

	private boolean isEntityHoldingCrossbow() {
		return this.maid.method_24518(class_1802.field_8399);
	}

	@Override
	public boolean method_6266() {
		return this.hasAliveTarget() && (this.method_6264() || !this.maid.method_5942().method_6357()) && this.isEntityHoldingCrossbow();
	}

	private boolean hasAliveTarget() {
		return this.maid.method_5968() != null && this.maid.method_5968().method_5805();
	}

	@Override
	public void method_6270() {
		super.method_6270();
		this.maid.method_19540(false);
		this.maid.method_5980(null);
		this.seeingTargetTicker = 0;
		if (this.maid.method_6115()) {
			this.maid.method_6021();
			this.maid.method_6030().method_57379(class_9334.field_49649, class_9278.field_49298);
		}
	}

	@Override
	public boolean method_38846() {
		return true;
	}

	@Override
	public void method_6268() {
		class_1309 livingEntity = this.maid.method_5968();
		if (livingEntity != null) {
			boolean bl = this.maid.method_5985().method_6369(livingEntity);
			boolean bl2 = this.seeingTargetTicker > 0;
			if (bl != bl2) {
				this.seeingTargetTicker = 0;
			}

			if (bl) {
				this.seeingTargetTicker++;
			} else {
				this.seeingTargetTicker--;
			}

			double d = this.maid.method_5858(livingEntity);
			boolean bl3 = (d > this.squaredRange || this.seeingTargetTicker < 5) && this.chargedTicksLeft == 0;
			if (bl3) {
				this.cooldown--;
				if (this.cooldown <= 0) {
					this.maid.method_5942().method_6335(livingEntity, this.isUncharged() ? this.speed : this.speed * 0.5);
					this.cooldown = COOLDOWN_RANGE.method_35008(this.maid.method_59922());
				}
			} else {
				this.cooldown = 0;
				this.maid.method_5942().method_6340();
			}

			this.maid.method_5988().method_6226(livingEntity, 30.0F, 30.0F);
			if (this.stage == NPCCrossbowAttackGoal.Stage.UNCHARGED) {
				if (!bl3) {
					this.maid.method_6019(class_1675.method_18812(this.maid, class_1802.field_8399));
					this.stage = NPCCrossbowAttackGoal.Stage.CHARGING;
				}
			} else if (this.stage == NPCCrossbowAttackGoal.Stage.CHARGING) {
				if (!this.maid.method_6115()) {
					this.stage = NPCCrossbowAttackGoal.Stage.UNCHARGED;
				}

				int i = this.maid.method_6048();
				class_1799 itemStack = this.maid.method_6030();


//				Integer slot = inventory.findSlot(stack -> NPCEntityImpl.ARROW_ITEMS.contains(stack.getItem()));
//				if (slot!=null){
//					ItemStack stack = inventory.getStack(slot);
//					stack.decrement(1);
//				}else return;
				if (i >= class_1764.method_7775(itemStack, this.maid)) {
					this.maid.method_6075();
					if (chargeCrossBow()){
						this.stage = NPCCrossbowAttackGoal.Stage.CHARGED;
						this.chargedTicksLeft = 10 + this.maid.method_59922().method_43048(20);
					}
				}
			} else if (this.stage == NPCCrossbowAttackGoal.Stage.CHARGED) {
				this.chargedTicksLeft--;
				if (this.chargedTicksLeft == 0) {
					this.stage = NPCCrossbowAttackGoal.Stage.READY_TO_ATTACK;
				}
			} else if (this.stage == NPCCrossbowAttackGoal.Stage.READY_TO_ATTACK && bl) {
				this.maid.method_7105(livingEntity, 1.0F);
				this.stage = NPCCrossbowAttackGoal.Stage.UNCHARGED;
			}
		}
	}

	private boolean isUncharged() {
		return this.stage == NPCCrossbowAttackGoal.Stage.UNCHARGED;
	}

	static enum Stage {
		UNCHARGED,
		CHARGING,
		CHARGED,
		READY_TO_ATTACK;
	}
	private boolean chargeCrossBow(){
		class_1268 crossBowHand = class_1675.method_18812(this.maid, class_1802.field_8399);
		class_1799 crossBow = maid.method_5998(crossBowHand);
		class_1799 arrowStack = RangedAttackUtil.getCrossBowAmmoStack(this.maid);
		if (arrowStack!=null&&RangedAttackUtil.loadProjectiles(crossBow, arrowStack, maid)){
//			arrowStack.decrement(1);
			return true;
		}else return false;

	}
}
