package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.NPCEntityImpl;
import cc.thonly.reverie_dreams.entity.npc.NPCWorkModes;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.server.ItemTagManager;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public class NPCChestClassificationGoal extends class_1352 {

    private final NPCEntityImpl roleEntity;
    @Nullable
    private OperationalTarget currentTarget = null;

    public NPCChestClassificationGoal(NPCEntityImpl roleEntity) {
        this.roleEntity = roleEntity;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    private List<class_2338> findChestBlockPosList() {
        List<class_2338> list = new LinkedList<>();
        class_1937 world = this.roleEntity.method_37908();
        class_2338 center = this.roleEntity.getWorkingPos();
        int r = 8;
        class_3341 box = new class_3341(center.method_10263() - r, center.method_10264() - r, center.method_10260() - r,
                center.method_10263() + r, center.method_10264() + r, center.method_10260() + r);
        class_2338.class_2339 pos = new class_2338.class_2339();

        for (int x = box.method_35415(); x <= box.method_35418(); x++) {
            for (int y = box.method_35416(); y <= box.method_35419(); y++) {
                for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                    pos.method_10103(x, y, z);
                    if (world.method_8320(pos).method_26204() == class_2246.field_10034 &&
                            world.method_8321(pos) instanceof class_2595) {
                        list.add(pos.method_10062());
                    }
                }
            }
        }

        // 按照距离工作点排序，最近的排在前面
        list.sort((a, b) -> Double.compare(
                a.method_10262(center),
                b.method_10262(center)
        ));

//        System.out.println("[NPCChestClassificationGoal] Found chests (sorted): " + list.size());
        if (!list.isEmpty()) {
//            System.out.println("[NPCChestClassificationGoal] Nearest chest at: " + list.get(0));
        }
        return list;
    }


    @Override
    public boolean method_6264() {
        boolean can = EntityTargetUtil.isThisWorkMode(this.roleEntity, NPCWorkModes.CHEST_CLASSIFICATION);
//        System.out.println("[canStart] Work mode check: " + can);
        MinecraftServer server = this.roleEntity.method_5682();
        if (server != null && ItemTagManager.getInstance().isEmpty()) {
            ItemTagManager.getInstance().load(server);
//            System.out.println("[canStart] ItemTagManager loaded");
        }
        return can;
    }

    @Override
    public boolean method_6266() {
        boolean cont = EntityTargetUtil.isThisWorkMode(this.roleEntity, NPCWorkModes.CHEST_CLASSIFICATION);
        // 少量日志，别太频繁打印（可按需打开）
        // System.out.println("[shouldContinue] " + cont);
        return cont;
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    /**
     * 找到下一个可以放置至少 1 个物品的目标：
     *  返回（inventorySlot, chestPos, chestEntity, slotIndex）
     *  要求： chestSlot 是空的 OR chestSlot 与 heldItem 相同且有剩余空间 (>0)
     */
    private OperationalTarget findNextTarget(NPCInventoryImpl inventory) {
        List<class_2338> chests = findChestBlockPosList();

        for (int invIndex = 0; invIndex < inventory.method_5439(); invIndex++) {
            class_1799 held = inventory.method_5438(invIndex);
            if (held.method_7960()) continue;

//            System.out.println("[findNextTarget] trying held slot " + invIndex + ": " + held.getCount() + "x " + held.getItem());

            for (class_2338 chestPos : chests) {
                class_2586 be = this.roleEntity.method_37908().method_8321(chestPos);
                if (!(be instanceof class_2595 chest)) continue;

                boolean chestEmpty = true;
                boolean chestCompatible = true;

                // 扫一遍箱子，看是否已有不同物品
                for (int s = 0; s < chest.method_5439(); s++) {
                    class_1799 cs = chest.method_5438(s);
                    if (!cs.method_7960()) {
                        chestEmpty = false;
                        if (!class_1799.method_31577(cs, held)) {
                            chestCompatible = false; // 已有不同物品，不兼容
                            break;
                        }
                    }
                }

                if (!chestCompatible) continue; // 跳过这个箱子

                // 到这里说明箱子是空的，或全是同类物品
                for (int slot = 0; slot < chest.method_5439(); slot++) {
                    class_1799 chestStack = chest.method_5438(slot);
                    if (chestStack.method_7960()) {
//                        System.out.println("[findNextTarget] choose empty slot " + slot + " in chest " + chestPos);
                        return new OperationalTarget(invIndex, chestPos, chest, slot);
                    }
                    if (class_1799.method_31577(chestStack, held)) {
                        int space = chestStack.method_7914() - chestStack.method_7947();
                        if (space > 0) {
//                            System.out.println("[findNextTarget] choose partial slot " + slot + " in chest " + chestPos + ", space=" + space);
                            return new OperationalTarget(invIndex, chestPos, chest, slot);
                        }
                    }
                }
            }
        }

//        System.out.println("[findNextTarget] no suitable target found");
        return null;
    }

    @Override
    public void method_6268() {
//        System.out.println("=== Tick start ===");

        NPCInventoryImpl inventory = this.roleEntity.getInventory();
//        System.out.println("[tick] Inventory items:");
        for (int i = 0; i < inventory.method_5439(); i++) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_7960()) {
//                System.out.println("  Slot " + i + ": " + stack.getCount() + "x " + stack.getItem().toString());
            }
        }

        // 如果没有当前目标或持有物为空 -> 重新选择
        if (this.currentTarget == null) {
            this.currentTarget = findNextTarget(inventory);
            if (this.currentTarget == null) {
//                System.out.println("[tick] No target found -> nothing to do");
//                System.out.println("=== Tick end ===");
                return;
            } else {
//                System.out.println("[tick] New target: invSlot=" + currentTarget.inventorySlot
//                        + " item=" + inventory.getStack(currentTarget.inventorySlot).getItem()
//                        + " count=" + inventory.getStack(currentTarget.inventorySlot).getCount()
//                        + " chest=" + currentTarget.blockPos
//                        + " slot=" + currentTarget.slotIndex);
            }
        }

        // 再次校验：目标对应的背包槽是否还有物品（物品可能在别处被用掉）
        class_1799 held = inventory.method_5438(this.currentTarget.inventorySlot);
        if (held.method_7960()) {
//            System.out.println("[tick] Target's inventory slot is empty, clearing target");
            this.currentTarget = null;
//            System.out.println("=== Tick end ===");
            return;
        }

        // 移动到目标箱子
        if (!isReached(this.currentTarget.blockPos)) {
//            System.out.println("[tick] Moving to chest at " + currentTarget.blockPos);
            this.roleEntity.method_5942().method_6337(
                    this.currentTarget.blockPos.method_10263() + 0.5,
                    this.currentTarget.blockPos.method_10264() + 0.5,
                    this.currentTarget.blockPos.method_10260() + 0.5,
                    1.0D
            );
//            System.out.println("=== Tick end ===");
            return;
        } else {
//            System.out.println("[tick] Reached chest at " + currentTarget.blockPos);
        }

        // 在到达箱子且仍有持物时，尝试放入 —— 如果当前 slot 不可用，先在同箱体内找下一个可用槽
        class_2595 chest = this.currentTarget.chest;
        int slotIndex = this.currentTarget.slotIndex;

        // 如果当前 slot 不可用（不同物、或相同但无空间），尝试同箱内下一个可用槽
        class_1799 chestStack = chest.method_5438(slotIndex);
        boolean slotSuitable = false;
        if (chestStack.method_7960()) {
            slotSuitable = true;
        } else if (class_1799.method_31577(chestStack, held) && chestStack.method_7947() < chestStack.method_7914()) {
            slotSuitable = true;
        }

        if (!slotSuitable) {
//            System.out.println("[tick] Current slot " + slotIndex + " not suitable (item=" + (chestStack.isEmpty() ? "empty" : chestStack.getItem())
//                    + ", count=" + (chestStack.isEmpty() ? 0 : chestStack.getCount()) + "), searching next slot in same chest");
            Integer nextSlot = findNextSlotInSameChest(chest, held);
            if (nextSlot != null) {
//                System.out.println("[tick] Found next workable slot " + nextSlot + " in same chest");
                this.currentTarget = new OperationalTarget(this.currentTarget.inventorySlot, this.currentTarget.blockPos, chest, nextSlot);
                slotIndex = nextSlot;
                chestStack = chest.method_5438(slotIndex);
            } else {
//                System.out.println("[tick] No workable slot in this chest, clearing current target to find another chest");
                this.currentTarget = null;
//                System.out.println("=== Tick end ===");
                return;
            }
        }

        // 到这里， chestStack 是当前 slot 的最新引用（可能为空或有空间）
        chestStack = chest.method_5438(slotIndex);
        held = inventory.method_5438(this.currentTarget.inventorySlot); // refresh
        if (held.method_7960()) {
//            System.out.println("[tick] Held became empty before placing, clearing target");
            this.currentTarget = null;
//            System.out.println("=== Tick end ===");
            return;
        }

        // 放入逻辑：计算实际放入数量 move
        if (chestStack.method_7960()) {
            int move = Math.min(held.method_7947(), held.method_7914()); // 放一堆或全部（视需求可改为只放1）
            class_1799 toSet = held.method_7972();
            toSet.method_7939(move);
            chest.method_5447(slotIndex, toSet);
            held.method_7934(move);
//            System.out.println("[tick] Placed " + move + "x " + toSet.getItem() + " into empty slot " + slotIndex);
        } else { // same item and has space guaranteed
            int space = chestStack.method_7914() - chestStack.method_7947();
            int move = Math.min(space, held.method_7947());
            if (move > 0) {
                chestStack.method_7933(move);
                held.method_7934(move);
//                System.out.println("[tick] Added " + move + "x " + chestStack.getItem() + " to slot " + slotIndex + " (now " + chestStack.getCount() + ")");
            } else {
                // 理论不应到这里（我们以前检查过有空间），但保险处理
//                System.out.println("[tick] Unexpected: computed move == 0, clearing target");
                currentTarget = null;
//                System.out.println("=== Tick end ===");
                return;
            }
        }

        chest.method_5431();
        this.roleEntity.method_6104(class_1268.field_5808);
        this.roleEntity.method_56078(class_3417.field_14982);

        // 如果背包该槽已空 -> 目标完成，马上找下一个目标（下个 tick 也会找）
        if (inventory.method_5438(this.currentTarget.inventorySlot).method_7960()) {
//            System.out.println("[tick] Finished placing current held slot " + currentTarget.inventorySlot + ", clearing target");
            this.currentTarget = null;
        } else {
//            System.out.println("[tick] Still items left in inv slot " + currentTarget.inventorySlot + ", keep target for next tick");
            // 保留 currentTarget（仍指向同箱同槽），下一 tick 继续（如果槽填满，会自动跳到 next slot）
        }

//        System.out.println("=== Tick end ===");
    }

    /**
     * 在同一个 chest 中查找下一个可放的位置（空槽或同类且有空间）。
     * 返回 slot index 或 null（没有可用槽）。
     */
    private Integer findNextSlotInSameChest(class_2595 chest, class_1799 held) {
        for (int s = 0; s < chest.method_5439(); s++) {
            class_1799 cs = chest.method_5438(s);
            if (cs.method_7960()) return s;
            if (class_1799.method_31577(cs, held) && cs.method_7947() < cs.method_7914()) return s;
        }
        return null;
    }

    private boolean isReached(class_2338 pos) {
        return pos.method_19770(this.roleEntity.method_19538()) <= 9;
    }

    private record OperationalTarget(int inventorySlot, class_2338 blockPos, class_2595 chest, int slotIndex) {}
}
